/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.opendocument.io;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import net.mapeadores.opendocument.io.OdSource;
import net.mapeadores.util.exceptions.NestedTransformerException;

public class TransformerOdSource
implements OdSource {
    private final Transformer transformer;
    private final Source transformerSource;

    public TransformerOdSource(Transformer transformer, Source transformerSource) {
        this.transformer = transformer;
        this.transformerSource = transformerSource;
    }

    @Override
    public void writeStream(OutputStream outputStream) throws IOException {
        try {
            this.transformer.transform(this.transformerSource, new StreamResult(outputStream));
        }
        catch (TransformerException te) {
            Throwable thr = te.getCause();
            if (thr != null && thr instanceof IOException) {
                throw (IOException)thr;
            }
            throw new NestedTransformerException(te);
        }
    }
}

