/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.opendocument.css.output;

import java.io.IOException;
import net.mapeadores.opendocument.css.output.ns.NameSpace;

public class XMLWriter {
    private Appendable appendable;
    private int indentLength;
    private boolean aposEscaped = true;

    public XMLWriter(Appendable appendable, int indentLength) {
        this.indentLength = indentLength;
        this.appendable = appendable;
    }

    public void setAposEscaped(boolean aposEscaped) {
        this.aposEscaped = aposEscaped;
    }

    public boolean isAposEscaped() {
        return this.aposEscaped;
    }

    public void appendXMLDeclaration() throws IOException {
        this.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    }

    public void appendStylesheet(String href, String type) throws IOException {
        this.appendIndent();
        this.append("<?xml-stylesheet href=\"");
        this.append(href);
        this.append("\" type=\"");
        this.append(type);
        this.append("\"?>");
    }

    public void appendCssStyleSheet(String href) throws IOException {
        this.appendStylesheet(href, "text/css");
    }

    public void appendDocType(String doctype) throws IOException {
        this.appendIndent();
        this.append("<!DOCTYPE ");
        this.append(doctype);
        this.append(">");
    }

    public void append(char c) throws IOException {
        this.appendable.append(c);
    }

    public void append(String s) throws IOException {
        this.appendable.append(s);
    }

    public void addEmptyElement(String tagname) throws IOException {
        this.startOpenTag(tagname);
        this.closeEmptyTag();
    }

    public void addSimpleElement(String tagname, String value) throws IOException {
        if (value == null || value.length() == 0) {
            return;
        }
        this.startOpenTag(tagname);
        this.endOpenTag(false);
        this.escape(value);
        this.closeTag(tagname, false, false);
    }

    public void addSimpleElement(String tagname, String attribute, String attributeValue, String value) throws IOException {
        this.startOpenTag(tagname);
        this.addAttribute(attribute, attributeValue);
        this.endOpenTag(false);
        this.escape(value);
        this.closeTag(tagname, false, false);
    }

    public void appendIndent() throws IOException {
        if (this.indentLength > -1) {
            this.append('\n');
            for (int i = 0; i < this.indentLength; ++i) {
                this.append('\t');
            }
        }
    }

    public int getCurrentIndentValue() {
        return this.indentLength;
    }

    public void increaseIndentValue() {
        ++this.indentLength;
    }

    public void decreaseIndentValue() {
        --this.indentLength;
    }

    public void startOpenTag(String name) throws IOException {
        this.startOpenTag(name, true);
    }

    public void startOpenTag(String name, boolean indentBefore) throws IOException {
        if (indentBefore) {
            this.appendIndent();
        }
        this.append('<');
        this.append(name);
    }

    public void endOpenTag() throws IOException {
        this.endOpenTag(true);
    }

    public void endOpenTag(boolean increaseIndent) throws IOException {
        this.append('>');
        if (increaseIndent) {
            this.increaseIndentValue();
        }
    }

    public void closeEmptyTag() throws IOException {
        this.append('/');
        this.append('>');
    }

    public void openTag(String name) throws IOException {
        this.openTag(name, true, true);
    }

    public void openTag(String name, boolean indentBefore, boolean indentIncrease) throws IOException {
        if (indentBefore) {
            this.appendIndent();
        }
        this.append('<');
        this.append(name);
        this.append('>');
        if (indentIncrease) {
            this.increaseIndentValue();
        }
    }

    public void closeTag(String name) throws IOException {
        this.closeTag(name, true, true);
    }

    public void closeTag(String name, boolean indentBefore, boolean indentDecrease) throws IOException {
        if (indentDecrease) {
            this.decreaseIndentValue();
        }
        if (indentBefore) {
            this.appendIndent();
        }
        this.append('<');
        this.append('/');
        this.append(name);
        this.append('>');
    }

    public void escape(CharSequence charSequence) throws IOException {
        if (charSequence == null) {
            return;
        }
        int length = charSequence.length();
        for (int i = 0; i < length; ++i) {
            char carac = charSequence.charAt(i);
            this.escape(carac);
        }
    }

    public void escape(char carac) throws IOException {
        if (carac < ' ') {
            this.append(' ');
        } else {
            switch (carac) {
                case '&': {
                    this.append("&amp;");
                    break;
                }
                case '\"': {
                    this.append("&quot;");
                    break;
                }
                case '\'': {
                    if (this.aposEscaped) {
                        this.append("&apos;");
                        break;
                    }
                    this.append(carac);
                    break;
                }
                case '<': {
                    this.append("&lt;");
                    break;
                }
                case '>': {
                    this.append("&gt;");
                    break;
                }
                case '\u00a0': {
                    this.append("&#x00A0;");
                    break;
                }
                default: {
                    this.append(carac);
                }
            }
        }
    }

    public void addNameSpaceAttribute(NameSpace nameSpace) throws IOException {
        this.addNameSpaceAttribute(nameSpace.getPrefix(), nameSpace.getName());
    }

    public void addNameSpaceAttribute(String prefix, String nameSpace) throws IOException {
        if (nameSpace == null || nameSpace.length() == 0) {
            return;
        }
        this.append(' ');
        this.append("xmlns");
        if (prefix != null && prefix.length() > 0) {
            this.append(':');
            this.append(prefix);
        }
        this.append('=');
        this.append('\"');
        this.escape(nameSpace);
        this.append('\"');
    }

    public void addAttribute(String attributeName, String value) throws IOException {
        if (value == null || value.length() == 0) {
            return;
        }
        this.append(' ');
        this.append(attributeName);
        this.append('=');
        this.append('\"');
        this.escape(value);
        this.append('\"');
    }

    public void addAttribute(String attributeName, char c) throws IOException {
        this.append(' ');
        this.append(attributeName);
        this.append('=');
        this.append('\"');
        this.escape(c);
        this.append('\"');
    }

    public void addAttribute(String attributeName, int i) throws IOException {
        this.append(' ');
        this.append(attributeName);
        this.append('=');
        this.append('\"');
        this.append(String.valueOf(i));
        this.append('\"');
    }
}

