/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.xml.storage;

import java.io.IOException;
import java.util.function.Predicate;
import net.fichotheque.SubsetItem;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class SphereListXMLPart
extends XMLPart {
    public SphereListXMLPart(XMLWriter xmlWriter) {
        super(xmlWriter);
    }

    public void appendSphereList(Sphere sphere, Predicate<SubsetItem> predicate) throws IOException {
        this.openTag("sphere-list");
        for (Redacteur redacteur : sphere.getRedacteurList()) {
            this.appendRedacteur(redacteur, predicate);
        }
        this.closeTag("sphere-list");
    }

    private void appendRedacteur(Redacteur redacteur, Predicate<SubsetItem> predicate) throws IOException {
        if (predicate != null && !predicate.test(redacteur)) {
            return;
        }
        String status = redacteur.getStatus();
        this.startOpenTag("redacteur");
        this.addAttribute("id", redacteur.getId());
        this.addAttribute("login", redacteur.getLogin());
        this.addAttribute("status", status);
        this.closeEmptyTag();
    }
}

