/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.xml.storage;

import java.io.IOException;
import java.util.List;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.Information;
import net.fichotheque.corpus.fiche.Para;
import net.fichotheque.corpus.fiche.Propriete;
import net.fichotheque.corpus.fiche.Section;
import net.fichotheque.xml.storage.FicheBlockStorageXMLPart;
import net.fichotheque.xml.storage.FicheItemStorageXMLPart;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLUtils;
import net.mapeadores.util.xml.XMLWriter;

public class FicheStorageXMLPart
extends XMLPart {
    private final FicheItemStorageXMLPart ficheItemXMLPart = new FicheItemStorageXMLPart(this);
    private final FicheBlockStorageXMLPart ficheBlockStorageXMLPart = new FicheBlockStorageXMLPart(this);

    public FicheStorageXMLPart(XMLWriter xmlWriter) {
        super(xmlWriter);
    }

    public void appendFiche(FicheAPI fiche) throws IOException {
        this.startOpenTag("fiche");
        XMLUtils.addXmlLangAttribute(this, fiche.getLang());
        this.endOpenTag();
        this.addEntete(fiche);
        this.addCorpsdefiche(fiche);
        this.closeTag("fiche");
    }

    private void addEntete(FicheAPI fiche) throws IOException {
        this.openTag("entete");
        this.addSimpleElement("titre", fiche.getTitre());
        Para soustitrePara = fiche.getSoustitre();
        if (soustitrePara != null) {
            this.startOpenTag("soustitre");
            this.endOpenTag();
            this.ficheBlockStorageXMLPart.addTextContent(soustitrePara);
            this.closeTag("soustitre", false);
        }
        for (Propriete propriete : fiche.getProprieteList()) {
            this.addPropriete(propriete);
        }
        for (Information information : fiche.getInformationList()) {
            this.addInformation(information);
        }
        FicheItems redacteursItemList = fiche.getRedacteurs();
        if (redacteursItemList != null) {
            this.openTag("redacteurs");
            this.ficheItemXMLPart.addFicheItems(redacteursItemList);
            this.closeTag("redacteurs");
        }
        this.closeTag("entete");
    }

    private void addCorpsdefiche(FicheAPI fiche) throws IOException {
        List<Section> sectionList = fiche.getSectionList();
        if (sectionList.isEmpty()) {
            return;
        }
        this.openTag("corpsdefiche");
        for (Section section : sectionList) {
            this.addSection(section);
        }
        this.closeTag("corpsdefiche");
    }

    private void addPropriete(Propriete propriete) throws IOException {
        FicheItem ficheItem = propriete.getFicheItem();
        this.startOpenTag("propriete");
        this.addAttribute("name", propriete.getFieldKey().getFieldName());
        this.endOpenTag();
        this.ficheItemXMLPart.addFicheItem(ficheItem);
        this.closeTag("propriete");
    }

    private void addInformation(Information information) throws IOException {
        this.startOpenTag("information");
        this.addAttribute("name", information.getFieldKey().getFieldName());
        this.endOpenTag();
        this.ficheItemXMLPart.addFicheItems(information);
        this.closeTag("information");
    }

    private void addSection(Section section) throws IOException {
        this.startOpenTag("section");
        this.addAttribute("name", section.getFieldKey().getFieldName());
        this.endOpenTag();
        this.ficheBlockStorageXMLPart.addFicheBlocks(section);
        this.closeTag("section");
    }
}

