/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.xml.storage;

import java.io.IOException;
import java.text.ParseException;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.fiche.Courriel;
import net.fichotheque.corpus.fiche.Datation;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.Geopoint;
import net.fichotheque.corpus.fiche.Image;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.fiche.Langue;
import net.fichotheque.corpus.fiche.Link;
import net.fichotheque.corpus.fiche.Montant;
import net.fichotheque.corpus.fiche.Nombre;
import net.fichotheque.corpus.fiche.Para;
import net.fichotheque.corpus.fiche.Pays;
import net.fichotheque.corpus.fiche.Personne;
import net.fichotheque.utils.SphereUtils;
import net.fichotheque.xml.storage.FicheBlockStorageXMLPart;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.models.PersonCore;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.primitives.DegreDecimal;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class FicheItemStorageXMLPart
extends XMLPart {
    private final FicheBlockStorageXMLPart ficheBlockStorageXMLPart;

    public FicheItemStorageXMLPart(XMLWriter xmlWriter) {
        super(xmlWriter);
        this.ficheBlockStorageXMLPart = new FicheBlockStorageXMLPart(xmlWriter);
    }

    public void addFicheItems(FicheItems ficheItems) throws IOException {
        int size = ficheItems.size();
        for (int i = 0; i < size; ++i) {
            this.addFicheItem((FicheItem)ficheItems.get(i), null);
        }
    }

    public void addFicheItems(FicheItems ficheItems, Object fieldOptionObject) throws IOException {
        int size = ficheItems.size();
        for (int i = 0; i < size; ++i) {
            this.addFicheItem((FicheItem)ficheItems.get(i), fieldOptionObject);
        }
    }

    public void addFicheItem(FicheItem ficheItem) throws IOException {
        this.addFicheItem(ficheItem, null);
    }

    public void addFicheItem(FicheItem ficheItem, Object fieldOptionObject) throws IOException {
        if (ficheItem instanceof Item) {
            this.addItem((Item)ficheItem);
        } else if (ficheItem instanceof Personne) {
            this.addPersonne((Personne)ficheItem);
        } else if (ficheItem instanceof Datation) {
            this.addDatation((Datation)ficheItem, fieldOptionObject);
        } else if (ficheItem instanceof Langue) {
            this.addLangue((Langue)ficheItem);
        } else if (ficheItem instanceof Pays) {
            this.addPays((Pays)ficheItem);
        } else if (ficheItem instanceof Link) {
            this.addLink((Link)ficheItem, fieldOptionObject);
        } else if (ficheItem instanceof Courriel) {
            this.addCourriel((Courriel)ficheItem);
        } else if (ficheItem instanceof Montant) {
            this.addMontant((Montant)ficheItem, fieldOptionObject);
        } else if (ficheItem instanceof Nombre) {
            this.addNombre((Nombre)ficheItem);
        } else if (ficheItem instanceof Geopoint) {
            this.addGeopoint((Geopoint)ficheItem);
        } else if (ficheItem instanceof Para) {
            this.addPara((Para)ficheItem);
        } else if (ficheItem instanceof Image) {
            this.addImage((Image)ficheItem, fieldOptionObject);
        } else {
            throw new ClassCastException("unknown instance of FicheItem = " + ficheItem.getClass().getName());
        }
    }

    public void addItem(Item item) throws IOException {
        this.addSimpleElement("item", item.getValue());
    }

    public void addCourriel(Courriel courriel) throws IOException {
        EmailCore emailCore = courriel.getEmailCore();
        String addrSpec = emailCore.getAddrSpec();
        this.startOpenTag("courriel");
        this.addAttribute("addr-spec", addrSpec);
        String realName = emailCore.getRealName();
        if (realName.length() > 0) {
            this.addAttribute("real-name", realName);
        }
        this.closeEmptyTag();
    }

    public void addDatation(Datation datation, Object fieldOptionObject) throws IOException {
        FuzzyDate date = datation.getDate();
        this.startOpenTag("datation");
        this.addAttribute("a", String.valueOf(date.getYear()));
        switch (date.getType()) {
            case 2: {
                this.addAttribute("type", "s");
                this.addAttribute("s", String.valueOf(date.getHalfYear()));
                break;
            }
            case 3: {
                this.addAttribute("type", "t");
                this.addAttribute("t", String.valueOf(date.getQuarter()));
                break;
            }
            case 4: {
                this.addAttribute("type", "m");
                this.addAttribute("m", String.valueOf(date.getMonth()));
                break;
            }
            case 5: {
                this.addAttribute("type", "j");
                this.addAttribute("m", String.valueOf(date.getMonth()));
                this.addAttribute("j", String.valueOf(date.getDay()));
                break;
            }
            default: {
                this.addAttribute("type", "a");
            }
        }
        this.closeEmptyTag();
    }

    public void addLangue(Langue langue) throws IOException {
        String code = langue.getLang().toString();
        this.startOpenTag("langue");
        this.addAttribute("lang", code);
        this.closeEmptyTag();
    }

    public void addNombre(Nombre nombre) throws IOException {
        this.startOpenTag("nombre");
        Decimal decimal = nombre.getDecimal();
        this.addDecimalAttributes(decimal);
        this.closeEmptyTag();
    }

    public void addGeopoint(Geopoint geopoint) throws IOException {
        this.startOpenTag("geopoint");
        DegreDecimal latitude = geopoint.getLatitude();
        DegreDecimal longitude = geopoint.getLongitude();
        this.addAttribute("lat", latitude.toString());
        this.addAttribute("lon", longitude.toString());
        this.closeEmptyTag();
    }

    public void addMontant(Montant montant, Object fieldOptionObject) throws IOException {
        this.startOpenTag("montant");
        Decimal decimal = montant.getDecimal();
        this.addDecimalAttributes(decimal);
        this.addAttribute("cur", montant.getCurrency().getCurrencyCode());
        this.closeEmptyTag();
    }

    private void addDecimalAttributes(Decimal decimal) throws IOException {
        String partieEntiere = decimal.getPartieEntiereString();
        String partieDecimale = decimal.getPartieDecimaleString();
        String val = partieDecimale.length() != 0 ? partieEntiere + "." + partieDecimale : partieEntiere;
        this.addAttribute("val", val);
    }

    public void addLink(Link link, Object fieldOptionObject) throws IOException {
        this.startOpenTag("link");
        this.addAttribute("href", link.getHref());
        if (link.hasHrefOnly()) {
            this.closeEmptyTag();
        } else {
            this.endOpenTag();
            this.addSimpleElement("title", link.getTitle());
            this.addSimpleElement("comment", link.getComment());
            this.closeTag("link");
        }
    }

    public void addImage(Image image, Object fieldOptionObject) throws IOException {
        this.startOpenTag("image");
        this.addAttribute("src", image.getSrc());
        if (image.hasSrcOnly()) {
            this.closeEmptyTag();
        } else {
            this.endOpenTag();
            this.addSimpleElement("alt", image.getAlt());
            this.addSimpleElement("title", image.getTitle());
            this.closeTag("image");
        }
    }

    public void addPays(Pays pays) throws IOException {
        this.startOpenTag("pays");
        this.addAttribute("country", pays.getCountry().toString());
        this.closeEmptyTag();
    }

    public void addPersonne(Personne personne) throws IOException {
        this.startOpenTag("personne");
        String redacteurGlobalId = personne.getRedacteurGlobalId();
        if (redacteurGlobalId != null) {
            try {
                SubsetKey sphereKey = SphereUtils.getSubsetKey(redacteurGlobalId);
                int id = SphereUtils.getId(redacteurGlobalId);
                this.addAttribute("sphere", sphereKey.getSubsetName());
                this.addAttribute("id", String.valueOf(id));
                this.closeEmptyTag();
            }
            catch (ParseException pe) {
                this.closeEmptyTag();
            }
        } else {
            this.endOpenTag();
            this.addPersonCore(personne.getPersonCore());
            this.addSimpleElement("organism", personne.getOrganism());
            this.closeTag("personne");
        }
    }

    private void addPersonCore(PersonCore personCore) throws IOException {
        String surname = personCore.getSurname();
        boolean surnameFirst = personCore.isSurnameFirst();
        if (surname.length() > 0) {
            this.startOpenTag("surname");
            if (surnameFirst) {
                this.addAttribute("surname-first", "true");
            }
            this.endOpenTag();
            this.addText(surname);
            this.closeTag("surname", false);
        }
        this.addSimpleElement("forename", personCore.getForename());
        this.addSimpleElement("nonlatin", personCore.getNonlatin());
    }

    public void addPara(Para para) throws IOException {
        this.startOpenTag("para");
        this.endOpenTag();
        this.ficheBlockStorageXMLPart.addTextContent(para);
        this.closeTag("para", false);
    }
}

