/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.xml.extraction;

import java.io.IOException;
import java.text.ParseException;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.addenda.Document;
import net.fichotheque.addenda.Version;
import net.fichotheque.album.Album;
import net.fichotheque.album.Illustration;
import net.fichotheque.album.metadata.AlbumDim;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.Atts;
import net.fichotheque.corpus.fiche.Cdatadiv;
import net.fichotheque.corpus.fiche.Code;
import net.fichotheque.corpus.fiche.Div;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.corpus.fiche.FicheBlock;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.H;
import net.fichotheque.corpus.fiche.Insert;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.fiche.Li;
import net.fichotheque.corpus.fiche.Ln;
import net.fichotheque.corpus.fiche.P;
import net.fichotheque.corpus.fiche.Para;
import net.fichotheque.corpus.fiche.S;
import net.fichotheque.corpus.fiche.Table;
import net.fichotheque.corpus.fiche.Td;
import net.fichotheque.corpus.fiche.TextContent;
import net.fichotheque.corpus.fiche.Tr;
import net.fichotheque.corpus.fiche.Ul;
import net.fichotheque.corpus.fiche.ZoneBlock;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.extraction.ExtractParameters;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.extraction.IrefConverter;
import net.fichotheque.extraction.def.MotcleFilter;
import net.fichotheque.namespaces.BdfSpace;
import net.fichotheque.namespaces.ExtractionSpace;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.ExtractionUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.ThesaurusUtils;
import net.fichotheque.xml.extraction.ExtractionXMLUtils;
import net.fichotheque.xml.extraction.MotcleXMLPart;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.awt.ResizeInfo;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLUtils;
import net.mapeadores.util.xml.XMLWriter;

public class FicheBlockXMLPart
extends XMLPart {
    private final ExtractParameters extractParameters;
    private final MotcleXMLPart motcleXMLPart;
    private final ExtractionContext extractionContext;
    private final int extractVersion;
    private final String imageBaseUrl;
    private final String audioBaseUrl;
    private Corpus defaultCorpus;
    private IrefConverter currentIrefConverter = ExtractionUtils.SAME_CONVERTER;

    public FicheBlockXMLPart(XMLWriter xmlWriter, ExtractParameters extractParameters) {
        super(xmlWriter);
        this.extractParameters = extractParameters;
        this.extractionContext = extractParameters.getExtractionContext();
        this.extractVersion = extractParameters.getExtractVersion();
        Attributes fichothequeMetadataAttributes = this.extractionContext.getFichotheque().getFichothequeMetadata().getAttributes();
        this.imageBaseUrl = fichothequeMetadataAttributes.getFirstValue(BdfSpace.IMAGEBASEURL_KEY);
        this.audioBaseUrl = fichothequeMetadataAttributes.getFirstValue(BdfSpace.AUDIOBASEURL_KEY);
        this.motcleXMLPart = new MotcleXMLPart(xmlWriter, extractParameters);
    }

    public void setDefaultCorpus(Corpus defaultCorpus) {
        this.defaultCorpus = defaultCorpus;
    }

    public void addFicheBlocks(FicheBlocks ficheBlocks, IrefConverter irefConverter) throws IOException {
        this.currentIrefConverter = irefConverter;
        this.addFicheBlocks(ficheBlocks, "");
    }

    private void addFicheBlocks(FicheBlocks ficheBlocks, String positionPrefix) throws IOException {
        int size = ficheBlocks.size();
        for (int i = 0; i < size; ++i) {
            this.addFicheBlock((FicheBlock)ficheBlocks.get(i), positionPrefix, i + 1);
        }
    }

    public void addTextContent(TextContent content, IrefConverter irefConverter) throws IOException {
        for (Object obj : content) {
            if (obj instanceof String) {
                this.addText((String)obj);
                continue;
            }
            if (!(obj instanceof S)) continue;
            this.addS((S)obj, irefConverter);
        }
    }

    private void addFicheBlock(FicheBlock ficheBlock, String positionPrefix, int position) throws IOException {
        if (ficheBlock instanceof P) {
            this.addP((P)ficheBlock, positionPrefix, position);
        } else if (ficheBlock instanceof H) {
            this.addH((H)ficheBlock, positionPrefix, position);
        } else if (ficheBlock instanceof Ul) {
            this.addUl((Ul)ficheBlock, positionPrefix, position);
        } else if (ficheBlock instanceof Code) {
            this.addCode((Code)ficheBlock, positionPrefix, position);
        } else if (ficheBlock instanceof Table) {
            this.addTable((Table)ficheBlock, positionPrefix, position);
        } else if (ficheBlock instanceof Insert) {
            this.addInsert((Insert)ficheBlock, positionPrefix, position);
        } else if (ficheBlock instanceof Div) {
            this.addDiv((Div)ficheBlock, positionPrefix, position);
        } else if (ficheBlock instanceof Cdatadiv) {
            this.addCdataDiv((Cdatadiv)ficheBlock, positionPrefix, position);
        } else {
            throw new IllegalArgumentException("unknown FicheBlock Implementation");
        }
    }

    private void addP(P p, String positionPrefix, int position) throws IOException {
        this.startOpenTag("p");
        this.addAttribute("type", P.typeToString(p.getType()));
        this.addAttribute("source", p.getSource());
        this.addAtts(p);
        this.addPositionAttribute(positionPrefix, position);
        this.endOpenTag();
        this.addTextContent(p, this.currentIrefConverter);
        this.closeTag("p", false);
    }

    private void addH(H h, String positionPrefix, int position) throws IOException {
        this.startOpenTag("h");
        this.addAttribute("level", String.valueOf(h.getLevel()));
        this.addAtts(h);
        this.addPositionAttribute(positionPrefix, position);
        this.endOpenTag();
        this.addTextContent(h, this.currentIrefConverter);
        this.closeTag("h", false);
    }

    private void addPositionAttribute(String positionPrefix, int position) throws IOException {
        if (this.extractParameters.isWithPosition() && positionPrefix != null) {
            this.addAttribute("att-data-bdf-position", positionPrefix + position);
        }
    }

    private void addUl(Ul ul, String positionPrefix, int position) throws IOException {
        String childPositionPrefix = this.appendPositionPrefix(positionPrefix, position);
        this.startOpenTag("ul");
        this.addAtts(ul);
        this.endOpenTag();
        int childPosition = 0;
        for (Li li : ul) {
            this.addLi(li, childPositionPrefix, ++childPosition);
        }
        this.closeTag("ul");
    }

    private void addLi(Li li, String positionPrefix, int position) throws IOException {
        String childPositionPrefix = this.appendPositionPrefix(positionPrefix, position);
        this.startOpenTag("li");
        this.addAtts(li.getAtts());
        this.endOpenTag();
        this.addFicheBlocks((FicheBlocks)li, childPositionPrefix);
        this.closeTag("li");
    }

    private void addCode(Code code, String positionPrefix, int position) throws IOException {
        this.startOpenTag("code");
        this.addAttribute("type", Code.typeToString(code.getType()));
        this.addAtts(code);
        this.addPositionAttribute(positionPrefix, position);
        this.endOpenTag();
        this.addZoneBlockElements(code);
        for (Ln ln : code) {
            this.addLn(ln);
        }
        this.closeTag("code");
    }

    private void addLn(Ln ln) throws IOException {
        int indentation = ln.getIndentation();
        this.startOpenTag("ln");
        if (indentation > 0) {
            this.addAttribute("indent", String.valueOf(indentation));
        }
        this.addAtts(ln.getAtts());
        this.endOpenTag();
        this.addText(ln.getValue());
        this.closeTag("ln", false);
    }

    private void addDiv(Div div, String positionPrefix, int position) throws IOException {
        String childPositionPrefix = this.appendPositionPrefix(positionPrefix, position);
        this.startOpenTag("div");
        XMLUtils.addXmlLangAttribute(this, div.getLang());
        this.addAtts(div);
        this.endOpenTag();
        this.addZoneBlockElements(div);
        this.openTag("fbl");
        this.addFicheBlocks((FicheBlocks)div, childPositionPrefix);
        this.closeTag("fbl");
        this.closeTag("div");
    }

    private void addCdataDiv(Cdatadiv cdatadiv, String positionPrefix, int position) throws IOException {
        this.startOpenTag("cdatadiv");
        this.addAtts(cdatadiv);
        this.addPositionAttribute(positionPrefix, position);
        this.endOpenTag();
        this.addZoneBlockElements(cdatadiv);
        this.startOpenTag("cdata");
        this.endOpenTag();
        this.addCData(cdatadiv.getCdata());
        this.closeTag("cdata", false);
        this.closeTag("cdatadiv");
    }

    private void addS(S s, IrefConverter irefConverter) throws IOException {
        String cdata;
        String syntax;
        short sType = s.getType();
        this.startOpenTag("s", false);
        this.addAttribute("type", S.typeToString(sType));
        String ref = s.getRef();
        this.addAttribute("ref", ref);
        if (sType == 7 && ref.length() > 0 && this.imageBaseUrl != null && !StringUtils.isAbsoluteUrlString(ref)) {
            this.addAttribute("base", this.imageBaseUrl);
        }
        if (S.isIref(sType)) {
            this.addAttribute("iref", irefConverter.convert(ref));
        }
        boolean ignoreVariant = false;
        if (sType == 6 && s.getValue().isEmpty()) {
            this.addAttribute("variant", "empty");
            ignoreVariant = true;
        }
        this.addAtts(s, ignoreVariant);
        if (!S.isSpecialRef(sType) && this.extractionContext.getLinkAnalyser().isExternalLink(ref)) {
            this.addAttribute("link", "external");
        }
        if (!(syntax = s.getSyntax()).isEmpty() && !(cdata = this.extractionContext.getSyntaxResolver().toCData(syntax, s.getValue())).isEmpty()) {
            this.addAttribute("cdata", cdata);
        }
        switch (sType) {
            case 8: {
                this.closeFicheS(s);
                break;
            }
            case 24: {
                this.closeMotcleS(s);
                break;
            }
            default: {
                this.closeDefaultS(s);
            }
        }
    }

    private void closeMotcleS(S s) throws IOException {
        MotcleFilter motcleFilter;
        String ref = this.checkFragment(s);
        Fichotheque fichotheque = this.extractionContext.getFichotheque();
        Motcle motcle = null;
        try {
            motcle = ThesaurusUtils.parseGlobalIdalpha(ref, fichotheque);
        }
        catch (ParseException pe) {
            try {
                motcle = (Motcle)FichothequeUtils.parseGlobalId(ref, fichotheque, (short)2, null);
            }
            catch (ParseException pe2) {
                motcle = null;
            }
        }
        if (motcle == null) {
            this.addAttribute("ref-error", ref);
            this.closeDefaultS(s);
            return;
        }
        this.endOpenTag();
        String value = s.getValue();
        if (value.length() > 0) {
            this.addSimpleElement("value", value);
            motcleFilter = ExtractionXMLUtils.NONE_MOTCLEFILTER;
        } else {
            motcleFilter = ExtractionXMLUtils.LABELS_MOTCLEFILTER;
        }
        this.motcleXMLPart.addMotcle(ExtractionXMLUtils.toMotcleExtractInfo(motcle, motcleFilter));
        this.closeTag("s", false);
    }

    private void closeFicheS(S s) throws IOException {
        String idalpha;
        FicheMeta other;
        String ref = this.checkFragment(s);
        try {
            other = (FicheMeta)FichothequeUtils.parseGlobalId(ref, this.extractionContext.getFichotheque(), (short)1, this.defaultCorpus);
        }
        catch (ParseException pe) {
            other = null;
        }
        if (other == null) {
            this.addAttribute("ref-error", ref);
            this.closeDefaultS(s);
            return;
        }
        Lang otherLang = other.getLang();
        if (otherLang != null) {
            this.addAttribute("lang", otherLang.toString());
        }
        this.addAttribute("corpus", other.getSubsetName());
        this.addAttribute("id", other.getId());
        Subset master = other.getCorpus().getMasterSubset();
        if (master != null && master instanceof Thesaurus && (idalpha = ((Motcle)master.getSubsetItemById(other.getId())).getIdalpha()) != null) {
            this.addAttribute("idalpha", idalpha);
        }
        this.endOpenTag();
        String value = s.getValue();
        if (value.length() > 0) {
            this.addText(value);
        } else {
            this.addText(this.getLinkText(other));
        }
        this.closeTag("s", false);
    }

    private void closeDefaultS(S s) throws IOException {
        String value = s.getValue();
        if (value.length() > 0) {
            this.endOpenTag();
            this.addText(value);
            this.closeTag("s", false);
        } else {
            this.closeEmptyTag();
        }
    }

    private String checkFragment(S s) throws IOException {
        String ref = s.getRef();
        int idx = ref.indexOf(35);
        if (idx > 0) {
            this.addAttribute("fragment", ref.substring(idx + 1));
            ref = ref.substring(0, idx);
        }
        return ref;
    }

    private void addTable(Table table, String positionPrefix, int position) throws IOException {
        String childPositionPrefix = this.appendPositionPrefix(positionPrefix, position);
        this.startOpenTag("table");
        this.addAtts(table);
        this.addAttribute("cols", Table.checkColCount(table));
        this.endOpenTag();
        this.addZoneBlockElements(table);
        int childPosition = 0;
        for (Tr tr : table) {
            this.addTr(tr, childPositionPrefix, ++childPosition);
        }
        this.closeTag("table");
    }

    private void addTr(Tr tr, String positionPrefix, int position) throws IOException {
        this.startOpenTag("tr");
        this.addAtts(tr.getAtts());
        if (!tr.isEmpty()) {
            this.addPositionAttribute(positionPrefix, position);
        }
        this.endOpenTag();
        for (Td td : tr) {
            this.addTd(td);
        }
        this.closeTag("tr");
    }

    private void addTd(Td td) throws IOException {
        this.startOpenTag("td");
        this.addAttribute("type", Td.typeToString(td.getType()));
        if (td.isNumber()) {
            this.addAttribute("format", "number");
        }
        this.addAtts(td.getAtts());
        this.endOpenTag();
        this.addTextContent(td, this.currentIrefConverter);
        this.closeTag("td", false);
    }

    private void addInsert(Insert insert, String positionPrefix, int position) throws IOException {
        int height;
        this.startOpenTag("insert");
        this.addAttribute("type", Insert.typeToString(insert.getType()));
        String src = insert.getSrc();
        String ref = insert.getRef();
        this.addAttribute("src", src);
        if (!src.isEmpty() && !StringUtils.isAbsoluteUrlString(src)) {
            if (Insert.isDocumentType(insert.getType())) {
                if (this.audioBaseUrl != null) {
                    this.addAttribute("base", this.audioBaseUrl);
                }
            } else if (this.imageBaseUrl != null) {
                this.addAttribute("base", this.imageBaseUrl);
            }
        }
        this.addAttribute("ref", ref);
        if (!ref.isEmpty() && this.extractionContext.getLinkAnalyser().isExternalLink(ref)) {
            this.addAttribute("link", "external");
        }
        this.addAttribute("position", Insert.positionToString(insert.getPosition()));
        int width = insert.getWidth();
        if (width >= 0) {
            this.addAttribute("width", String.valueOf(width));
        }
        if ((height = insert.getHeight()) >= 0) {
            this.addAttribute("height", String.valueOf(height));
        }
        SubsetKey subsetKey = insert.getSubsetKey();
        Document insertDocument = null;
        if (subsetKey != null) {
            int id = insert.getId();
            if (subsetKey.isAddendaSubset()) {
                this.addAttribute("addenda", subsetKey.getSubsetName());
                this.addAttribute("id", id);
                Addenda addenda = (Addenda)this.extractionContext.getFichotheque().getSubset(subsetKey);
                if (addenda != null && (insertDocument = addenda.getDocumentById(id)) != null) {
                    this.addAttribute("basename", insertDocument.getBasename());
                }
            } else {
                Illustration illustration;
                String albumDimName = insert.getAlbumDimName();
                this.addAttribute("album", subsetKey.getSubsetName());
                this.addAttribute("id", id);
                this.addAttribute("albumdim", albumDimName);
                boolean done = false;
                Album album = (Album)this.extractionContext.getFichotheque().getSubset(subsetKey);
                if (album != null && (illustration = album.getIllustrationById(id)) != null) {
                    AlbumDim albumDim;
                    this.addAttribute("format", illustration.getFormatTypeString());
                    int albumWidth = illustration.getOriginalWidth();
                    int albumHeight = illustration.getOriginalHeight();
                    if (albumDimName != null && (albumDim = album.getAlbumMetadata().getAlbumDimByName(albumDimName)) != null) {
                        ResizeInfo.Check check = albumDim.getResizeInfo().checkDim(albumWidth, albumHeight);
                        albumWidth = check.getWidth();
                        albumHeight = check.getHeight();
                    }
                    this.addAttribute("album-width", albumWidth);
                    this.addAttribute("album-height", albumHeight);
                    this.addAttribute("album-ratio", String.valueOf((float)albumWidth / (float)albumHeight));
                    done = true;
                }
                if (!done) {
                    this.addAttribute("format", "png");
                }
            }
        }
        if (width > 0 && height > 0) {
            this.addAttribute("ratio", String.valueOf((float)width / (float)height));
        }
        this.addAtts(insert);
        this.addPositionAttribute(positionPrefix, position);
        this.endOpenTag();
        if (insertDocument != null) {
            for (Version version : insertDocument.getVersionList()) {
                this.startOpenTag("insertversion");
                this.addAttribute("extension", version.getExtension());
                this.addAttribute("type", this.extractionContext.getMimeTypeResolver().getMimeType(version.getExtension()));
                this.closeEmptyTag();
            }
        }
        this.addZoneBlockElements(insert);
        this.addZoneBlockElement("alt", insert.getAlt());
        this.addZoneBlockElement("credit", insert.getCredit());
        this.closeTag("insert");
    }

    private void addZoneBlockElements(ZoneBlock zoneBlock) throws IOException {
        this.addZoneBlockElement("numero", zoneBlock.getNumero());
        this.addZoneBlockElement("legende", zoneBlock.getLegende());
    }

    private void addZoneBlockElement(String name, TextContent textContent) throws IOException {
        if (!textContent.isEmpty()) {
            this.startOpenTag(name);
            this.endOpenTag();
            this.addTextContent(textContent, this.currentIrefConverter);
            this.closeTag(name, false);
        }
    }

    private void addAtts(FicheBlock ficheBlock) throws IOException {
        this.addAtts(ficheBlock.getAtts());
    }

    private void addAtts(Atts atts) throws IOException {
        boolean variantDone = false;
        int attLength = atts.size();
        block11: for (int i = 0; i < attLength; ++i) {
            String name = atts.getName(i);
            String value = atts.getValue(i);
            switch (name) {
                case "data-bdf-position": {
                    continue block11;
                }
                case "syntax": {
                    this.addAttribute("syntax", value);
                    continue block11;
                }
                case "variant": 
                case "mode": {
                    if (variantDone) continue block11;
                    this.addAttribute("variant", value);
                    variantDone = true;
                    continue block11;
                }
                default: {
                    this.addAttribute("att-" + name, value);
                }
            }
        }
    }

    private void addAtts(S s, boolean ignoreVariant) throws IOException {
        Atts atts = s.getAtts();
        boolean syntaxDone = false;
        int attLength = atts.size();
        block11: for (int i = 0; i < attLength; ++i) {
            String name = atts.getName(i);
            String value = atts.getValue(i);
            switch (name) {
                case "data-bdf-position": {
                    continue block11;
                }
                case "syntax": 
                case "mode": {
                    if (syntaxDone) continue block11;
                    this.addAttribute("syntax", value);
                    syntaxDone = true;
                    continue block11;
                }
                case "variant": {
                    if (ignoreVariant) continue block11;
                    this.addAttribute("variant", value);
                    continue block11;
                }
                default: {
                    this.addAttribute("att-" + name, value);
                }
            }
        }
    }

    private String getLinkText(FicheMeta other) {
        Attribute attribute = other.getCorpus().getCorpusMetadata().getAttributes().getAttribute(ExtractionSpace.LINKTEXTSOURCE_ATTRIBUTEKEY);
        if (attribute != null) {
            FicheAPI ficheAPI = other.getFicheAPI(false);
            for (String value : attribute) {
                try {
                    FieldKey fieldKey = FieldKey.parse(value);
                    Object obj = ficheAPI.getValue(fieldKey);
                    if (obj == null) continue;
                    if (obj instanceof String) {
                        return (String)obj;
                    }
                    if (obj instanceof FicheItem) {
                        if (obj instanceof Item) {
                            return ((Item)obj).getValue();
                        }
                        if (!(obj instanceof Para)) continue;
                        return ((Para)obj).contentToString();
                    }
                    return "#ERR: bdfxml:linktextsource unsupported fieldkey: " + value;
                }
                catch (ParseException pe) {
                    return "#ERR: wrong bdfxml:linktextsource value: " + value;
                }
            }
        }
        return other.getTitre();
    }

    private String appendPositionPrefix(String positionPrefix, int position) {
        if (positionPrefix != null) {
            return positionPrefix + position + ".";
        }
        return null;
    }
}

