/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.xml.extraction;

import java.io.IOException;
import java.util.List;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.extraction.ExtractParameters;
import net.fichotheque.extraction.def.AddendaExtractDef;
import net.fichotheque.extraction.def.TagNameInfo;
import net.fichotheque.extraction.filterunit.FilterUnit;
import net.fichotheque.extraction.run.AddendaExtractResult;
import net.fichotheque.extraction.run.DocumentExtractInfo;
import net.fichotheque.xml.extraction.DocumentXMLPart;
import net.fichotheque.xml.extraction.ExtractionXMLUtils;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class AddendaExtractXMLPart
extends XMLPart {
    private final ExtractParameters extractParameters;
    private final int extractVersion;
    private final DocumentXMLPart documentXMLPart;

    public AddendaExtractXMLPart(XMLWriter xmlWriter, ExtractParameters extractParameters) {
        super(xmlWriter);
        this.extractParameters = extractParameters;
        this.extractVersion = extractParameters.getExtractVersion();
        this.documentXMLPart = new DocumentXMLPart(xmlWriter, extractParameters);
    }

    public void addAddendaExtract(AddendaExtractResult addendaExtractResult) throws IOException {
        this.addAddendaExtract(addendaExtractResult, null);
    }

    public void addAddendaExtract(AddendaExtractResult addendaExtractResult, FilterUnit filterUnit) throws IOException {
        AddendaExtractDef addendaExtractDef = addendaExtractResult.getAddendaExtractDef();
        List<AddendaExtractResult.Entry> entryList = addendaExtractResult.getEntryList();
        if (entryList.isEmpty() && this.extractParameters.hideIfEmpty(filterUnit)) {
            return;
        }
        String tagName = this.getTagName(addendaExtractDef.getTagNameInfo());
        boolean withTag = tagName != null;
        String name = addendaExtractDef.getName();
        if (name != null) {
            if (withTag) {
                this.startOpenTag(tagName);
                this.addAttribute("name", name);
                if (this.extractVersion == 1) {
                    this.addAttribute("extrait-name", name);
                }
                ExtractionXMLUtils.addFilterParameters(this, filterUnit);
                this.endOpenTag();
            }
            for (AddendaExtractResult.Entry entry : entryList) {
                for (DocumentExtractInfo documentExtractInfo : entry.getDocumentExtractInfoList()) {
                    this.documentXMLPart.addDocument(documentExtractInfo);
                }
            }
            if (withTag) {
                this.closeTag(tagName);
            }
        } else {
            for (AddendaExtractResult.Entry entry : entryList) {
                Addenda addenda = entry.getAddenda();
                if (withTag) {
                    this.startOpenTag(tagName);
                    this.addAttribute("addenda", addenda.getSubsetName());
                    ExtractionXMLUtils.addFilterParameters(this, filterUnit);
                    this.endOpenTag();
                }
                for (DocumentExtractInfo documentExtractInfo : entry.getDocumentExtractInfoList()) {
                    this.documentXMLPart.addDocument(documentExtractInfo);
                }
                if (!withTag) continue;
                this.closeTag(tagName);
            }
        }
    }

    private String getTagName(TagNameInfo tagNameInfo) {
        switch (tagNameInfo.getType()) {
            case 3: {
                return tagNameInfo.getCustomTagName();
            }
            case 2: {
                return null;
            }
        }
        switch (this.extractVersion) {
            case 1: {
                return "extraitaddenda";
            }
        }
        return "documents";
    }
}

