/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils.selection;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.croisement.Croisement;
import net.fichotheque.croisement.CroisementKey;
import net.fichotheque.croisement.Lien;
import net.fichotheque.selection.CroisementCondition;
import net.fichotheque.selection.RangeCondition;
import net.fichotheque.utils.CroisementUtils;
import net.mapeadores.util.attr.Attributes;

class FilteredCroisementBuilder {
    private final Croisement source;
    private final Map<String, Lien> lienMap = new LinkedHashMap<String, Lien>();

    FilteredCroisementBuilder(Croisement source) {
        this.source = source;
    }

    void testCondition(CroisementCondition croisementCondition) {
        if (croisementCondition == null) {
            for (Lien lien : this.source.getLienList()) {
                this.addLien(lien);
            }
            return;
        }
        List<String> modeList = croisementCondition.getLienModeList();
        RangeCondition weightCondition = croisementCondition.getWeightRangeCondition();
        if (weightCondition != null) {
            if (modeList.isEmpty()) {
                for (Lien lien : this.source.getLienList()) {
                    if (!weightCondition.accept(lien.getPoids())) continue;
                    this.addLien(lien);
                }
            } else {
                for (String mode : modeList) {
                    Lien lien = this.source.getLienByMode(mode);
                    if (lien == null || !weightCondition.accept(lien.getPoids())) continue;
                    this.addLien(lien);
                }
            }
        } else {
            for (String mode : modeList) {
                Lien lien = this.source.getLienByMode(mode);
                if (lien == null) continue;
                this.addLien(lien);
            }
        }
    }

    void addLien(Lien lien) {
        this.lienMap.put(lien.getMode(), lien);
    }

    Croisement toCroisement() {
        int size = this.lienMap.size();
        if (size == 0) {
            return null;
        }
        return new InternalFilteredCroisement(this.source, this.lienMap.values().toArray(new Lien[size]));
    }

    private static class InternalFilteredCroisement
    implements Croisement {
        private final Croisement source;
        private final Lien[] lienArray;
        private final List<Lien> lienList;

        private InternalFilteredCroisement(Croisement source, Lien[] lienArray) {
            this.source = source;
            this.lienArray = lienArray;
            this.lienList = CroisementUtils.wrap(lienArray);
        }

        @Override
        public CroisementKey getCroisementKey() {
            return this.source.getCroisementKey();
        }

        @Override
        public List<Lien> getLienList() {
            return this.lienList;
        }

        @Override
        public Lien getLienByMode(String mode) {
            for (Lien lien : this.lienArray) {
                if (!lien.getMode().equals(mode)) continue;
                return lien;
            }
            return null;
        }

        @Override
        public Attributes getAttributes() {
            return this.source.getAttributes();
        }
    }
}

