/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils;

import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.RandomAccess;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.exportation.table.Cell;
import net.fichotheque.exportation.table.CellConverter;
import net.fichotheque.exportation.table.CellConverterProvider;
import net.fichotheque.exportation.table.Col;
import net.fichotheque.exportation.table.ColDef;
import net.fichotheque.exportation.table.CroisementTable;
import net.fichotheque.exportation.table.SubsetTable;
import net.fichotheque.exportation.table.SumCellConverter;
import net.fichotheque.exportation.table.SumResult;
import net.fichotheque.exportation.table.TableExportContentDescription;
import net.fichotheque.exportation.table.TableExportDescription;
import net.fichotheque.format.formatters.SourceFormatter;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.TableDefUtils;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.localisation.Lang;

public final class TableExportUtils {
    public static final List<TableExportContentDescription> EMPTY_CONTENTDESCRIPTIONLIST = Collections.emptyList();
    public static final List<CroisementTable> EMPTY_CROISEMENTTABLE_LIST = Collections.emptyList();
    public static final SumResult EMPTY_SUMRESULT = new EmptySumResult();
    public static final CellConverter EMPTY_CELLCONVERTER = new EmptyCellConverter();
    public static final SumCellConverter EMPTY_SUMCELLCONVERTER = new EmptyCellConverter();
    public static final Cell[] EMPTY_CELLARRAY = new Cell[0];
    public static final CellConverterProvider EMPTY_CELLCONVERTERPROVIDER = new EmptyCellConverterProvider();
    public static final List<ColDef> EMPTY_COLDEFLIST = Collections.emptyList();
    public static final Col[] EMPTY_COLARRAY = new Col[0];

    private TableExportUtils() {
    }

    public static TableExportContentDescription getTableExportContentDescription(TableExportDescription tableExportDescription, String contentPath) {
        for (TableExportContentDescription description : tableExportDescription.getTableExportContentDescriptionList()) {
            if (!description.getPath().equals(contentPath)) continue;
            return description;
        }
        return null;
    }

    public static boolean isContentEditable(TableExportDescription tableExportDescription, String contentPath) {
        if (!tableExportDescription.isEditable()) {
            return false;
        }
        for (TableExportContentDescription tecd : tableExportDescription.getTableExportContentDescriptionList()) {
            if (!tecd.getPath().equals(contentPath)) continue;
            return tecd.isEditable();
        }
        return true;
    }

    public static Cell toCell(short formatCast, Object value, ColDef colDef) {
        return new InternalCell(formatCast, value, colDef);
    }

    public static Col toCol(ColDef colDef, SourceFormatter sourceFormatter) {
        return new InternalCol(colDef, sourceFormatter);
    }

    public static SumResult.Entry toSumResultEntry(ColDef colDef, @Nullable SumResult.ColumnSum columnSum) {
        return new InternalSumResultEntry(colDef, columnSum);
    }

    public static SumResult toSumResult(ColDef[] colDefArray, SumResult.ColumnSum[] colSumArray) {
        boolean hasColumnSum;
        int length = colDefArray.length;
        SumResult.Entry[] array = new SumResult.Entry[length];
        if (colSumArray == null) {
            hasColumnSum = false;
            for (int i = 0; i < length; ++i) {
                array[i] = TableExportUtils.toSumResultEntry(colDefArray[i], null);
            }
        } else {
            hasColumnSum = true;
            for (int i = 0; i < length; ++i) {
                array[i] = TableExportUtils.toSumResultEntry(colDefArray[i], colSumArray[i]);
            }
        }
        return new InternalSumResult(TableExportUtils.wrap(array), hasColumnSum);
    }

    public static List<TableExportDescription> wrap(TableExportDescription[] array) {
        return new TableExportDescriptionList(array);
    }

    public static List<TableExportContentDescription> wrap(TableExportContentDescription[] array) {
        return new TableExportContentDescriptionList(array);
    }

    public static List<Col> wrap(Col[] array) {
        return new ColList(array);
    }

    public static List<SumResult.Entry> wrap(SumResult.Entry[] array) {
        return new SumResultEntryList(array);
    }

    public static CellConverter getPhraseConverter(Lang lang, Locale formatLocale) {
        return new PhraseCellConverter(lang, formatLocale);
    }

    public static List<SubsetTable> wrap(SubsetTable[] array) {
        return new SubsetTableList(array);
    }

    public static List<CroisementTable> wrap(CroisementTable[] array) {
        return new CroisementTableList(array);
    }

    private static class InternalCell
    implements Cell {
        private final short formatCast;
        private final Object value;
        private final ColDef colDef;

        private InternalCell(short formatCast, Object value, ColDef colDef) {
            this.formatCast = formatCast;
            this.value = value;
            this.colDef = colDef;
        }

        @Override
        public short getFormatCast() {
            return this.formatCast;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public ColDef getColDef() {
            return this.colDef;
        }
    }

    private static class InternalCol
    implements Col {
        private final ColDef colDef;
        private final SourceFormatter sourceFormatter;

        private InternalCol(ColDef colDef, SourceFormatter sourceFormatter) {
            this.colDef = colDef;
            this.sourceFormatter = sourceFormatter;
        }

        @Override
        public ColDef getColDef() {
            return this.colDef;
        }

        @Override
        public SourceFormatter getSourceFormatter() {
            return this.sourceFormatter;
        }
    }

    private static class InternalSumResultEntry
    implements SumResult.Entry {
        private final ColDef colDef;
        private final SumResult.ColumnSum columnSum;

        private InternalSumResultEntry(ColDef colDef, SumResult.ColumnSum columnSum) {
            this.colDef = colDef;
            this.columnSum = columnSum;
        }

        @Override
        public ColDef getColDef() {
            return this.colDef;
        }

        @Override
        public SumResult.ColumnSum getColumnSum() {
            return this.columnSum;
        }
    }

    private static class InternalSumResult
    implements SumResult {
        private final List<SumResult.Entry> entryList;
        private final boolean hasColumnSum;

        private InternalSumResult(List<SumResult.Entry> entryList, boolean hasColumnSum) {
            this.entryList = entryList;
            this.hasColumnSum = hasColumnSum;
        }

        @Override
        public boolean hasColumnSum() {
            return this.hasColumnSum;
        }

        @Override
        public List<SumResult.Entry> getEntryList() {
            return this.entryList;
        }
    }

    private static class TableExportDescriptionList
    extends AbstractList<TableExportDescription>
    implements RandomAccess {
        private final TableExportDescription[] array;

        private TableExportDescriptionList(TableExportDescription[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public TableExportDescription get(int index) {
            return this.array[index];
        }
    }

    private static class TableExportContentDescriptionList
    extends AbstractList<TableExportContentDescription>
    implements RandomAccess {
        private final TableExportContentDescription[] array;

        private TableExportContentDescriptionList(TableExportContentDescription[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public TableExportContentDescription get(int index) {
            return this.array[index];
        }
    }

    private static class ColList
    extends AbstractList<Col>
    implements RandomAccess {
        private final Col[] array;

        private ColList(Col[] colDefArray) {
            this.array = colDefArray;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Col get(int i) {
            return this.array[i];
        }
    }

    private static class SumResultEntryList
    extends AbstractList<SumResult.Entry>
    implements RandomAccess {
        private final SumResult.Entry[] array;

        private SumResultEntryList(SumResult.Entry[] colDefArray) {
            this.array = colDefArray;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public SumResult.Entry get(int i) {
            return this.array[i];
        }
    }

    private static class PhraseCellConverter
    implements CellConverter {
        private final Lang lang;
        private final Locale formatLocale;
        private final ColDef numberColDef;

        private PhraseCellConverter(Lang lang, Locale formatLocale) {
            this.lang = lang;
            this.formatLocale = formatLocale;
            this.numberColDef = TableDefUtils.toColDef("number", null);
        }

        @Override
        public Cell[] toCellArray(SubsetItem subsetItem) {
            if (subsetItem instanceof FicheMeta) {
                FicheMeta ficheMeta = (FicheMeta)subsetItem;
                String numberPhrase = FichothequeUtils.getNumberPhrase(ficheMeta, "fiche", this.lang, this.formatLocale);
                Cell[] result = new Cell[]{TableExportUtils.toCell((short)0, numberPhrase, this.numberColDef)};
                return result;
            }
            if (subsetItem instanceof Motcle) {
                Motcle motcle = (Motcle)subsetItem;
                String numberPhrase = FichothequeUtils.getNumberPhrase(motcle, "fichestyle", this.lang, this.formatLocale, "");
                if (numberPhrase.isEmpty()) {
                    return EMPTY_CELLARRAY;
                }
                Cell[] result = new Cell[]{TableExportUtils.toCell((short)0, numberPhrase, this.numberColDef)};
                return result;
            }
            return null;
        }
    }

    private static class SubsetTableList
    extends AbstractList<SubsetTable>
    implements RandomAccess {
        private final SubsetTable[] array;

        private SubsetTableList(SubsetTable[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public SubsetTable get(int index) {
            return this.array[index];
        }
    }

    private static class CroisementTableList
    extends AbstractList<CroisementTable>
    implements RandomAccess {
        private final CroisementTable[] array;

        private CroisementTableList(CroisementTable[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public CroisementTable get(int index) {
            return this.array[index];
        }
    }

    private static class EmptySumResult
    implements SumResult {
        private final List<SumResult.Entry> emptyList = Collections.emptyList();

        private EmptySumResult() {
        }

        @Override
        public boolean hasColumnSum() {
            return false;
        }

        @Override
        public List<SumResult.Entry> getEntryList() {
            return this.emptyList;
        }
    }

    private static class EmptyCellConverter
    implements SumCellConverter {
        private EmptyCellConverter() {
        }

        @Override
        public Cell[] toCellArray(SubsetItem subsetItem) {
            return null;
        }

        @Override
        public SumResult getSumResult(SubsetKey subsetKey) {
            return EMPTY_SUMRESULT;
        }
    }

    private static class EmptyCellConverterProvider
    implements CellConverterProvider {
        private EmptyCellConverterProvider() {
        }

        @Override
        public SumCellConverter getCellConverter(String name) {
            return null;
        }
    }
}

