/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils;

import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import java.util.function.Predicate;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.SubfieldValue;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.exportation.table.CellConverterProvider;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.extraction.def.ExtractionDef;
import net.fichotheque.format.FormatContext;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.PatternDef;
import net.fichotheque.format.Tokenizer;
import net.fichotheque.format.Tokens;
import net.fichotheque.pointeurs.SubsetItemPointeur;
import net.fichotheque.utils.TableExportUtils;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionResolver;
import net.mapeadores.util.instruction.Instructions;
import net.mapeadores.util.instruction.InstructionsParser;
import net.mapeadores.util.logging.ErrorMessageException;

public final class FormatterUtils {
    public static final Tokens EMPTY_TOKENS = new EmptyTokens();
    public static final Tokenizer EMPTY_TOKENIZER = new EmptyTokenizer();
    public static final FormatSource.History EMPTY_FORMATSOURCEHISTORY = new EmptyHistory();

    private FormatterUtils() {
    }

    public static Object[] parsePattern(InstructionResolver instructionResolver, String s) throws ErrorMessageException {
        Instructions instructions = InstructionsParser.parse(s);
        int partSize = instructions.size();
        Object[] result = new Object[partSize];
        for (int i = 0; i < partSize; ++i) {
            Instructions.Part part = (Instructions.Part)instructions.get(i);
            if (part instanceof Instructions.LiteralPart) {
                result[i] = ((Instructions.LiteralPart)part).getText();
                continue;
            }
            Instruction instruction = ((Instructions.InstructionPart)part).getInstruction();
            Object resultObject = instructionResolver.resolve(instruction);
            if (resultObject == null) {
                throw new ErrorMessageException("_ error.unknown.pattern", "{" + ((Argument)instruction.get(0)).getKey() + "}");
            }
            result[i] = resultObject;
        }
        return result;
    }

    public static SubfieldValue toSubfieldValue(String s) {
        return new InternalSubfieldValue(s);
    }

    public static SubfieldValue toSubfieldValue(FicheItem ficheItem) {
        return new InternalSubfieldValue(ficheItem);
    }

    public static FormatSource toFormatSource(SubsetItemPointeur subsetItemPointeur, ExtractionContext extractionContext, Predicate<SubsetItem> predicate, FormatContext formatContext) {
        if (subsetItemPointeur == null) {
            throw new IllegalArgumentException("subsetItemPointeur is null");
        }
        return new InternalFormatSource(subsetItemPointeur, extractionContext, predicate, formatContext, TableExportUtils.EMPTY_CELLCONVERTERPROVIDER, EMPTY_FORMATSOURCEHISTORY, null);
    }

    public static FormatSource toFormatSource(SubsetItemPointeur subsetItemPointeur, ExtractionContext extractionContext, Predicate<SubsetItem> predicate, FormatContext formatContext, CellConverterProvider cellConverterProvider, FormatSource.History history, FormatSource.ExtractionInfo extractionInfo) {
        if (subsetItemPointeur == null) {
            throw new IllegalArgumentException("subsetItemPointeur is null");
        }
        return new InternalFormatSource(subsetItemPointeur, extractionContext, predicate, formatContext, cellConverterProvider, history, extractionInfo);
    }

    public static Tokenizer initConstantTokenizer(String pattern) {
        if (pattern == null) {
            return EMPTY_TOKENIZER;
        }
        SingletonTokens constantSourceTokens = new SingletonTokens(pattern);
        return new ConstantTokenizer(constantSourceTokens);
    }

    public static List<PatternDef> wrap(PatternDef[] array) {
        return new PatternDefList(array);
    }

    public static List<Tokenizer> wrap(Tokenizer[] array) {
        return new TokenizerList(array);
    }

    public static Tokens toTokens(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        return new SingletonTokens(value);
    }

    public static Tokens toTokens(List<String> valueList) {
        return new ListTokens(valueList);
    }

    public static FormatSource.ExtractionInfo toExtractionInfo(String errorLog) {
        return new InternalExtractionInfo(null, errorLog);
    }

    public static FormatSource.ExtractionInfo toExtractionInfo(ExtractionDef extractionDef) {
        return new InternalExtractionInfo(extractionDef, null);
    }

    private static class InternalSubfieldValue
    implements SubfieldValue {
        private final Object value;

        public InternalSubfieldValue(Object value) {
            this.value = value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }

    private static class InternalFormatSource
    implements FormatSource {
        private final SubsetItemPointeur subsetItemPointeur;
        private final ExtractionContext extractionContext;
        private final Predicate<SubsetItem> predicate;
        private final CellConverterProvider cellConverterProvider;
        private final FormatContext formatContext;
        private final FormatSource.History history;
        private final FormatSource.ExtractionInfo extractionInfo;

        private InternalFormatSource(SubsetItemPointeur subsetItemPointeur, ExtractionContext extractionContext, Predicate<SubsetItem> predicate, FormatContext formatContext, CellConverterProvider cellConverterProvider, FormatSource.History history, FormatSource.ExtractionInfo extractionInfo) {
            this.subsetItemPointeur = subsetItemPointeur;
            this.extractionContext = extractionContext;
            this.predicate = predicate;
            this.formatContext = formatContext;
            this.cellConverterProvider = cellConverterProvider;
            this.history = history;
            this.extractionInfo = extractionInfo;
        }

        @Override
        public SubsetItemPointeur getSubsetItemPointeur() {
            return this.subsetItemPointeur;
        }

        @Override
        public ExtractionContext getExtractionContext() {
            return this.extractionContext;
        }

        @Override
        public Predicate<SubsetItem> getGlobalPredicate() {
            return this.predicate;
        }

        @Override
        public CellConverterProvider getCellConverterProvider() {
            return this.cellConverterProvider;
        }

        @Override
        public FormatContext getFormatContext() {
            return this.formatContext;
        }

        @Override
        public FormatSource.History getHistory() {
            return this.history;
        }

        @Override
        public FormatSource.ExtractionInfo getExtractionInfo() {
            return this.extractionInfo;
        }
    }

    private static class SingletonTokens
    extends AbstractList<String>
    implements Tokens {
        private final String value;

        private SingletonTokens(String value) {
            this.value = value;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public String get(int i) {
            return this.value;
        }
    }

    private static class ConstantTokenizer
    implements Tokenizer {
        private final Tokens tokens;

        private ConstantTokenizer(Tokens tokens) {
            this.tokens = tokens;
        }

        @Override
        public Tokens tokenize(FormatSource formatSource) {
            return this.tokens;
        }
    }

    private static class PatternDefList
    extends AbstractList<PatternDef>
    implements RandomAccess {
        private final PatternDef[] array;

        private PatternDefList(PatternDef[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public PatternDef get(int index) {
            return this.array[index];
        }
    }

    private static class TokenizerList
    extends AbstractList<Tokenizer>
    implements RandomAccess {
        private final Tokenizer[] array;

        private TokenizerList(Tokenizer[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Tokenizer get(int index) {
            return this.array[index];
        }
    }

    private static class ListTokens
    extends AbstractList<String>
    implements Tokens {
        private final List<String> valueList;

        private ListTokens(List<String> valueList) {
            this.valueList = valueList;
        }

        @Override
        public int size() {
            return this.valueList.size();
        }

        @Override
        public String get(int i) {
            return this.valueList.get(i);
        }
    }

    private static class InternalExtractionInfo
    implements FormatSource.ExtractionInfo {
        private final ExtractionDef extractionDef;
        private final String errorLog;

        private InternalExtractionInfo(ExtractionDef extractionDef, String errorLog) {
            this.extractionDef = extractionDef;
            this.errorLog = errorLog;
        }

        @Override
        public ExtractionDef getExtractionDef() {
            return this.extractionDef;
        }

        @Override
        public String getErrorLog() {
            return this.errorLog;
        }
    }

    private static class EmptyTokens
    extends AbstractList<String>
    implements Tokens {
        private EmptyTokens() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public String get(int i) {
            throw new IndexOutOfBoundsException("size = 0");
        }
    }

    private static class EmptyTokenizer
    implements Tokenizer {
        private EmptyTokenizer() {
        }

        @Override
        public Tokens tokenize(FormatSource formatSource) {
            return EMPTY_TOKENS;
        }
    }

    private static class EmptyHistory
    implements FormatSource.History {
        private final List<String> emptyList = Collections.emptyList();

        private EmptyHistory() {
        }

        @Override
        public List<String> getPreviousFormatList() {
            return this.emptyList;
        }
    }
}

