/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils;

import java.text.ParseException;
import java.util.ArrayList;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.corpus.metadata.FieldOptionException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.money.CurrenciesUtils;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.text.StringUtils;

public final class FieldOptionUtils {
    private FieldOptionUtils() {
    }

    public static boolean haveSubfield(int ficheItemType) {
        switch (ficheItemType) {
            case 2: 
            case 10: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public static boolean testFieldOption(String optionName, CorpusField corpusField) {
        try {
            FieldOptionUtils.checkUsage(optionName, corpusField.getFieldKey(), corpusField.getFicheItemType());
            return true;
        }
        catch (FieldOptionException foe) {
            return false;
        }
    }

    public static boolean testFieldOption(String optionName, FieldKey fieldKey, int ficheItemType) {
        try {
            FieldOptionUtils.checkUsage(optionName, fieldKey, ficheItemType);
            return true;
        }
        catch (FieldOptionException foe) {
            return false;
        }
    }

    public static void checkUsage(String optionName, FieldKey fieldKey, int ficheItemType) throws FieldOptionException {
        switch (optionName) {
            case "informationDisplay": {
                if (fieldKey.isInformation()) break;
                throw new FieldOptionException("informationDisplay Option applies only to Information Field");
            }
            case "defaultSphereKey": {
                if (ficheItemType == 2) break;
                throw new FieldOptionException("ficheItemType must be PERSONNE_FIELD");
            }
            case "subfieldDisplay": {
                if (!fieldKey.isPropriete()) {
                    throw new FieldOptionException("subfieldDisplay Option applies only to Propriete Field");
                }
                if (FieldOptionUtils.haveSubfield(ficheItemType)) break;
                throw new FieldOptionException("wrong ficheItemType = " + ficheItemType);
            }
            case "currencyArray": {
                if (ficheItemType == 9) break;
                throw new FieldOptionException("ficheItemType must be MONTANT_FIELD");
            }
            case "addressFieldArray": {
                if (!fieldKey.isPropriete()) {
                    throw new FieldOptionException("addressFields Option applies only to Propriete Field");
                }
                if (ficheItemType == 10) break;
                throw new FieldOptionException("ficheItemType must be GEOPOINT_FIELD");
            }
            case "baseUrl": {
                if (ficheItemType == 12 || ficheItemType == 7) break;
                throw new FieldOptionException("ficheItemType must be IMAGE_FIELD or lINK_FIELD");
            }
            case "langScope": {
                if (FieldOptionUtils.isLangField(fieldKey, ficheItemType)) break;
                throw new FieldOptionException("langScope applies only to FieldKey.LANG and fields with ficheItemType = LANGUE_FIELD");
            }
            case "langArray": {
                if (FieldOptionUtils.isLangField(fieldKey, ficheItemType) || ficheItemType == 11) break;
                throw new FieldOptionException("langArray applies only to FieldKey.LANG and fields with ficheItemType = PARA_FIELD or LANGUE_FIELD");
            }
            case "geolocalisationField": {
                if (fieldKey.isPropriete() && ficheItemType == 10) break;
                throw new FieldOptionException("geolocalisationField applies only to Propriete Field with ficheItemType = GEOPOINT_FIELD");
            }
        }
    }

    public static Object parseOptionValue(String optionName, String optionValue) throws FieldOptionException {
        if (optionValue == null) {
            return null;
        }
        if ((optionValue = optionValue.trim()).isEmpty()) {
            return null;
        }
        switch (optionName) {
            case "addressFieldArray": {
                String[] tokenArray;
                ArrayList<FieldKey> fieldKeyList = new ArrayList<FieldKey>();
                for (String token : tokenArray = StringUtils.getTechnicalTokens(optionValue, false)) {
                    try {
                        FieldKey fieldKey = FieldKey.parse(token);
                        fieldKeyList.add(fieldKey);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                if (fieldKeyList.isEmpty()) {
                    return null;
                }
                return fieldKeyList.toArray(new FieldKey[fieldKeyList.size()]);
            }
            case "langArray": {
                Lang[] langArray = LangsUtils.toCleanLangArray(optionValue);
                if (langArray.length == 0) {
                    return null;
                }
                return langArray;
            }
            case "currencyArray": {
                ExtendedCurrency[] currencyArray = CurrenciesUtils.toCleanCurrencyArray(optionValue);
                if (currencyArray.length == 0) {
                    currencyArray = null;
                }
                return currencyArray;
            }
        }
        FieldOptionUtils.checkString(optionName, optionValue);
        return optionValue;
    }

    public static void checkString(String optionName, String optionValue) throws FieldOptionException {
        switch (optionName) {
            case "defaultSphereKey": {
                try {
                    SubsetKey sphereKey = SubsetKey.parse(optionValue);
                    if (!sphereKey.isSphereSubset()) {
                        throw new FieldOptionException("value must be a key of a sphere");
                    }
                    break;
                }
                catch (ParseException pe) {
                    throw new FieldOptionException("value must be a valid sphereKey");
                }
            }
        }
    }

    private static void stringTest(Object value) throws FieldOptionException {
        if (value != null && !(value instanceof String)) {
            throw new FieldOptionException("value must be a String");
        }
    }

    private static boolean isLangField(FieldKey fieldKey, int ficheItemType) {
        if (ficheItemType == 3) {
            return true;
        }
        switch (fieldKey.getKeyString()) {
            case "lang": {
                return true;
            }
        }
        return false;
    }
}

