/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import java.util.Set;
import java.util.function.Predicate;
import net.fichotheque.Fichotheque;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.extraction.DataResolverProvider;
import net.fichotheque.extraction.ExtractParameters;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.extraction.FilterParameters;
import net.fichotheque.extraction.IrefConverter;
import net.fichotheque.extraction.LinkAnalyser;
import net.fichotheque.extraction.SyntaxResolver;
import net.fichotheque.extraction.filterunit.FilterUnit;
import net.fichotheque.extraction.run.CorpusExtractResult;
import net.fichotheque.extraction.run.ExtractorProvider;
import net.fichotheque.extraction.run.ThesaurusExtractResult;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.thesaurus.policies.PolicyProvider;
import net.mapeadores.util.localisation.LangContext;
import net.mapeadores.util.localisation.MessageLocalisationProvider;
import net.mapeadores.util.mimetype.MimeTypeResolver;
import net.mapeadores.util.text.StringUtils;

public final class ExtractionUtils {
    public static final FilterParameters EMPTY_FILTERPARAMETERS = new EmptyFilterParameters();
    public static final List<CorpusExtractResult> EMPTY_CORPUSEXTRACTRESULTLIST = Collections.emptyList();
    public static final List<ThesaurusExtractResult> EMPTY_THESAURUSEXTRACTRESULTLIST = Collections.emptyList();
    public static final List<FilterUnit> EMPTY_FILTERUNITLIST = Collections.emptyList();
    public static final IrefConverter SAME_CONVERTER = new SameIrefConverter();

    private ExtractionUtils() {
    }

    public static int parseExtractVersion(String text) {
        if (text == null) {
            return 1;
        }
        try {
            int value = Integer.parseInt(text);
            switch (value) {
                case 1: {
                    return 1;
                }
            }
            return 2;
        }
        catch (NumberFormatException nfe) {
            return 2;
        }
    }

    public static String checkSort(String sort) {
        if (sort == null || sort.length() == 0) {
            return "asc";
        }
        switch (sort) {
            case "desc": {
                return "desc";
            }
        }
        return "asc";
    }

    public static String checkType(String type) {
        if (type == null || type.length() == 0) {
            throw new IllegalArgumentException("undefined type");
        }
        switch (type) {
            case "poids": {
                return "poids";
            }
            case "titre": {
                return "titre";
            }
            case "annee": {
                return "annee";
            }
            case "lang": {
                return "lang";
            }
            case "pays": {
                return "pays";
            }
            case "fields": {
                return "fields";
            }
            case "position": {
                return "position";
            }
        }
        throw new IllegalArgumentException("unknwon type : " + type);
    }

    public static ExtractionContext derive(ExtractionContext extractionContext, LangContext langContext) {
        return new DeriveExtractionContext(extractionContext, langContext);
    }

    public static List<FilterUnit> toImmutableList(Collection<FilterUnit> collection) {
        int size = collection.size();
        if (size == 0) {
            return EMPTY_FILTERUNITLIST;
        }
        return new FilterUnitList(collection.toArray(new FilterUnit[size]));
    }

    public static List<FilterUnit> wrap(FilterUnit[] array) {
        return new FilterUnitList(array);
    }

    public static ExtractParameters derive(ExtractParameters extractParameters, Predicate<FicheMeta> fichePredicate) {
        return new DeriveExtractParameters(extractParameters, fichePredicate);
    }

    private static class DeriveExtractionContext
    implements ExtractionContext {
        private final ExtractionContext originExtractionContext;
        private final LangContext langContext;

        private DeriveExtractionContext(ExtractionContext originExtractionContext, LangContext langContext) {
            this.originExtractionContext = originExtractionContext;
            this.langContext = langContext;
        }

        @Override
        public Fichotheque getFichotheque() {
            return this.originExtractionContext.getFichotheque();
        }

        @Override
        public MessageLocalisationProvider getMessageLocalisationProvider() {
            return this.originExtractionContext.getMessageLocalisationProvider();
        }

        @Override
        public LangContext getLangContext() {
            return this.langContext;
        }

        @Override
        public LinkAnalyser getLinkAnalyser() {
            return this.originExtractionContext.getLinkAnalyser();
        }

        @Override
        public ExtractorProvider getExtractorProvider() {
            return this.originExtractionContext.getExtractorProvider();
        }

        @Override
        public MimeTypeResolver getMimeTypeResolver() {
            return this.originExtractionContext.getMimeTypeResolver();
        }

        @Override
        public SyntaxResolver getSyntaxResolver() {
            return this.originExtractionContext.getSyntaxResolver();
        }

        @Override
        public PermissionSummary getPermissionSummary() {
            return this.originExtractionContext.getPermissionSummary();
        }

        @Override
        public DataResolverProvider getDataResolverProvider() {
            return this.originExtractionContext.getDataResolverProvider();
        }

        @Override
        public PolicyProvider getPolicyProvider() {
            return this.originExtractionContext.getPolicyProvider();
        }
    }

    private static class FilterUnitList
    extends AbstractList<FilterUnit>
    implements RandomAccess {
        private final FilterUnit[] array;

        private FilterUnitList(FilterUnit[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public FilterUnit get(int index) {
            return this.array[index];
        }
    }

    private static class DeriveExtractParameters
    implements ExtractParameters {
        private final ExtractParameters originalExtractParameters;
        private final Predicate<FicheMeta> fichePredicate;

        private DeriveExtractParameters(ExtractParameters originalExtractParameters, Predicate<FicheMeta> fichePredicate) {
            this.originalExtractParameters = originalExtractParameters;
            this.fichePredicate = fichePredicate;
        }

        @Override
        public ExtractionContext getExtractionContext() {
            return this.originalExtractParameters.getExtractionContext();
        }

        @Override
        public int getExtractVersion() {
            return this.originalExtractParameters.getExtractVersion();
        }

        @Override
        public boolean isWithEmpty() {
            return this.originalExtractParameters.isWithEmpty();
        }

        @Override
        public Predicate<FicheMeta> getFichePredicate() {
            return this.fichePredicate;
        }

        @Override
        public IrefConverter newIrefConverter() {
            return this.originalExtractParameters.newIrefConverter();
        }

        @Override
        public boolean isWithPosition() {
            return this.originalExtractParameters.isWithPosition();
        }
    }

    private static class EmptyFilterParameters
    implements FilterParameters {
        private EmptyFilterParameters() {
        }

        @Override
        public Set<String> getParameterNameSet() {
            return StringUtils.EMPTY_STRINGSET;
        }

        @Override
        public List<String> getParameter(String name) {
            return StringUtils.EMPTY_STRINGLIST;
        }
    }

    private static class SameIrefConverter
    implements IrefConverter {
        private SameIrefConverter() {
        }

        @Override
        public String convert(String ref) {
            return ref;
        }
    }
}

