/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.RandomAccess;
import java.util.Set;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheChange;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.Information;
import net.fichotheque.corpus.fiche.Para;
import net.fichotheque.corpus.fiche.Propriete;
import net.fichotheque.corpus.fiche.Section;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.fichotheque.utils.FicheUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.localisation.Lang;

public final class CorpusUtils {
    public static final List<FicheMeta> EMPTY_FICHEMETALIST = Collections.emptyList();
    public static final Fiches EMPTY_FICHES = new EmptyFiches();
    public static final List<Fiches.Entry> EMPTY_FICHESENTRYLIST = Collections.emptyList();
    public static final FicheChange EMPTY_FICHECHANGE = new EmptyFicheChange();

    private CorpusUtils() {
    }

    public static int getFicheCount(Fichotheque fichotheque) {
        int count = 0;
        for (Corpus corpus : fichotheque.getCorpusList()) {
            count += corpus.size();
        }
        return count;
    }

    public static boolean replaceInField(Fiche fiche, FieldSelection fieldSelection, FicheItem oldFicheItem, FicheItem newFicheItem) {
        FicheItems newItems;
        FicheItems redacteurs;
        boolean done = false;
        if (fieldSelection.withRedacteurs() && (redacteurs = fiche.getRedacteurs()) != null && (newItems = CorpusUtils.replaceInFicheItems(redacteurs, oldFicheItem, newFicheItem)) != null) {
            fiche.setRedacteurs(newItems);
            done = true;
        }
        if (fieldSelection.withInformation()) {
            for (Information information : fiche.getInformationList()) {
                FicheItems newItems2;
                if (!fieldSelection.containsInformation(information.getFieldKey()) || (newItems2 = CorpusUtils.replaceInFicheItems(information, oldFicheItem, newFicheItem)) == null) continue;
                fiche.setInformation(information.getFieldKey(), newItems2);
                done = true;
            }
        }
        if (fieldSelection.withPropriete()) {
            for (Propriete propriete : fiche.getProprieteList()) {
                FicheItem current;
                FieldKey fieldKey = propriete.getFieldKey();
                if (!fieldSelection.containsPropriete(propriete.getFieldKey()) || !(current = propriete.getFicheItem()).equals(oldFicheItem)) continue;
                fiche.setPropriete(fieldKey, newFicheItem);
                done = true;
            }
        }
        return done;
    }

    private static FicheItems replaceInFicheItems(FicheItems currentItems, FicheItem oldFicheItem, FicheItem newFicheItem) {
        ArrayList<FicheItem> newList = new ArrayList<FicheItem>();
        int count = currentItems.size();
        boolean done = false;
        for (int i = 0; i < count; ++i) {
            FicheItem ficheItem = (FicheItem)currentItems.get(i);
            if (ficheItem.equals(oldFicheItem)) {
                newList.add(newFicheItem);
                done = true;
                continue;
            }
            newList.add(ficheItem);
        }
        if (done) {
            return FicheUtils.toFicheItems(newList);
        }
        return null;
    }

    public static FieldSelection getPersonneFieldSelection(Corpus corpus) {
        FieldSelection fieldSelection = new FieldSelection();
        fieldSelection.addField(FieldKey.REDACTEURS);
        CorpusMetadata corpusMetadata = corpus.getCorpusMetadata();
        for (CorpusField corpusField : corpusMetadata.getProprieteList()) {
            if (corpusField.getFicheItemType() != 2) continue;
            fieldSelection.addField(corpusField);
        }
        for (CorpusField corpusField : corpusMetadata.getInformationList()) {
            if (corpusField.getFicheItemType() != 2) continue;
            fieldSelection.addField(corpusField);
        }
        return fieldSelection;
    }

    public static List<FicheMeta> getFicheMetaListByCorpus(Fiches fiches, Corpus corpus) {
        SubsetKey corpusKey = corpus.getSubsetKey();
        for (Fiches.Entry entry : fiches.getEntryList()) {
            Corpus other = entry.getCorpus();
            if (!other.getSubsetKey().equals(corpusKey)) continue;
            return entry.getFicheMetaList();
        }
        return EMPTY_FICHEMETALIST;
    }

    public static List<SubsetItem> getFicheMetaListByCorpus(Fiches fiches, SubsetKey corpusKey) {
        for (Fiches.Entry entry : fiches.getEntryList()) {
            Corpus other = entry.getCorpus();
            if (!other.getSubsetKey().equals(corpusKey)) continue;
            return entry.getSubsetItemList();
        }
        return FichothequeUtils.EMPTY_SUBSETITEMLIST;
    }

    public static List<FicheMeta> toList(Fiches fiches) {
        ArrayList<FicheMeta> list = new ArrayList<FicheMeta>();
        for (Fiches.Entry entry : fiches.getEntryList()) {
            for (FicheMeta ficheMeta : entry.getFicheMetaList()) {
                list.add(ficheMeta);
            }
        }
        return list;
    }

    public static List<FicheMeta> getSatelliteFicheMetaList(SubsetItem masterSubsetItem) {
        ArrayList<FicheMeta> list = new ArrayList<FicheMeta>();
        Subset masterSubset = masterSubsetItem.getSubset();
        int id = masterSubsetItem.getId();
        for (Corpus satellite : masterSubset.getSatelliteCorpusList()) {
            FicheMeta ficheMeta = satellite.getFicheMetaById(id);
            if (ficheMeta == null) continue;
            list.add(ficheMeta);
        }
        return list;
    }

    public static List<FicheMeta> getOtherSatelliteFicheMetaList(FicheMeta satelliteFicheMeta) {
        Corpus currentCorpus = satelliteFicheMeta.getCorpus();
        Subset masterSubset = currentCorpus.getMasterSubset();
        List<Corpus> corpusList = masterSubset.getSatelliteCorpusList();
        if (corpusList.size() == 1) {
            return EMPTY_FICHEMETALIST;
        }
        int ficheid = satelliteFicheMeta.getId();
        ArrayList<FicheMeta> list = new ArrayList<FicheMeta>();
        for (Corpus corpus : corpusList) {
            FicheMeta ficheMeta;
            if (corpus.equals(currentCorpus) || (ficheMeta = corpus.getFicheMetaById(ficheid)) == null) continue;
            list.add(ficheMeta);
        }
        return list;
    }

    public static boolean hasChanges(FicheChange ficheChange) {
        return ficheChange.getFicheAPI() != null || !ficheChange.getRemovedList().isEmpty();
    }

    public static Fiche toFiche(FicheChange ficheChange) {
        Fiche fiche = new Fiche();
        CorpusUtils.updateFiche(fiche, ficheChange);
        return fiche;
    }

    public static void updateFiche(Fiche fiche, FicheChange ficheChange) {
        for (FieldKey fieldKey : ficheChange.getRemovedList()) {
            block0 : switch (fieldKey.getCategory()) {
                case 1: {
                    fiche.setPropriete(fieldKey, null);
                    break;
                }
                case 2: {
                    fiche.setInformation(fieldKey, null);
                    break;
                }
                case 3: {
                    fiche.setSection(fieldKey, null);
                    break;
                }
                case 0: {
                    switch (fieldKey.getKeyString()) {
                        case "titre": {
                            fiche.setTitre("");
                            break block0;
                        }
                        case "soustitre": {
                            fiche.setSoustitre(null);
                            break block0;
                        }
                        case "lang": {
                            fiche.setLang(null);
                            break block0;
                        }
                        case "redacteurs": {
                            fiche.setRedacteurs(null);
                            break block0;
                        }
                        case "id": {
                            break block0;
                        }
                    }
                    throw new SwitchException("Unknown special field = " + fieldKey.getKeyString());
                }
                default: {
                    throw new SwitchException("Unknown category = " + fieldKey.getCategory());
                }
            }
        }
        FicheAPI ficheAPI = ficheChange.getFicheAPI();
        if (ficheAPI != null) {
            FicheItems redacteurs;
            Lang lang;
            Para soustitre;
            String titre = ficheAPI.getTitre();
            if (titre.length() > 0) {
                fiche.setTitre(titre);
            }
            if ((soustitre = ficheAPI.getSoustitre()) != null) {
                fiche.setSoustitre(soustitre);
            }
            if ((lang = ficheAPI.getLang()) != null) {
                fiche.setLang(lang);
            }
            if ((redacteurs = ficheAPI.getRedacteurs()) != null) {
                fiche.setRedacteurs(redacteurs);
            }
            for (Propriete propriete : ficheAPI.getProprieteList()) {
                fiche.setPropriete(propriete.getFieldKey(), propriete.getFicheItem());
            }
            for (Information information : ficheAPI.getInformationList()) {
                fiche.setInformation(information.getFieldKey(), information);
            }
            for (Section section : ficheAPI.getSectionList()) {
                fiche.setSection(section.getFieldKey(), section);
            }
        }
    }

    public static void appendFiche(Fiche fiche, FicheChange ficheChange) {
        FicheAPI ficheAPI = ficheChange.getFicheAPI();
        if (ficheAPI != null) {
            FicheItems redacteurs;
            Lang lang;
            Para soustitre;
            String titre = ficheAPI.getTitre();
            if (titre.length() > 0) {
                fiche.setTitre(titre);
            }
            if ((soustitre = ficheAPI.getSoustitre()) != null) {
                fiche.setSoustitre(soustitre);
            }
            if ((lang = ficheAPI.getLang()) != null) {
                fiche.setLang(lang);
            }
            if ((redacteurs = ficheAPI.getRedacteurs()) != null) {
                fiche.appendRedacteurs(redacteurs);
            }
            for (Propriete propriete : ficheAPI.getProprieteList()) {
                fiche.setPropriete(propriete.getFieldKey(), propriete.getFicheItem());
            }
            for (Information information : ficheAPI.getInformationList()) {
                fiche.appendInformation(information.getFieldKey(), information);
            }
            for (Section section : ficheAPI.getSectionList()) {
                fiche.appendSection(section.getFieldKey(), section);
            }
        }
    }

    public static List<FicheMeta> wrap(FicheMeta[] array) {
        return new FicheMetaList(array);
    }

    public static List<Fiches.Entry> wrap(Fiches.Entry[] array) {
        return new EntryList(array);
    }

    public static Fiches toSingletonFiches(FicheMeta ficheMeta) {
        if (ficheMeta == null) {
            throw new IllegalArgumentException("ficheMeta is null");
        }
        return new SingletonFiches(ficheMeta);
    }

    public static Fiches reduce(Fiches fiches, Corpus corpus) {
        for (Fiches.Entry entry : fiches.getEntryList()) {
            if (!entry.getCorpus().equals(corpus)) continue;
            return new CorpusFiches(entry);
        }
        return EMPTY_FICHES;
    }

    public static Fiches reduce(Fiches fiches, int limit) {
        HashSet<FicheMeta> ficheMetaSet = new HashSet<FicheMeta>();
        ArrayList<Fiches.Entry> resultList = new ArrayList<Fiches.Entry>();
        for (Fiches.Entry entry : fiches.getEntryList()) {
            List<FicheMeta> ficheMetaList = entry.getFicheMetaList();
            int size = ficheMetaList.size();
            if (size <= limit) {
                for (FicheMeta ficheMeta : ficheMetaList) {
                    ficheMetaSet.add(ficheMeta);
                }
                resultList.add(entry);
                continue;
            }
            int count = 0;
            ArrayList<FicheMeta> filteredList = new ArrayList<FicheMeta>();
            for (FicheMeta ficheMeta : ficheMetaList) {
                filteredList.add(ficheMeta);
                ficheMetaSet.add(ficheMeta);
                if (++count != limit) continue;
                break;
            }
            resultList.add(CorpusUtils.toFichesEntry(entry.getCorpus(), filteredList));
        }
        return new InternalFiches(resultList, ficheMetaSet);
    }

    public static Fiches.Entry toFichesEntry(Corpus corpus, FicheMeta[] ficheMetaArray) {
        return new InternalEntry(corpus, ficheMetaArray);
    }

    public static Fiches.Entry toFichesEntry(Corpus corpus, Collection<FicheMeta> ficheMetas) {
        return new InternalEntry(corpus, ficheMetas.toArray(new FicheMeta[ficheMetas.size()]));
    }

    public static class FieldSelection {
        private final Set<FieldKey> proprieteSet = new HashSet<FieldKey>();
        private final Set<FieldKey> informationSet = new HashSet<FieldKey>();
        private final Set<String> sectionSet = new HashSet<String>();
        private boolean withRedacteurs = false;

        private FieldSelection() {
        }

        private void addField(CorpusField corpusField) {
            this.addField(corpusField.getFieldKey());
        }

        private void addField(FieldKey fieldKey) {
            switch (fieldKey.getCategory()) {
                case 1: {
                    this.proprieteSet.add(fieldKey);
                    break;
                }
                case 2: {
                    this.informationSet.add(fieldKey);
                    break;
                }
                case 3: {
                    this.sectionSet.add(fieldKey.getFieldName());
                    break;
                }
                case 0: {
                    switch (fieldKey.getKeyString()) {
                        case "redacteurs": {
                            this.withRedacteurs = true;
                        }
                    }
                }
            }
        }

        public boolean withPropriete() {
            return !this.proprieteSet.isEmpty();
        }

        public boolean withInformation() {
            return !this.informationSet.isEmpty();
        }

        public boolean withSection() {
            return !this.sectionSet.isEmpty();
        }

        public boolean withRedacteurs() {
            return this.withRedacteurs;
        }

        public boolean containsPropriete(FieldKey fieldKey) {
            return this.proprieteSet.contains(fieldKey);
        }

        public boolean containsInformation(FieldKey fieldKey) {
            return this.informationSet.contains(fieldKey);
        }

        public boolean containsSection(String type) {
            return this.sectionSet.contains(type);
        }
    }

    private static class FicheMetaList
    extends AbstractList<FicheMeta>
    implements RandomAccess {
        private final FicheMeta[] array;

        private FicheMetaList(FicheMeta[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public FicheMeta get(int index) {
            return this.array[index];
        }
    }

    private static class EntryList
    extends AbstractList<Fiches.Entry>
    implements RandomAccess {
        private final Fiches.Entry[] array;

        private EntryList(Fiches.Entry[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Fiches.Entry get(int index) {
            return this.array[index];
        }
    }

    private static class SingletonFiches
    implements Fiches {
        private final FicheMeta ficheMeta;
        private final List<Fiches.Entry> entryList;

        private SingletonFiches(FicheMeta ficheMeta) {
            this.ficheMeta = ficheMeta;
            FicheMeta[] ficheMetaArray = new FicheMeta[]{ficheMeta};
            Fiches.Entry[] array = new Fiches.Entry[]{CorpusUtils.toFichesEntry(ficheMeta.getCorpus(), ficheMetaArray)};
            this.entryList = CorpusUtils.wrap(array);
        }

        @Override
        public List<Fiches.Entry> getEntryList() {
            return this.entryList;
        }

        @Override
        public boolean test(FicheMeta otherFicheMeta) {
            return otherFicheMeta.equals(this.ficheMeta);
        }

        @Override
        public int getFicheCount() {
            return 1;
        }
    }

    private static class CorpusFiches
    implements Fiches {
        private final Fiches.Entry entry;
        private final List<Fiches.Entry> entryList;

        private CorpusFiches(Fiches.Entry entry) {
            this.entry = entry;
            this.entryList = Collections.singletonList(entry);
        }

        @Override
        public List<Fiches.Entry> getEntryList() {
            return this.entryList;
        }

        @Override
        public boolean test(FicheMeta ficheMeta) {
            return this.entry.getSubsetItemList().contains(ficheMeta);
        }

        @Override
        public int getFicheCount() {
            return this.entry.getFicheMetaList().size();
        }
    }

    private static class InternalFiches
    implements Fiches {
        private final Set<FicheMeta> ficheMetaSet;
        private final List<Fiches.Entry> entryList;

        private InternalFiches(List<Fiches.Entry> entryList, Set<FicheMeta> ficheMetaSet) {
            this.entryList = entryList;
            this.ficheMetaSet = ficheMetaSet;
        }

        @Override
        public List<Fiches.Entry> getEntryList() {
            return this.entryList;
        }

        @Override
        public boolean test(FicheMeta ficheMeta) {
            return this.ficheMetaSet.contains(ficheMeta);
        }

        @Override
        public int getFicheCount() {
            return this.ficheMetaSet.size();
        }
    }

    private static class InternalEntry
    implements Fiches.Entry {
        private final Corpus corpus;
        private final List<FicheMeta> ficheMetaList;
        private final List<SubsetItem> subsetItemList;

        private InternalEntry(Corpus corpus, FicheMeta[] ficheMetaArray) {
            this.corpus = corpus;
            this.ficheMetaList = CorpusUtils.wrap(ficheMetaArray);
            this.subsetItemList = FichothequeUtils.wrap(ficheMetaArray);
        }

        @Override
        public Corpus getCorpus() {
            return this.corpus;
        }

        @Override
        public List<FicheMeta> getFicheMetaList() {
            return this.ficheMetaList;
        }

        @Override
        public List<SubsetItem> getSubsetItemList() {
            return this.subsetItemList;
        }
    }

    private static class EmptyFiches
    implements Fiches {
        private EmptyFiches() {
        }

        @Override
        public List<Fiches.Entry> getEntryList() {
            return EMPTY_FICHESENTRYLIST;
        }

        @Override
        public boolean test(FicheMeta ficheMeta) {
            return false;
        }

        @Override
        public int getFicheCount() {
            return 0;
        }
    }

    private static class EmptyFicheChange
    implements FicheChange {
        private EmptyFicheChange() {
        }

        @Override
        public FicheAPI getFicheAPI() {
            return null;
        }

        @Override
        public List<FieldKey> getRemovedList() {
            return CorpusMetadataUtils.EMPTY_FIELDKEYLIST;
        }
    }
}

