/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.valueresolvers;

import java.text.ParseException;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.fiche.Propriete;
import net.fichotheque.corpus.metadata.FieldKey;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.AccoladeArgument;
import net.mapeadores.util.text.AccoladePattern;
import net.mapeadores.util.text.ValueResolver;

public class FicheValueResolver
implements ValueResolver {
    public static final String CORPUS = "corpus";
    private final FicheMeta ficheMeta;
    private final Corpus corpus;
    private FicheAPI fiche;

    public FicheValueResolver(FicheMeta ficheMeta) {
        this.ficheMeta = ficheMeta;
        this.corpus = ficheMeta.getCorpus();
    }

    @Override
    public final String getValue(AccoladeArgument accoladeArgument) {
        if (accoladeArgument.getName().equals(CORPUS)) {
            return this.corpus.getSubsetName();
        }
        if (accoladeArgument instanceof FicheAccoladeArgument) {
            return this.getValue((FicheAccoladeArgument)accoladeArgument);
        }
        FicheAccoladeArgument fichePatternArgument = FicheValueResolver.parse(accoladeArgument.getName(), accoladeArgument.getMode());
        if (fichePatternArgument != null) {
            return this.getValue(fichePatternArgument);
        }
        return AccoladePattern.toString(accoladeArgument);
    }

    private String getValue(FicheAccoladeArgument ficheAccoladeArgument) {
        FieldKey fieldKey = ficheAccoladeArgument.getFieldKey();
        switch (fieldKey.getKeyString()) {
            case "id": {
                return String.valueOf(this.ficheMeta.getId());
            }
            case "lang": {
                Lang lang = this.ficheMeta.getLang();
                if (lang != null) {
                    return lang.toString();
                }
                return "";
            }
            case "titre": {
                return this.ficheMeta.getTitre();
            }
        }
        if (fieldKey.isPropriete()) {
            Propriete propriete;
            if (this.fiche == null) {
                this.fiche = this.ficheMeta.getFicheAPI(false);
            }
            if ((propriete = this.fiche.getPropriete(fieldKey)) == null) {
                return "";
            }
            FicheItem ficheItem = propriete.getFicheItem();
            if (ficheItem instanceof Item) {
                return ((Item)ficheItem).getValue();
            }
            return AccoladePattern.toString(ficheAccoladeArgument);
        }
        return AccoladePattern.toString(ficheAccoladeArgument);
    }

    private static FicheAccoladeArgument parse(String name, String mode) {
        if (name.equals(CORPUS)) {
            return new FicheAccoladeArgument(name, mode, null);
        }
        try {
            FieldKey fieldKey = FieldKey.parse(name);
            return new FicheAccoladeArgument(name, mode, fieldKey);
        }
        catch (ParseException pe) {
            return null;
        }
    }

    private static class FicheAccoladeArgument
    implements AccoladeArgument {
        private final String name;
        private final String mode;
        private final FieldKey fieldKey;

        private FicheAccoladeArgument(String name, String mode, FieldKey fieldKey) {
            this.name = name;
            this.mode = mode;
            this.fieldKey = fieldKey;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getMode() {
            return this.mode;
        }

        public FieldKey getFieldKey() {
            return this.fieldKey;
        }
    }
}

