/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.thesaurus;

import java.util.List;
import java.util.TreeSet;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.ThesaurusEditor;

public class IdalphaSortEngine {
    private final ThesaurusEditor thesaurusEditor;
    private boolean recursive = false;
    private boolean descending = false;
    private boolean ignoreCase = false;
    private boolean ignorePunctuation = false;

    public IdalphaSortEngine(ThesaurusEditor thesaurusEditor) {
        this.thesaurusEditor = thesaurusEditor;
    }

    public IdalphaSortEngine setRecursive(boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    public IdalphaSortEngine setDescending(boolean descending) {
        this.descending = descending;
        return this;
    }

    public IdalphaSortEngine setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        return this;
    }

    public IdalphaSortEngine setIgnorePunctuation(boolean ignorePunctuation) {
        this.ignorePunctuation = ignorePunctuation;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public void sort(Motcle motcle) {
        List<Motcle> children = motcle != null ? motcle.getChildList() : this.thesaurusEditor.getThesaurus().getFirstLevelList();
        int size = children.size();
        if (size == 0) {
            return;
        }
        if (size == 1) {
            if (this.recursive) {
                this.sort(children.get(0));
            }
            return;
        }
        TreeSet<MotcleBundle> treeSet = new TreeSet<MotcleBundle>();
        for (Motcle motcle2 : children) {
            treeSet.add(new MotcleBundle(motcle2));
        }
        int p = this.descending ? size - 1 : 0;
        for (MotcleBundle motcleBundle : treeSet) {
            Motcle child = motcleBundle.motcle;
            if (child.getChildIndex() != p) {
                this.thesaurusEditor.setChildIndex(child, p);
            }
            if (this.descending) {
                --p;
                continue;
            }
            ++p;
        }
        if (this.recursive) {
            void var6_10;
            boolean bl = false;
            while (var6_10 < size) {
                this.sort(children.get((int)var6_10));
                ++var6_10;
            }
        }
    }

    public static IdalphaSortEngine init(ThesaurusEditor thesaurusEditor) {
        return new IdalphaSortEngine(thesaurusEditor);
    }

    private String charcleanIdalpha(String idalpha) {
        if (this.ignorePunctuation) {
            int length = idalpha.length();
            StringBuilder buf = new StringBuilder(length);
            for (int i = 0; i < length; ++i) {
                char carac = idalpha.charAt(i);
                if (!Character.isLetterOrDigit(carac)) continue;
                if (this.ignoreCase) {
                    carac = Character.toUpperCase(carac);
                }
                buf.append(carac);
            }
            return buf.toString();
        }
        if (this.ignoreCase) {
            return idalpha.toUpperCase();
        }
        return idalpha;
    }

    private String cleanIdalpha(String idalpha) {
        String result = this.charcleanIdalpha(idalpha);
        try {
            int itg = Integer.parseInt(result);
            if (itg < 0) {
                return result;
            }
            StringBuilder buf = new StringBuilder(16);
            int length = result.length();
            for (int i = 0; i < 11 - length; ++i) {
                buf.append('0');
            }
            buf.append(result);
            return buf.toString();
        }
        catch (NumberFormatException nfe) {
            return result;
        }
    }

    private class MotcleBundle
    implements Comparable {
        private final String cleanedIdalpha;
        private final String idalpha;
        private final Motcle motcle;

        private MotcleBundle(Motcle motcle) {
            this.motcle = motcle;
            this.idalpha = motcle.getIdalpha();
            this.cleanedIdalpha = IdalphaSortEngine.this.cleanIdalpha(this.idalpha);
        }

        public int hashCode() {
            return this.idalpha.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof MotcleBundle)) {
                return false;
            }
            return ((MotcleBundle)obj).idalpha.equals(this.idalpha);
        }

        public int compareTo(Object obj) {
            MotcleBundle other = (MotcleBundle)obj;
            int val = this.cleanedIdalpha.compareTo(other.cleanedIdalpha);
            if (val != 0) {
                return val;
            }
            return this.idalpha.compareTo(other.idalpha);
        }
    }
}

