/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.sphere;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import net.fichotheque.Fichotheque;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.fichotheque.utils.SphereUtils;

public class RedacteurStats {
    private final Redacteur redacteur;
    private final List<ByCorpusStats> byCorpusStatsList = new ArrayList<ByCorpusStats>();
    private int count = 0;

    public RedacteurStats(Redacteur redacteur) {
        this.redacteur = redacteur;
        this.init();
    }

    public boolean isEmpty() {
        return this.byCorpusStatsList.isEmpty();
    }

    public int getFicheCount() {
        return this.count;
    }

    private void init() {
        Fichotheque fichotheque = this.redacteur.getFichotheque();
        for (Corpus corpus : fichotheque.getCorpusList()) {
            ByCorpusStats byCorpusStats;
            List<CorpusField> fieldList = CorpusMetadataUtils.getCorpusFieldListByFicheItemType(corpus.getCorpusMetadata(), (short)2, false);
            if (fieldList.isEmpty()) {
                byCorpusStats = this.initRedacteur(corpus);
            } else {
                FieldKey[] fieldArray = CorpusMetadataUtils.toFieldKeyArray(fieldList);
                byCorpusStats = this.initRedacteurAndFields(corpus, fieldArray);
            }
            if (byCorpusStats == null) continue;
            this.byCorpusStatsList.add(byCorpusStats);
            this.count += byCorpusStats.getFicheCount();
        }
    }

    private ByCorpusStats initRedacteur(Corpus corpus) {
        ByCorpusStats byCorpusStats = null;
        String globalId = this.redacteur.getGlobalId();
        for (FicheMeta ficheMeta : corpus.getFicheMetaList()) {
            if (!SphereUtils.ownsToRedacteur(ficheMeta, globalId)) continue;
            if (byCorpusStats == null) {
                byCorpusStats = new ByCorpusStats(corpus);
            }
            byCorpusStats.add(ficheMeta.getId(), 1);
        }
        return byCorpusStats;
    }

    private ByCorpusStats initRedacteurAndFields(Corpus corpus, FieldKey[] fieldArray) {
        String globalId = this.redacteur.getGlobalId();
        ByCorpusStats byCorpusStats = null;
        for (FicheMeta ficheMeta : corpus.getFicheMetaList()) {
            int poids = 0;
            if (SphereUtils.ownsToRedacteur(ficheMeta, globalId)) {
                poids = 1;
            }
            FicheAPI fiche = corpus.getFicheAPI(ficheMeta, false);
            block5: for (FieldKey fieldKey : fieldArray) {
                Object value = fiche.getValue(fieldKey);
                if (value == null) continue;
                switch (fieldKey.getCategory()) {
                    case 1: {
                        boolean here = SphereUtils.testFicheItem(this.redacteur, (FicheItem)value);
                        if (!here) continue block5;
                        poids |= 2;
                        continue block5;
                    }
                    case 2: {
                        for (FicheItem ficheItem : (FicheItems)value) {
                            boolean here = SphereUtils.testFicheItem(this.redacteur, ficheItem);
                            if (!here) continue;
                            poids |= 4;
                            continue block5;
                        }
                        continue block5;
                    }
                }
            }
            if (poids <= 0) continue;
            if (byCorpusStats == null) {
                byCorpusStats = new ByCorpusStats(corpus);
            }
            byCorpusStats.add(ficheMeta.getId(), poids);
        }
        return byCorpusStats;
    }

    public List<ByCorpusStats> getByCorpusStatsList() {
        return this.byCorpusStatsList;
    }

    public static class ByCorpusStats {
        private final Corpus corpus;
        private final SortedMap<Integer, ByFicheStats> treeMap = new TreeMap<Integer, ByFicheStats>();

        ByCorpusStats(Corpus corpus) {
            this.corpus = corpus;
        }

        public int getFicheCount() {
            return this.treeMap.size();
        }

        public Corpus getCorpus() {
            return this.corpus;
        }

        private void add(int id, int poids) {
            ByFicheStats byFicheStats = new ByFicheStats(id, poids);
            this.treeMap.put(id, byFicheStats);
        }

        public List<ByFicheStats> getByFicheStatsList() {
            return new ArrayList<ByFicheStats>(this.treeMap.values());
        }
    }

    public static class ByFicheStats {
        private final int id;
        private final int poids;

        ByFicheStats(int id, int poids) {
            this.id = id;
            this.poids = poids;
        }

        public int getId() {
            return this.id;
        }

        public int getPoids() {
            return this.poids;
        }
    }
}

