/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.selection;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import net.fichotheque.SubsetKey;
import net.fichotheque.selection.FicheCondition;
import net.fichotheque.selection.MotcleQuery;
import net.fichotheque.selection.RangeCondition;
import net.fichotheque.selection.StatusCondition;
import net.fichotheque.selection.SubsetCondition;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.SelectionUtils;
import net.fichotheque.utils.selection.FicheConditionBuilder;
import net.mapeadores.util.conditions.TextCondition;

public class MotcleQueryBuilder {
    private final Set<SubsetKey> thesaurusKeySet = new LinkedHashSet<SubsetKey>();
    private final FicheConditionBuilder ficheConditionBuilder = FicheConditionBuilder.init().setLogicalOperator("and");
    private final Set<String> statusSet = new LinkedHashSet<String>();
    private RangeCondition idRangeCondition = null;
    private RangeCondition levelRangeCondition = null;
    private TextCondition contentTextCondition = null;
    private String contentConditionScope = null;
    private boolean withCurrentThesaurus = false;
    private boolean exclude = false;

    public MotcleQueryBuilder addThesaurus(Object object) {
        block8: {
            block9: {
                block7: {
                    if (object == null) {
                        return this;
                    }
                    if (!(object instanceof Thesaurus)) break block7;
                    this.thesaurusKeySet.add(((Thesaurus)object).getSubsetKey());
                    break block8;
                }
                if (!(object instanceof SubsetKey)) break block9;
                SubsetKey subsetKey = (SubsetKey)object;
                if (!subsetKey.isThesaurusSubset()) break block8;
                this.thesaurusKeySet.add(subsetKey);
                break block8;
            }
            if (object instanceof Collection) {
                for (Object obj : (Collection)object) {
                    SubsetKey subsetKey;
                    if (obj == null) continue;
                    if (obj instanceof Thesaurus) {
                        this.thesaurusKeySet.add(((Thesaurus)obj).getSubsetKey());
                        continue;
                    }
                    if (!(obj instanceof SubsetKey) || !(subsetKey = (SubsetKey)obj).isThesaurusSubset()) continue;
                    this.thesaurusKeySet.add(subsetKey);
                }
            } else if (object instanceof SubsetKey[]) {
                for (SubsetKey subsetKey : (SubsetKey[])object) {
                    if (subsetKey == null || !subsetKey.isThesaurusSubset()) continue;
                    this.thesaurusKeySet.add(subsetKey);
                }
            }
        }
        return this;
    }

    public MotcleQueryBuilder setIdRangeCondition(RangeCondition idRangeCondition) {
        this.idRangeCondition = idRangeCondition;
        return this;
    }

    public MotcleQueryBuilder setLevelRangeCondition(RangeCondition levelRangeCondition) {
        this.levelRangeCondition = levelRangeCondition;
        return this;
    }

    public MotcleQueryBuilder setContentCondition(TextCondition contentTextCondition, String contentConditionScope) {
        this.contentTextCondition = contentTextCondition;
        this.contentConditionScope = MotcleQuery.checkScope(contentConditionScope);
        return this;
    }

    public MotcleQueryBuilder addFicheConditionQuery(FicheCondition.Entry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("ficheQuery is null");
        }
        this.ficheConditionBuilder.addEntry(entry);
        return this;
    }

    public MotcleQueryBuilder setFicheLogicalOperator(String ficheLogicalOperator) {
        this.ficheConditionBuilder.setLogicalOperator(ficheLogicalOperator);
        return this;
    }

    public MotcleQueryBuilder setWithCurrentThesaurus(boolean withCurrentThesaurus) {
        this.withCurrentThesaurus = withCurrentThesaurus;
        return this;
    }

    public MotcleQueryBuilder setExclude(boolean exclude) {
        this.exclude = exclude;
        return this;
    }

    public MotcleQueryBuilder addStatus(String status) {
        if (!status.isEmpty()) {
            this.statusSet.add(status);
        }
        return this;
    }

    public MotcleQuery toMotcleQuery() {
        SubsetCondition thesaurusCondition = SelectionUtils.toSubsetCondition(new LinkedHashSet<SubsetKey>(this.thesaurusKeySet), this.withCurrentThesaurus, this.exclude);
        StatusCondition statusCondition = SelectionUtils.toStatusCondition(this.statusSet);
        FicheCondition ficheCondition = this.ficheConditionBuilder.isEmpty() ? null : this.ficheConditionBuilder.toFicheCondition();
        InternalContentCondition contentCondition = null;
        if (this.contentTextCondition != null) {
            contentCondition = new InternalContentCondition(this.contentConditionScope, this.contentTextCondition);
        }
        return new InternalMotcleQuery(thesaurusCondition, this.idRangeCondition, this.levelRangeCondition, contentCondition, ficheCondition, statusCondition);
    }

    public static MotcleQueryBuilder init() {
        return new MotcleQueryBuilder();
    }

    private static class InternalContentCondition
    implements MotcleQuery.ContentCondition {
        private final String scope;
        private final TextCondition textCondition;

        private InternalContentCondition(String scope, TextCondition textCondition) {
            this.scope = scope;
            this.textCondition = textCondition;
        }

        @Override
        public String getScope() {
            return this.scope;
        }

        @Override
        public TextCondition getTextCondition() {
            return this.textCondition;
        }
    }

    private static class InternalMotcleQuery
    implements MotcleQuery {
        private final SubsetCondition thesaurusCondition;
        private final RangeCondition idRangeCondition;
        private final RangeCondition levelRangeCondition;
        private final MotcleQuery.ContentCondition contentCondition;
        private final FicheCondition ficheCondition;
        private final StatusCondition statusCondition;

        private InternalMotcleQuery(SubsetCondition thesaurusCondition, RangeCondition idRangeCondition, RangeCondition levelRangeCondition, MotcleQuery.ContentCondition contentCondition, FicheCondition ficheCondition, StatusCondition statusCondition) {
            this.thesaurusCondition = thesaurusCondition;
            this.idRangeCondition = idRangeCondition;
            this.levelRangeCondition = levelRangeCondition;
            this.contentCondition = contentCondition;
            this.ficheCondition = ficheCondition;
            this.statusCondition = statusCondition;
        }

        @Override
        public SubsetCondition getThesaurusCondition() {
            return this.thesaurusCondition;
        }

        @Override
        public RangeCondition getIdRangeCondition() {
            return this.idRangeCondition;
        }

        @Override
        public RangeCondition getLevelRangeCondition() {
            return this.levelRangeCondition;
        }

        @Override
        public MotcleQuery.ContentCondition getContentCondition() {
            return this.contentCondition;
        }

        @Override
        public FicheCondition getFicheCondition() {
            return this.ficheCondition;
        }

        @Override
        public StatusCondition getStatusCondition() {
            return this.statusCondition;
        }
    }
}

