/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.selection;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.fichotheque.SubsetKey;
import net.fichotheque.album.Album;
import net.fichotheque.selection.IllustrationQuery;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.text.StringUtils;

public class IllustrationQueryBuilder {
    private final Set<SubsetKey> albumKeySet = new LinkedHashSet<SubsetKey>();
    private final Set<String> dimNameSet = new LinkedHashSet<String>();

    public IllustrationQueryBuilder addAlbum(Object object) {
        block8: {
            block9: {
                block7: {
                    if (object == null) {
                        return this;
                    }
                    if (!(object instanceof Album)) break block7;
                    this.albumKeySet.add(((Album)object).getSubsetKey());
                    break block8;
                }
                if (!(object instanceof SubsetKey)) break block9;
                SubsetKey subsetKey = (SubsetKey)object;
                if (!subsetKey.isAlbumSubset()) break block8;
                this.albumKeySet.add(subsetKey);
                break block8;
            }
            if (object instanceof Collection) {
                for (Object obj : (Collection)object) {
                    SubsetKey subsetKey;
                    if (obj == null) continue;
                    if (obj instanceof Album) {
                        this.albumKeySet.add(((Album)obj).getSubsetKey());
                        continue;
                    }
                    if (!(obj instanceof SubsetKey) || !(subsetKey = (SubsetKey)obj).isAlbumSubset()) continue;
                    this.albumKeySet.add(subsetKey);
                }
            } else if (object instanceof SubsetKey[]) {
                for (SubsetKey subsetKey : (SubsetKey[])object) {
                    if (subsetKey == null || !subsetKey.isAlbumSubset()) continue;
                    this.albumKeySet.add(subsetKey);
                }
            }
        }
        return this;
    }

    public IllustrationQueryBuilder addAlbumDimName(String albumDimName) {
        this.dimNameSet.add(albumDimName);
        return this;
    }

    public IllustrationQuery toIllustrationQuery() {
        List<SubsetKey> subsetKeyList = FichothequeUtils.wrap(this.albumKeySet.toArray(new SubsetKey[this.albumKeySet.size()]));
        List<String> dimNameList = StringUtils.toList(this.dimNameSet);
        return new InternalIllustrationQuery(subsetKeyList, dimNameList);
    }

    public static IllustrationQueryBuilder init() {
        return new IllustrationQueryBuilder();
    }

    private static class InternalIllustrationQuery
    implements IllustrationQuery {
        private final List<SubsetKey> albumKeyList;
        private final List<String> dimNameList;

        private InternalIllustrationQuery(List<SubsetKey> subsetKeyList, List<String> dimNameList) {
            this.albumKeyList = subsetKeyList;
            this.dimNameList = dimNameList;
        }

        @Override
        public List<SubsetKey> getAlbumKeyList() {
            return this.albumKeyList;
        }

        @Override
        public List<String> getAlbumDimNameList() {
            return this.dimNameList;
        }
    }
}

