/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.reponderation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.fichotheque.Fichotheque;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.croisement.CroisementChange;
import net.fichotheque.croisement.CroisementChanges;
import net.fichotheque.croisement.CroisementEditor;
import net.fichotheque.croisement.Liaison;
import net.fichotheque.croisement.Lien;
import net.fichotheque.tools.croisement.CroisementChangeEngine;
import net.fichotheque.tools.reponderation.ReponderationLog;
import net.fichotheque.tools.reponderation.ReponderationParameters;
import net.fichotheque.utils.CroisementUtils;

public final class ReponderationEngine {
    private final ReponderationLog reponderationLog;
    private final Fichotheque fichotheque;
    private final ReponderationParameters reponderationParameters;
    private final FichothequeEditor fichothequeEditor;

    private ReponderationEngine(ReponderationParameters reponderationParameters, FichothequeEditor fichothequeEditor) {
        this.reponderationLog = new ReponderationLog(reponderationParameters);
        this.fichothequeEditor = fichothequeEditor;
        this.fichotheque = fichothequeEditor.getFichotheque();
        this.reponderationParameters = reponderationParameters;
    }

    private ReponderationEngine(ReponderationParameters reponderationParameters, Fichotheque fichotheque) {
        this.reponderationLog = new ReponderationLog(reponderationParameters);
        this.fichotheque = fichotheque;
        this.reponderationParameters = reponderationParameters;
        this.fichothequeEditor = null;
    }

    public static ReponderationLog run(ReponderationParameters reponderationDef, FichothequeEditor fichothequeEditor) {
        ReponderationEngine reponderationEngine = new ReponderationEngine(reponderationDef, fichothequeEditor);
        reponderationEngine.innerRun(false);
        return reponderationEngine.reponderationLog;
    }

    public static ReponderationLog test(ReponderationParameters reponderationDef, Fichotheque fichotheque) {
        ReponderationEngine reponderationEngine = new ReponderationEngine(reponderationDef, fichotheque);
        reponderationEngine.innerRun(true);
        return reponderationEngine.reponderationLog;
    }

    private void innerRun(boolean test) {
        SubsetKey croisementSubsetKey;
        Subset croisementSubset;
        SubsetKey originSubsetKey = this.reponderationParameters.getOriginSubsetKey();
        Subset origineSubset = this.fichotheque.getSubset(originSubsetKey);
        if (origineSubset == null) {
            this.addError("origin_unknownsubset");
        }
        if ((croisementSubset = this.fichotheque.getSubset(croisementSubsetKey = this.reponderationParameters.getCroisementSubsetKey())) == null) {
            this.addError("croisement_unknownsubset");
        }
        if (this.hasError()) {
            return;
        }
        List<SubsetItem> originSubsetItemList = this.getOriginSubsetItemList(origineSubset);
        if (this.hasError()) {
            return;
        }
        if (test) {
            return;
        }
        String oldMode = this.reponderationParameters.getOldMode();
        String newMode = this.reponderationParameters.getNewMode();
        int oldPoids = this.reponderationParameters.getOldPoids();
        int newPoids = this.reponderationParameters.getNewPoids();
        CroisementEditor croisementEditor = this.fichothequeEditor.getCroisementEditor();
        for (SubsetItem originSubsetItem : originSubsetItemList) {
            CroisementChangeEngine croisementChangeEngine = CroisementChangeEngine.appendOrPoidsReplaceEngine(originSubsetItem);
            Collection<Liaison> liaisons = CroisementUtils.filter(this.fichotheque.getCroisements(originSubsetItem, croisementSubset), oldMode);
            boolean done = false;
            for (Liaison liaison : liaisons) {
                int poids = liaison.getLien().getPoids();
                if (oldPoids != -1 && poids != oldPoids) continue;
                if (newPoids != -1) {
                    poids = newPoids;
                }
                SubsetItem subsetItem = liaison.getSubsetItem();
                croisementChangeEngine.addLien(subsetItem, newMode, poids);
                this.addResult(originSubsetItem.getId(), subsetItem.getId());
                done = true;
            }
            if (!done) continue;
            CroisementChanges croisementChanges = croisementChangeEngine.toCroisementChanges();
            if (!oldMode.equals(newMode)) {
                croisementChanges = ReponderationEngine.alter(croisementChanges, oldMode);
            }
            croisementEditor.updateCroisements(originSubsetItem, croisementChanges);
        }
    }

    private List<SubsetItem> getOriginSubsetItemList(Subset origineCorpus) {
        ArrayList<SubsetItem> originSubsetItemList = new ArrayList<SubsetItem>();
        int ficheCount = this.reponderationParameters.getOriginIdCount();
        for (int i = 0; i < ficheCount; ++i) {
            int originSubsetItem = this.reponderationParameters.getOriginId(i);
            SubsetItem subsetItem = origineCorpus.getSubsetItemById(originSubsetItem);
            if (subsetItem == null) {
                this.addIdError("missing_origin_id_error", originSubsetItem);
                continue;
            }
            originSubsetItemList.add(subsetItem);
        }
        return originSubsetItemList;
    }

    private void addError(String errorKey) {
        this.reponderationLog.addErrorKey(errorKey);
    }

    private void addIdError(String errorKey, int id) {
        this.reponderationLog.addIdError(errorKey, id);
    }

    private boolean hasError() {
        return this.reponderationLog.hasError();
    }

    private void addResult(int originId, int croisementId) {
        this.reponderationLog.addResult(originId, croisementId);
    }

    private static CroisementChanges alter(CroisementChanges croisementChanges, String oldMode) {
        ArrayList<CroisementChanges.Entry> alteredList = new ArrayList<CroisementChanges.Entry>();
        for (CroisementChanges.Entry entry : croisementChanges.getEntryList()) {
            alteredList.add(CroisementUtils.toEntry(entry.getSubsetItem(), new WrappedCroisementChange(oldMode, entry.getCroisementChange())));
        }
        return new WrappedCroisementChanges(croisementChanges.getRemovedList(), Collections.unmodifiableList(alteredList));
    }

    private static class WrappedCroisementChange
    implements CroisementChange {
        private final List<String> oldModeList;
        private final CroisementChange croisementChange;

        private WrappedCroisementChange(String oldMode, CroisementChange croisementChange) {
            this.oldModeList = Collections.singletonList(oldMode);
            this.croisementChange = croisementChange;
        }

        @Override
        public List<String> getRemovedModeList() {
            return this.oldModeList;
        }

        @Override
        public List<Lien> getChangedLienList() {
            return this.croisementChange.getChangedLienList();
        }
    }

    private static class WrappedCroisementChanges
    implements CroisementChanges {
        private final List<SubsetItem> removedList;
        private final List<CroisementChanges.Entry> entryList;

        private WrappedCroisementChanges(List<SubsetItem> removedSubsetItemList, List<CroisementChanges.Entry> entryList) {
            this.removedList = removedSubsetItemList;
            this.entryList = entryList;
        }

        @Override
        public List<SubsetItem> getRemovedList() {
            return this.removedList;
        }

        @Override
        public List<CroisementChanges.Entry> getEntryList() {
            return this.entryList;
        }
    }
}

