/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers.croisement;

import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.parsers.croisement.LienToken;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.CleanedString;

public class PoidsMotcleToken {
    private boolean idBundle = false;
    private int poids = 1;
    private int id;
    private CleanedString text;

    private PoidsMotcleToken(int id, int poids) {
        this.id = id;
        this.poids = poids;
        this.idBundle = true;
    }

    private PoidsMotcleToken(CleanedString text, int poids) {
        this.text = CleanedString.newInstance(text);
        this.poids = poids;
        this.idBundle = false;
    }

    public static PoidsMotcleToken parse(String s, boolean withIdalpha, int poidsFilter) {
        CleanedString cleanedString;
        LienToken lienToken = LienToken.parse(s);
        String text = lienToken.getText();
        int poids = poidsFilter < 1 ? lienToken.getPoids() : poidsFilter;
        if (!withIdalpha) {
            try {
                int id = Integer.parseInt(text);
                return new PoidsMotcleToken(id, poids);
            }
            catch (NumberFormatException id) {
                // empty catch block
            }
        }
        if (text.startsWith("=")) {
            try {
                int id = Integer.parseInt(text.substring(1).trim());
                return new PoidsMotcleToken(id, poids);
            }
            catch (NumberFormatException id) {
                // empty catch block
            }
        }
        if ((cleanedString = CleanedString.newInstance(text)) == null) {
            return null;
        }
        return new PoidsMotcleToken(cleanedString, poids);
    }

    public boolean isIdBundle() {
        return this.idBundle;
    }

    public int getPoids() {
        return this.poids;
    }

    public int getId() {
        return this.id;
    }

    public void setPoids(int poids) {
        this.poids = poids;
    }

    public CleanedString getText() {
        return this.text;
    }

    public static Motcle getMotcle(PoidsMotcleToken motcleToken, Thesaurus thesaurus, Lang lang) {
        if (motcleToken.isIdBundle()) {
            return thesaurus.getMotcleById(motcleToken.getId());
        }
        CleanedString cleanedString = motcleToken.getText();
        if (cleanedString == null) {
            return null;
        }
        String text = cleanedString.toString();
        if (thesaurus.isIdalphaType()) {
            return thesaurus.getMotcleByIdalpha(text);
        }
        return thesaurus.seekMotcleByLabel(text, lang);
    }
}

