/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers.croisement;

import net.fichotheque.addenda.Addenda;
import net.fichotheque.addenda.Document;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.tools.croisement.LienBuffer;

class DocumentAddToken {
    private final Document document;
    private final String mode;
    private final int poids;

    private DocumentAddToken(Document document, String mode, int poids) {
        this.document = document;
        this.mode = mode;
        this.poids = poids;
    }

    LienBuffer toLienBuffer() {
        return new LienBuffer(this.document, this.mode, this.poids);
    }

    static DocumentAddToken parse(String tokenString, Addenda addenda, IncludeKey includeKey) {
        Document document;
        try {
            int documentId = Integer.parseInt(tokenString);
            document = addenda.getDocumentById(documentId);
        }
        catch (NumberFormatException nfe) {
            document = addenda.getDocumentByBasename(tokenString);
        }
        if (document != null) {
            return new DocumentAddToken(document, includeKey.getMode(), includeKey.getPoidsFilter());
        }
        return null;
    }
}

