/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.fiche.Courriel;
import net.fichotheque.corpus.fiche.Datation;
import net.fichotheque.corpus.fiche.FicheBlock;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.Geopoint;
import net.fichotheque.corpus.fiche.Image;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.fiche.Langue;
import net.fichotheque.corpus.fiche.Link;
import net.fichotheque.corpus.fiche.Montant;
import net.fichotheque.corpus.fiche.Nombre;
import net.fichotheque.corpus.fiche.Para;
import net.fichotheque.corpus.fiche.Pays;
import net.fichotheque.corpus.fiche.Personne;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.corpus.metadata.SubfieldKey;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.tools.corpus.FicheChangeBuilder;
import net.fichotheque.tools.parsers.TextContentParser;
import net.fichotheque.tools.parsers.TypoParser;
import net.fichotheque.tools.parsers.ficheblock.FicheBlockParser;
import net.fichotheque.utils.FicheUtils;
import net.fichotheque.utils.SphereUtils;
import net.mapeadores.util.conditions.ConditionsUtils;
import net.mapeadores.util.conditions.TextCondition;
import net.mapeadores.util.conditions.TextConditionBuilder;
import net.mapeadores.util.conditions.TextTest;
import net.mapeadores.util.html.HtmlCleaner;
import net.mapeadores.util.localisation.CodeCatalog;
import net.mapeadores.util.localisation.Country;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.UserLangContext;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.models.EmailCoreUtils;
import net.mapeadores.util.models.PersonCore;
import net.mapeadores.util.models.PersonCoreUtils;
import net.mapeadores.util.money.Currencies;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.money.MoneyUtils;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.primitives.DegreDecimal;
import net.mapeadores.util.primitives.DegreSexagesimal;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.DateFormatBundle;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.text.TypoOptions;

public class FicheParser {
    private final Parameters parameters;
    private final Fichotheque fichotheque;
    private final FicheChangeBuilder ficheChangeBuilder;
    private final FicheBlockParser ficheBlockParser;
    private final DateFormatBundle dateFormatBundle;
    private final TypoOptions typoOptions;
    private final TextContentParser textContentParser;
    private final Map<FieldKey, SubfieldBuffer> subfieldBufferMap = new HashMap<FieldKey, SubfieldBuffer>();
    private SubsetKey defaultSphereKey = null;

    public FicheParser(Parameters parameters, Corpus corpus, FicheChangeBuilder ficheChangeBuilder) {
        this.parameters = parameters;
        this.ficheChangeBuilder = ficheChangeBuilder;
        this.dateFormatBundle = DateFormatBundle.getDateFormatBundle(parameters.getUserLangContext().getFormatLocale());
        Redacteur userRedacteur = parameters.getUserRedacteur();
        if (userRedacteur != null) {
            this.defaultSphereKey = userRedacteur.getSubsetKey();
        }
        this.typoOptions = parameters.getTypoOptions();
        this.fichotheque = corpus.getFichotheque();
        this.textContentParser = new TextContentParser(this.typoOptions);
        this.ficheBlockParser = new FicheBlockParser(parameters.getHtmlCleaner(), this.typoOptions, false);
    }

    public void flushParsedSubfields() {
        for (SubfieldBuffer subfieldBuffer : this.subfieldBufferMap.values()) {
            subfieldBuffer.flush();
        }
    }

    public void parseCorpusField(CorpusField corpusField, String value) {
        block0 : switch (corpusField.getCategory()) {
            case 1: {
                this.parsePropriete(corpusField, this.cleanProprieteToken(value, this.parameters.getItemListSeparateur()));
                break;
            }
            case 2: {
                String[] tokens = StringUtils.getTechnicalTokens(value, this.parameters.getItemListSeparateur(), false);
                this.parseInformation(corpusField, tokens);
                break;
            }
            case 3: {
                this.parseSection(corpusField, value);
                break;
            }
            case 0: {
                switch (corpusField.getFieldString()) {
                    case "titre": {
                        this.parseTitre(value);
                        break block0;
                    }
                    case "soustitre": {
                        this.parseSoustitre(value);
                        break block0;
                    }
                    case "lang": {
                        this.parseFicheLang(value);
                        break block0;
                    }
                    case "redacteurs": {
                        String[] redacteurTokens = StringUtils.getTechnicalTokens(value, this.parameters.getItemListSeparateur(), false);
                        this.parseRedacteurs(redacteurTokens);
                        break block0;
                    }
                }
            }
        }
    }

    public void parseSubfield(CorpusField corpusField, SubfieldKey subfieldKey, String value) {
        if (SubfieldKey.isLegalSubfield(corpusField, subfieldKey.getSubtype())) {
            SubfieldBuffer fieldBuffer = this.subfieldBufferMap.get(corpusField.getFieldKey());
            if (fieldBuffer == null) {
                fieldBuffer = new SubfieldBuffer(corpusField);
                this.subfieldBufferMap.put(corpusField.getFieldKey(), fieldBuffer);
            }
            fieldBuffer.putSubfield(subfieldKey, value);
        }
    }

    public void parseFicheLang(String s) {
        if (s == null) {
            return;
        }
        Langue langue = this.parseLangue(s);
        if (langue != null) {
            this.ficheChangeBuilder.setLang(langue.getLang());
        } else {
            this.ficheChangeBuilder.setLang(null);
        }
    }

    public void parseTitre(String s) {
        this.ficheChangeBuilder.setTitre(CleanedString.newInstance(TypoParser.parseTypo(s, this.typoOptions)));
    }

    public void parseSoustitre(String s) {
        CleanedString cs = CleanedString.newInstance(s);
        if (cs != null) {
            this.ficheChangeBuilder.setSoustitre(this.parsePara(cs.toString()));
        } else {
            this.ficheChangeBuilder.setSoustitre(null);
        }
    }

    public void parseRedacteurs(String[] tokens) {
        FicheItems ficheItems = this.parseRedacteurItemList(tokens, this.defaultSphereKey);
        this.ficheChangeBuilder.putRedacteurs(ficheItems);
    }

    public void parsePropriete(CorpusField proprieteField, String s) {
        s = StringUtils.cleanString(s);
        FicheItem ficheItem = null;
        if (s.length() > 0) {
            ficheItem = this.parseFicheItem(s, proprieteField);
        }
        this.ficheChangeBuilder.setPropriete(proprieteField.getFieldKey(), ficheItem);
    }

    public void parsePersonnePropriete(CorpusField proprieteField, String surname, String forename, String nonlatin, String surnameFirstString) {
        surname = StringUtils.cleanString(surname);
        forename = StringUtils.cleanString(forename);
        nonlatin = StringUtils.cleanString(nonlatin);
        boolean surnameFirst = StringUtils.isTrue(surnameFirstString);
        FicheItem redacteurItem = this.parseRedacteurItem(surname, forename, nonlatin, surnameFirst);
        this.ficheChangeBuilder.setPropriete(proprieteField.getFieldKey(), redacteurItem);
    }

    public void parseMontantPropriete(CorpusField proprieteField, String value, String cur) {
        Serializable ficheItem = null;
        boolean itemAllowed = true;
        if ((value = StringUtils.cleanString(value)).length() > 0) {
            ficheItem = this.parseMontant(value);
            if (ficheItem == null) {
                if ((cur = StringUtils.cleanString(cur)).length() == 0) {
                    Currencies currencies = proprieteField.getCurrencies();
                    cur = ((ExtendedCurrency)currencies.get(0)).getCurrencyCode();
                }
                ficheItem = this.parseMontant(value, cur);
            }
            if (ficheItem == null) {
                if (itemAllowed && !value.startsWith("?")) {
                    value = "?" + value;
                }
                ficheItem = this.parseItem(value, itemAllowed);
            }
        }
        this.ficheChangeBuilder.setPropriete(proprieteField.getFieldKey(), (FicheItem)((Object)ficheItem));
    }

    public void parseImagePropriete(CorpusField proprieteField, String src, String alt, String title) {
        Image image = null;
        if ((src = StringUtils.cleanString(src)).length() > 0) {
            alt = StringUtils.cleanString(alt);
            title = StringUtils.cleanString(title);
            image = new Image(src, alt, title);
        }
        this.ficheChangeBuilder.setPropriete(proprieteField.getFieldKey(), image);
    }

    public void parseGeopointPropriete(CorpusField proprieteField, String latitude, String longitude) {
        latitude = StringUtils.cleanString(latitude);
        longitude = StringUtils.cleanString(longitude);
        DegreDecimal latitudeDecimal = this.parseDegreDecimal(latitude);
        DegreDecimal longitudeDecimal = this.parseDegreDecimal(longitude);
        Serializable ficheItem = null;
        boolean itemAllowed = true;
        if (latitudeDecimal != null && longitudeDecimal != null) {
            ficheItem = new Geopoint(latitudeDecimal, longitudeDecimal);
        } else if (latitude.length() > 0 || longitude.length() > 0) {
            if (itemAllowed && !latitude.startsWith("?? ")) {
                latitude = "?? " + latitude;
            }
            ficheItem = this.parseItem(latitude + " ?? " + longitude, itemAllowed);
        }
        this.ficheChangeBuilder.setPropriete(proprieteField.getFieldKey(), (FicheItem)((Object)ficheItem));
    }

    public void parseInformation(CorpusField informationField, String[] tokens) {
        ArrayList<FicheItem> ficheItemCollection = new ArrayList<FicheItem>();
        for (String token : tokens) {
            FicheItem ficheItem = this.parseFicheItem(token, informationField);
            if (ficheItem == null) continue;
            ficheItemCollection.add(ficheItem);
        }
        this.addInInformation(informationField, FicheUtils.toFicheItems(ficheItemCollection));
    }

    public void addInInformation(CorpusField informationField, FicheItems ficheItems) {
        this.ficheChangeBuilder.putInformation(informationField.getFieldKey(), ficheItems);
    }

    public void parseSection(CorpusField sectionField, String s) {
        ArrayList<FicheBlock> list = new ArrayList<FicheBlock>();
        this.ficheBlockParser.parseFicheBlockList(s, list);
        FicheBlocks ficheBlocks = FicheUtils.toFicheBlocks(list);
        this.ficheChangeBuilder.putSection(sectionField.getFieldKey(), ficheBlocks);
    }

    public FicheItem parseFicheItem(String token, CorpusField corpusField) {
        short ficheItemType = corpusField.getFicheItemType();
        boolean itemAllowed = true;
        if (ficheItemType == 3) {
            Langue langue = this.parseLangue(token);
            if (langue != null) {
                return langue;
            }
            return this.parseItem(token, itemAllowed);
        }
        if (ficheItemType == 4) {
            Pays pays = this.parsePays(token);
            if (pays != null) {
                return pays;
            }
            return this.parseItem(token, itemAllowed);
        }
        if (ficheItemType == 5) {
            try {
                FuzzyDate date = FuzzyDate.parse(token, this.dateFormatBundle);
                return new Datation(date);
            }
            catch (ParseException pe) {
                return this.parseItem(token, itemAllowed);
            }
        }
        if (ficheItemType == 7) {
            Link link = this.parseLink(token);
            if (link != null) {
                return link;
            }
            return this.parseItem(token, itemAllowed);
        }
        if (ficheItemType == 8) {
            try {
                Decimal decimal = StringUtils.parseDecimal(token);
                return new Nombre(decimal);
            }
            catch (NumberFormatException nfe) {
                if (itemAllowed && !token.startsWith("?")) {
                    token = "?" + token;
                }
                return this.parseItem(token, itemAllowed);
            }
        }
        if (ficheItemType == 9) {
            Montant montant = this.parseMontant(token);
            if (montant != null) {
                return montant;
            }
            if (itemAllowed && !token.startsWith("?")) {
                token = "?" + token;
            }
            return this.parseItem(token, itemAllowed);
        }
        if (ficheItemType == 6) {
            try {
                EmailCore emailCore = EmailCoreUtils.parse(token);
                return new Courriel(emailCore);
            }
            catch (ParseException pe) {
                return this.parseItem(token, itemAllowed);
            }
        }
        if (ficheItemType == 2) {
            return this.parseRedacteurItem(token, this.getDefaultSphereKey(corpusField));
        }
        if (ficheItemType == 1) {
            return new Item(TypoParser.parseTypo(token, this.typoOptions));
        }
        if (ficheItemType == 10) {
            Geopoint geopoint = this.parseGeopoint(token);
            if (geopoint != null) {
                return geopoint;
            }
            return this.parseItem(token, itemAllowed);
        }
        if (ficheItemType == 11) {
            return this.parsePara(token);
        }
        if (ficheItemType == 12) {
            Image image = this.parseImage(token);
            if (image != null) {
                return image;
            }
            return this.parseItem(token, itemAllowed);
        }
        return null;
    }

    private Para parsePara(String token) {
        Para.Builder paraBuilder = new Para.Builder();
        this.textContentParser.parse(paraBuilder, token);
        return paraBuilder.toPara();
    }

    private FicheItems parseRedacteurItemList(String[] tokens, SubsetKey defaultSphereKey) {
        ArrayList<FicheItem> list = new ArrayList<FicheItem>();
        for (String token : tokens) {
            FicheItem redacteurItem = this.parseRedacteurItem(token, defaultSphereKey);
            if (redacteurItem == null) continue;
            list.add(redacteurItem);
        }
        return FicheUtils.toFicheItems(list);
    }

    private FicheItem parseRedacteurItem(String token, SubsetKey defaultSphereKey) {
        try {
            Redacteur redacteur = SphereUtils.parse(this.fichotheque, token, defaultSphereKey);
            return new Personne(redacteur.getGlobalId());
        }
        catch (SphereUtils.RedacteurLoginException rle) {
            Personne personne = FicheParser.parsePersonne(token, this.typoOptions);
            if (personne != null) {
                return personne;
            }
            return new Item(TypoParser.parseTypo(token, this.typoOptions));
        }
    }

    private FicheItem parseRedacteurItem(String surname, String forename, String nonlatin, boolean surnameFirst) {
        block4: {
            if (forename.length() == 0 && nonlatin.length() == 0) {
                try {
                    Redacteur redacteur = SphereUtils.parse(this.fichotheque, surname);
                    return new Personne(redacteur.getGlobalId());
                }
                catch (SphereUtils.RedacteurLoginException redacteurLoginException) {
                    if (surname.length() == 0) {
                        return null;
                    }
                    if (surnameFirst) break block4;
                    return new Item(TypoParser.parseTypo(surname, this.typoOptions));
                }
            }
        }
        surname = TypoParser.parseTypo(surname, this.typoOptions);
        forename = TypoParser.parseTypo(forename, this.typoOptions);
        nonlatin = TypoParser.parseTypo(nonlatin, this.typoOptions);
        return new Personne(PersonCoreUtils.toPersonCore(surname, forename, nonlatin, surnameFirst), null);
    }

    public FicheItem parseMontantInformationSubfield(CorpusField corpusField, ExtendedCurrency currency, String value) {
        value = StringUtils.cleanString(value);
        boolean itemAllowed = true;
        if (value.isEmpty()) {
            return null;
        }
        try {
            Decimal decimal = StringUtils.parseDecimal(value);
            return new Montant(decimal, currency);
        }
        catch (NumberFormatException nfe) {
            if (itemAllowed && !value.startsWith("?")) {
                value = "?" + value;
            }
            return this.parseItem(value, itemAllowed);
        }
    }

    private Item parseItem(String token, boolean itemAllowed) {
        if (itemAllowed) {
            return new Item(TypoParser.parseTypo(token, this.typoOptions));
        }
        return null;
    }

    public Link parseLink(String s) {
        String href;
        int separateurinterne = 42;
        int posseparateur = s.indexOf(separateurinterne);
        if (posseparateur == -1) {
            separateurinterne = 124;
            posseparateur = s.indexOf(separateurinterne);
        }
        if ((href = posseparateur == -1 ? s : s.substring(0, posseparateur).trim()).startsWith("www.")) {
            href = "http://" + href;
        }
        try {
            URI uri = new URI(href);
            if (uri.isAbsolute()) {
                URL url = uri.toURL();
                href = url.toString();
            } else {
                href = uri.toString();
            }
            String title = "";
            String comment = "";
            if (posseparateur > -1) {
                String bout = s.substring(posseparateur + 1).trim();
                int pos2 = bout.indexOf(separateurinterne);
                if (pos2 > -1) {
                    title = bout.substring(0, pos2).trim();
                    comment = bout.substring(pos2 + 1).trim();
                } else {
                    title = bout;
                }
            }
            return new Link(href, TypoParser.parseTypo(title, this.typoOptions), TypoParser.parseTypo(comment, this.typoOptions));
        }
        catch (MalformedURLException | URISyntaxException e) {
            return null;
        }
    }

    public Image parseImage(String s) {
        String src;
        int separateurinterne = 42;
        int posseparateur = s.indexOf(separateurinterne);
        String alt = "";
        String title = "";
        if (posseparateur == -1) {
            src = s;
        } else {
            src = s.substring(0, posseparateur).trim();
            int pos2 = s.indexOf(separateurinterne, posseparateur + 1);
            if (pos2 == -1) {
                alt = s.substring(posseparateur + 1).trim();
            } else {
                alt = s.substring(posseparateur + 1, pos2).trim();
                title = s.substring(pos2 + 1).trim();
            }
        }
        return new Image(src, TypoParser.parseTypo(alt, this.typoOptions), TypoParser.parseTypo(title, this.typoOptions));
    }

    private Geopoint parseGeopoint(String s) {
        DegreDecimal latitude = null;
        DegreDecimal longitude = null;
        int idxAster = s.indexOf(42);
        if (idxAster != -1) {
            latitude = this.parseDegreDecimal(s.substring(0, idxAster));
            longitude = this.parseDegreDecimal(s.substring(idxAster + 1));
        }
        if (latitude != null && longitude != null) {
            return new Geopoint(latitude, longitude);
        }
        return null;
    }

    private DegreDecimal parseDegreDecimal(String s) {
        try {
            Decimal decimal = StringUtils.parseDecimal(s);
            return DegreDecimal.newInstance(decimal);
        }
        catch (NumberFormatException nfe) {
            try {
                DegreSexagesimal ds = DegreSexagesimal.parse(s);
                return DegreDecimal.newInstance(ds);
            }
            catch (ParseException pe) {
                return null;
            }
        }
    }

    private Montant parseMontant(String s) {
        String[] result = MoneyUtils.splitMoney(s);
        if (result == null) {
            return null;
        }
        return this.parseMontant(result[0], result[1]);
    }

    private Montant parseMontant(String valString, String curString) {
        try {
            Decimal decimal = StringUtils.parseDecimal(valString);
            ExtendedCurrency currency = ExtendedCurrency.parse(curString);
            return new Montant(decimal, currency);
        }
        catch (NumberFormatException | ParseException e) {
            return null;
        }
    }

    private Langue parseLangue(String valString) {
        try {
            Lang lang = Lang.parse(valString);
            return new Langue(lang);
        }
        catch (ParseException mcle) {
            TextTest textTest = ConditionsUtils.parseTextTest(valString);
            if (textTest != null) {
                Iterator<String> iterator;
                TextCondition condition = TextConditionBuilder.build(textTest);
                Set<String> result = this.parameters.getCodeCatalog().getLangCodeSet(condition, this.parameters.getUserLangContext().getLangPreference());
                if (!result.isEmpty() && (iterator = result.iterator()).hasNext()) {
                    String code = iterator.next();
                    return new Langue(Lang.build(code));
                }
            }
            return null;
        }
    }

    private Pays parsePays(String valString) {
        try {
            Country country = Country.parse(valString);
            return new Pays(country);
        }
        catch (ParseException pe) {
            TextTest textTest = ConditionsUtils.parseTextTest(valString);
            if (textTest != null) {
                Iterator<String> iterator;
                TextCondition condition = TextConditionBuilder.build(textTest);
                Set<String> result = this.parameters.getCodeCatalog().getCountryCodeSet(condition, this.parameters.getUserLangContext().getLangPreference());
                if (!result.isEmpty() && (iterator = result.iterator()).hasNext()) {
                    String code = iterator.next();
                    return new Pays(Country.build(code));
                }
            }
            return null;
        }
    }

    private SubsetKey getDefaultSphereKey(CorpusField corpusField) {
        SubsetKey customSphereKey = corpusField.getDefaultSphereKey();
        if (customSphereKey == null) {
            customSphereKey = this.defaultSphereKey;
        }
        return customSphereKey;
    }

    private String cleanProprieteToken(String s, char itemListSeparateur) {
        char carac;
        int length;
        int p = length = s.length();
        for (int i = length - 1; i >= 0 && ((carac = s.charAt(i)) == itemListSeparateur || Character.isWhitespace(carac)); --i) {
            --p;
        }
        if (p == 0) {
            return "";
        }
        if (p == length) {
            return s;
        }
        return s.substring(0, p);
    }

    public static Personne parsePersonne(String s, TypoOptions typoOptions) {
        int separateurinterne = 42;
        int posvirg = s.indexOf(separateurinterne);
        if (posvirg == -1) {
            separateurinterne = 124;
            posvirg = s.indexOf(separateurinterne);
        }
        if (posvirg > -1) {
            String surname = TypoParser.parseTypo(s, 0, posvirg, typoOptions);
            String forename = "";
            String organism = null;
            if (posvirg < s.length() - 1) {
                String suite = s.substring(posvirg + 1).trim();
                int pos2 = suite.indexOf(separateurinterne);
                if (pos2 > -1) {
                    forename = suite.substring(0, pos2);
                    if (pos2 < suite.length() - 1) {
                        organism = suite.substring(pos2 + 1);
                    }
                } else {
                    forename = suite;
                }
            }
            boolean surnameFirst = false;
            if (forename.length() > 0 && forename.charAt(0) == '%') {
                forename = forename.substring(1);
                surnameFirst = true;
            }
            forename = TypoParser.parseTypo(forename, typoOptions);
            PersonCore personCore = PersonCoreUtils.toPersonCore(surname, forename, "", surnameFirst);
            return new Personne(personCore, TypoParser.parseTypo(organism, typoOptions));
        }
        return null;
    }

    public static class Parameters {
        private final UserLangContext userLangContext;
        private final CodeCatalog codeCatalog;
        private final HtmlCleaner htmlCleaner;
        private final TypoOptions typoOptions;
        private char itemListSeparateur = (char)59;
        private Redacteur userRedacteur = null;

        public Parameters(UserLangContext userLangContext, CodeCatalog codeCatalog, HtmlCleaner htmlCleaner, TypoOptions typoOptions) {
            this.userLangContext = userLangContext;
            this.codeCatalog = codeCatalog;
            this.htmlCleaner = htmlCleaner;
            this.typoOptions = typoOptions;
        }

        public Lang getWorkingLang() {
            return this.userLangContext.getWorkingLang();
        }

        public UserLangContext getUserLangContext() {
            return this.userLangContext;
        }

        public CodeCatalog getCodeCatalog() {
            return this.codeCatalog;
        }

        public HtmlCleaner getHtmlCleaner() {
            return this.htmlCleaner;
        }

        public TypoOptions getTypoOptions() {
            return this.typoOptions;
        }

        public char getItemListSeparateur() {
            return this.itemListSeparateur;
        }

        public void setItemListSeparateur(char itemListSeparateur) {
            this.itemListSeparateur = itemListSeparateur;
        }

        public Redacteur getUserRedacteur() {
            return this.userRedacteur;
        }

        public void setUserRedacteur(Redacteur userRedacteur) {
            this.userRedacteur = userRedacteur;
        }
    }

    private class SubfieldBuffer {
        private final CorpusField corpusField;
        private final Map<SubfieldKey, String> subfieldMap = new LinkedHashMap<SubfieldKey, String>();

        private SubfieldBuffer(CorpusField corpusField) {
            this.corpusField = corpusField;
        }

        private void putSubfield(SubfieldKey subfieldKey, String value) {
            this.subfieldMap.put(subfieldKey, value);
        }

        private void flush() {
            switch (this.corpusField.getFicheItemType()) {
                case 9: {
                    if (this.corpusField.isPropriete()) {
                        this.flushMontantPropriete();
                        break;
                    }
                    this.flushMontantInformation();
                    break;
                }
                case 2: {
                    this.flushPersonne();
                    break;
                }
                case 10: {
                    this.flushGeopoint();
                    break;
                }
                case 12: {
                    this.flushImage();
                }
            }
        }

        private void flushMontantPropriete() {
            String num = "";
            String cur = "";
            for (Map.Entry<SubfieldKey, String> entry : this.subfieldMap.entrySet()) {
                String value = entry.getValue();
                short type = entry.getKey().getSubtype();
                switch (type) {
                    case 12: {
                        cur = value;
                        break;
                    }
                    case 11: {
                        num = value;
                    }
                }
            }
            FicheParser.this.parseMontantPropriete(this.corpusField, num, cur);
        }

        private void flushMontantInformation() {
            HashSet<ExtendedCurrency> currencySet = new HashSet<ExtendedCurrency>();
            ArrayList<FicheItem> ficheItemCollection = new ArrayList<FicheItem>();
            String othersValue = null;
            block4: for (Map.Entry<SubfieldKey, String> entry : this.subfieldMap.entrySet()) {
                String value = entry.getValue();
                SubfieldKey subfieldKey = entry.getKey();
                short type = entry.getKey().getSubtype();
                switch (type) {
                    case 111: {
                        FicheItem ficheItem = FicheParser.this.parseMontantInformationSubfield(this.corpusField, subfieldKey.getCurrency(), value);
                        if (ficheItem == null) break;
                        if (ficheItem instanceof Montant) {
                            Montant montant = (Montant)ficheItem;
                            if (currencySet.contains(montant.getCurrency())) continue block4;
                            ficheItemCollection.add(montant);
                            currencySet.add(montant.getCurrency());
                            break;
                        }
                        ficheItemCollection.add(ficheItem);
                        break;
                    }
                    case 99: {
                        othersValue = value;
                    }
                }
            }
            if (othersValue != null) {
                String[] tokens = StringUtils.getTechnicalTokens(othersValue, FicheParser.this.parameters.getItemListSeparateur(), false);
                int length = tokens.length;
                for (int i = 0; i < length; ++i) {
                    FicheItem ficheItem = FicheParser.this.parseFicheItem(tokens[i], this.corpusField);
                    if (ficheItem == null) continue;
                    if (ficheItem instanceof Montant) {
                        Montant montant = (Montant)ficheItem;
                        if (currencySet.contains(montant.getCurrency())) continue;
                        ficheItemCollection.add(montant);
                        currencySet.add(montant.getCurrency());
                        continue;
                    }
                    ficheItemCollection.add(ficheItem);
                }
            }
            FicheParser.this.addInInformation(this.corpusField, FicheUtils.toFicheItems(ficheItemCollection));
        }

        private void flushGeopoint() {
            String latitude = "";
            String longitude = "";
            for (Map.Entry<SubfieldKey, String> entry : this.subfieldMap.entrySet()) {
                String value = entry.getValue();
                short type = entry.getKey().getSubtype();
                switch (type) {
                    case 21: {
                        latitude = value;
                        break;
                    }
                    case 22: {
                        longitude = value;
                    }
                }
            }
            FicheParser.this.parseGeopointPropriete(this.corpusField, latitude, longitude);
        }

        private void flushPersonne() {
            String surname = "";
            String forename = "";
            String nonlatin = "";
            String surnameFirstString = "";
            for (Map.Entry<SubfieldKey, String> entry : this.subfieldMap.entrySet()) {
                String value = entry.getValue();
                short type = entry.getKey().getSubtype();
                switch (type) {
                    case 1: {
                        surname = value;
                        break;
                    }
                    case 2: {
                        forename = value;
                        break;
                    }
                    case 4: {
                        nonlatin = value;
                        break;
                    }
                    case 3: {
                        surnameFirstString = value;
                    }
                }
            }
            FicheParser.this.parsePersonnePropriete(this.corpusField, surname, forename, nonlatin, surnameFirstString);
        }

        private void flushImage() {
            String src = "";
            String alt = "";
            String title = "";
            for (Map.Entry<SubfieldKey, String> entry : this.subfieldMap.entrySet()) {
                String value = entry.getValue();
                short type = entry.getKey().getSubtype();
                switch (type) {
                    case 31: {
                        src = value;
                        break;
                    }
                    case 32: {
                        alt = value;
                        break;
                    }
                    case 33: {
                        title = value;
                    }
                }
            }
            FicheParser.this.parseImagePropriete(this.corpusField, src, alt, title);
        }
    }
}

