/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.corpus.fiche.AttConsumer;
import net.fichotheque.corpus.fiche.Atts;

public class AttsParser {
    private static final short WAITING_FOR_NAME = 1;
    private static final short ON_NAME = 2;
    private static final short WAITING_FOR_VALUE = 3;
    private static final short ON_VALUE = 4;
    private static final short ON_QUOTE = 5;
    private final String source;
    private final int startIndex;
    private final List<String> nameList = new ArrayList<String>();
    private final List<String> valueList = new ArrayList<String>();
    private final char[] nameBuffer;
    private final char[] valueBuffer;
    private short state = 1;
    private int namePointer = 0;
    private int valuePointer = 0;
    private boolean withDataPrefix = false;
    private String currentName;
    private boolean escaped;
    private int closeIndex;
    private int currentIndex;
    private int automaticCount = 0;

    public AttsParser(String source, int startIndex) {
        this.source = source;
        this.startIndex = startIndex;
        this.nameBuffer = new char[source.length() - startIndex];
        this.valueBuffer = new char[source.length() - startIndex];
    }

    public void addAtt(String name, String value) {
        this.nameList.add(name);
        this.valueList.add(value);
        ++this.automaticCount;
    }

    public void run() throws ParseException {
        int length = this.source.length();
        boolean continueParsing = true;
        for (int i = this.startIndex; i < length; ++i) {
            this.currentIndex = i;
            char carac = this.source.charAt(i);
            continueParsing = this.checkChar(carac);
            if (continueParsing) continue;
            this.closeIndex = i;
            break;
        }
        if (continueParsing) {
            throw new ParseException("Missing closing )", this.currentIndex);
        }
    }

    public int getCloseIndex() {
        return this.closeIndex;
    }

    public Atts getAtts() {
        boolean onlyAutomatic = false;
        int size = this.nameList.size();
        if (size > 0 && size == this.automaticCount) {
            onlyAutomatic = true;
        }
        return new InternalAtts(this.nameList, this.valueList, onlyAutomatic);
    }

    private boolean checkChar(char carac) throws ParseException {
        boolean continueParsing = true;
        switch (this.state) {
            case 1: {
                continueParsing = this.checkWaitingForName(carac);
                break;
            }
            case 2: {
                continueParsing = this.checkOnName(carac);
                break;
            }
            case 3: {
                continueParsing = this.checkWaitingForValue(carac);
                break;
            }
            case 4: {
                continueParsing = this.checkOnValue(carac);
                break;
            }
            case 5: {
                continueParsing = this.checkOnQuote(carac);
            }
        }
        return continueParsing;
    }

    private boolean checkWaitingForName(char carac) throws ParseException {
        switch (carac) {
            case ')': {
                return false;
            }
            case ' ': {
                return true;
            }
        }
        if (AttsParser.isValideFisrtNameChar(carac)) {
            this.withDataPrefix = carac == '-';
            this.bufName(carac);
            this.state = (short)2;
            return true;
        }
        throw new ParseException("Invalid name first character: " + carac, this.currentIndex);
    }

    private boolean checkOnName(char carac) throws ParseException {
        if (carac == '=') {
            this.initName();
            this.state = (short)3;
            return true;
        }
        if (AttsParser.isValidNameChar(carac)) {
            this.bufName(carac);
            return true;
        }
        throw new ParseException("Invalid name character: " + carac, this.currentIndex);
    }

    private boolean checkWaitingForValue(char carac) throws ParseException {
        switch (carac) {
            case ')': {
                this.addAtt();
                return false;
            }
            case '\"': {
                this.state = (short)5;
                return true;
            }
            case ' ': {
                this.addAtt();
                this.state = 1;
                return true;
            }
        }
        this.bufValue(carac);
        this.state = (short)4;
        return true;
    }

    private boolean checkOnValue(char carac) throws ParseException {
        switch (carac) {
            case ')': {
                this.addAtt();
                return false;
            }
            case '\"': {
                throw new ParseException("\" character inside value", this.currentIndex);
            }
            case ' ': {
                this.addAtt();
                this.state = 1;
                return true;
            }
        }
        this.bufValue(carac);
        return true;
    }

    private boolean checkOnQuote(char carac) {
        switch (carac) {
            case '\"': {
                if (this.escaped) {
                    this.escaped = false;
                    this.bufValue('\"');
                } else {
                    this.addAtt();
                    this.state = 1;
                }
                return true;
            }
            case '\\': {
                if (this.escaped) {
                    this.escaped = false;
                    this.bufValue('\\');
                } else {
                    this.escaped = true;
                }
                return true;
            }
        }
        if (this.escaped) {
            this.escaped = false;
            this.bufValue('\\');
        }
        this.bufValue(carac);
        return true;
    }

    private void bufName(char carac) {
        this.nameBuffer[this.namePointer] = carac;
        ++this.namePointer;
    }

    private void bufValue(char carac) {
        this.valueBuffer[this.valuePointer] = carac;
        ++this.valuePointer;
    }

    private void initName() {
        this.currentName = new String(this.nameBuffer, 0, this.namePointer);
        if (this.withDataPrefix) {
            this.currentName = "data" + this.currentName;
        }
        this.namePointer = 0;
        this.withDataPrefix = false;
    }

    private void addAtt() {
        String attValue = new String(this.valueBuffer, 0, this.valuePointer);
        this.valuePointer = 0;
        switch (this.currentName) {
            case "c": {
                this.nameList.add("class");
                this.valueList.add(attValue);
                break;
            }
            case "cm": 
            case "fbe": {
                this.addClassAtt(attValue, this.currentName);
                break;
            }
            default: {
                this.nameList.add(this.currentName);
                this.valueList.add(attValue);
            }
        }
    }

    private void addClassAtt(String attValue, String prefix) {
        if (!attValue.isEmpty()) {
            this.nameList.add("class");
            this.valueList.add(prefix + "-" + attValue);
        }
    }

    public static boolean isValideFisrtNameChar(char carac) {
        if (carac >= 'a' && carac <= 'z') {
            return true;
        }
        if (carac >= 'A' && carac <= 'Z') {
            return true;
        }
        switch (carac) {
            case '-': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidNameChar(char carac) {
        if (carac >= 'a' && carac <= 'z') {
            return true;
        }
        if (carac >= 'A' && carac <= 'Z') {
            return true;
        }
        if (carac >= '0' && carac <= '9') {
            return true;
        }
        switch (carac) {
            case '-': 
            case '.': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    public static void populate(AttConsumer attConsumer, List<Atts> attsList) {
        if (attsList != null) {
            Atts atts = attsList.get(0);
            int attLength = atts.size();
            for (int i = 0; i < attLength; ++i) {
                attConsumer.putAtt(atts.getName(i), atts.getValue(i));
            }
        }
    }

    public static void populate(AttConsumer attConsumer, List<Atts> attsList, int index) {
        if (attsList != null && index < attsList.size()) {
            Atts atts = attsList.get(index);
            int attLength = atts.size();
            for (int i = 0; i < attLength; ++i) {
                attConsumer.putAtt(atts.getName(i), atts.getValue(i));
            }
        }
    }

    private static class InternalAtts
    implements Atts {
        private final List<String> nameList;
        private final List<String> valueList;
        private final boolean onlyAutomatic;

        private InternalAtts(List<String> nameList, List<String> valueList, boolean onlyAutomatic) {
            this.nameList = nameList;
            this.valueList = valueList;
            this.onlyAutomatic = onlyAutomatic;
        }

        @Override
        public int size() {
            return this.nameList.size();
        }

        @Override
        public String getName(int index) {
            return this.nameList.get(index);
        }

        @Override
        public String getValue(int index) {
            return this.valueList.get(index);
        }

        @Override
        public boolean hasOnlyAutomaticAtts() {
            return this.onlyAutomatic;
        }
    }
}

