/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.parsers;

import java.text.ParseException;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.metadata.ThesaurusFieldKey;
import net.fichotheque.tools.importation.ParseResultBuilder;
import net.fichotheque.tools.importation.parsers.Row;
import net.fichotheque.tools.importation.parsers.ThesaurusRowParser;
import net.fichotheque.tools.importation.thesaurus.MergeThesaurusImportBuilder;

class ThesaurusMergeRowParser
extends ThesaurusRowParser {
    private final int originIndex;
    private final boolean isOriginIdalpha;
    private final int destinationIndex;
    private final boolean isDestinationIdalpha;
    private final MergeThesaurusImportBuilder mergeThesaurusImportBuilder;
    private final ParseResultBuilder parseResultBuilder;

    private ThesaurusMergeRowParser(MergeThesaurusImportBuilder mergeThesaurusImportBuilder, ParseResultBuilder parseResultBuilder, int originIndex, boolean isOriginIdalpha, int destinationIndex, boolean isDestinationIdalpha) {
        this.mergeThesaurusImportBuilder = mergeThesaurusImportBuilder;
        this.parseResultBuilder = parseResultBuilder;
        this.originIndex = originIndex;
        this.isOriginIdalpha = isOriginIdalpha;
        this.destinationIndex = destinationIndex;
        this.isDestinationIdalpha = isDestinationIdalpha;
    }

    @Override
    public MergeThesaurusImportBuilder getThesaurusImportBuilder() {
        return this.mergeThesaurusImportBuilder;
    }

    @Override
    public void parseRow(int rowNumber, Row row) {
        Motcle motcle = this.getMotcle(this.mergeThesaurusImportBuilder.getThesaurus(), this.originIndex, this.isOriginIdalpha, rowNumber, row);
        Motcle destinationMotcle = this.getMotcle(this.mergeThesaurusImportBuilder.getDestinationThesaurus(), this.destinationIndex, this.isDestinationIdalpha, rowNumber, row);
        if (motcle != null && destinationMotcle != null) {
            this.mergeThesaurusImportBuilder.add(motcle, destinationMotcle);
        }
    }

    private Motcle getMotcle(Thesaurus thesaurus, int index, boolean isIdalpha, int lineNumber, Row row) {
        if (row.getColumnCount() <= index) {
            this.parseResultBuilder.addParseError("MISSING ID COLUMN", lineNumber);
            return null;
        }
        String idString = row.getColumnValue(index).trim();
        Motcle motcle = null;
        if (isIdalpha) {
            motcle = thesaurus.getMotcleByIdalpha(idString);
            if (motcle == null) {
                this.parseResultBuilder.addBdfError("UNKNOWN IDALPHA", idString, lineNumber);
            }
        } else {
            try {
                int id = Integer.parseInt(idString);
                motcle = thesaurus.getMotcleById(id);
                if (motcle == null) {
                    this.parseResultBuilder.addBdfError("UNKNOWN ID", idString, lineNumber);
                }
            }
            catch (NumberFormatException nfe) {
                this.parseResultBuilder.addBdfError("NOT INTEGER", idString, lineNumber);
            }
        }
        return motcle;
    }

    static ThesaurusMergeRowParser newInstance(String[] fieldArray, MergeThesaurusImportBuilder mergeThesaurusImportBuilder, ParseResultBuilder parseResultBuilder) {
        int originIndex = -1;
        int idalphaOriginIndex = -1;
        int destinationIndex = -1;
        int destinationIdalphaIndex = -1;
        int length = fieldArray.length;
        for (int i = 0; i < length; ++i) {
            ThesaurusFieldKey thesaurusFieldKey;
            String field = fieldArray[i].trim();
            if (field.equals("destination_id") || field.equals("destination_idths")) {
                if (destinationIndex == -1) continue;
                destinationIndex = i;
                continue;
            }
            if (field.equals("destination_idalpha")) {
                if (destinationIdalphaIndex == -1) continue;
                destinationIdalphaIndex = i;
                continue;
            }
            try {
                thesaurusFieldKey = ThesaurusFieldKey.parse(field);
            }
            catch (ParseException pe) {
                continue;
            }
            if (thesaurusFieldKey.equals(ThesaurusFieldKey.ID)) {
                if (originIndex != -1) continue;
                originIndex = i;
                continue;
            }
            if (!thesaurusFieldKey.equals(ThesaurusFieldKey.IDALPHA) || idalphaOriginIndex != -1) continue;
            idalphaOriginIndex = i;
        }
        boolean isOriginIdalpha = false;
        boolean isDestinationIdalpha = false;
        if (originIndex == -1) {
            if (mergeThesaurusImportBuilder.getThesaurus().isIdalphaType()) {
                if (idalphaOriginIndex != -1) {
                    originIndex = idalphaOriginIndex;
                    isOriginIdalpha = true;
                } else {
                    parseResultBuilder.addInitError("MISSING FIELDS INIT", "(" + ThesaurusFieldKey.ID.toString() + " || " + ThesaurusFieldKey.IDALPHA.toString() + ")");
                }
            } else {
                parseResultBuilder.addInitError("MISSING FIELDS INIT", ThesaurusFieldKey.ID.toString());
            }
        }
        if (destinationIndex == -1) {
            if (mergeThesaurusImportBuilder.getDestinationThesaurus().isIdalphaType()) {
                if (idalphaOriginIndex != -1) {
                    destinationIndex = destinationIdalphaIndex;
                    isDestinationIdalpha = true;
                } else {
                    parseResultBuilder.addInitError("MISSING FIELDS INIT", "(destination_id || destination_idalpha)");
                }
            } else {
                parseResultBuilder.addInitError("MISSING FIELDS INIT", "destination_id");
            }
        }
        if (originIndex != -1 && destinationIndex != -1) {
            return new ThesaurusMergeRowParser(mergeThesaurusImportBuilder, parseResultBuilder, originIndex, isOriginIdalpha, destinationIndex, isDestinationIdalpha);
        }
        return null;
    }
}

