/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.parsers;

import net.fichotheque.corpus.Corpus;
import net.fichotheque.thesaurus.metadata.ThesaurusLangChecker;
import net.fichotheque.thesaurus.policies.PolicyProvider;
import net.fichotheque.tools.importation.ParseResultBuilder;
import net.fichotheque.tools.importation.corpus.CorpusImportBuilder;
import net.fichotheque.tools.importation.corpus.EditCorpusImportBuilder;
import net.fichotheque.tools.importation.corpus.RemoveCorpusImportBuilder;
import net.fichotheque.tools.importation.parsers.CorpusChangeRowParser;
import net.fichotheque.tools.importation.parsers.CorpusCreationRowParser;
import net.fichotheque.tools.importation.parsers.CorpusRemoveRowParser;
import net.fichotheque.tools.importation.parsers.Row;
import net.fichotheque.tools.parsers.FicheParser;
import net.mapeadores.util.exceptions.SwitchException;

public abstract class CorpusRowParser {
    public static final String CREATION_TYPE = "creation";
    public static final String CHANGE_TYPE = "change";
    public static final String REMOVE_TYPE = "remove";

    public abstract void parseRow(int var1, Row var2);

    public abstract CorpusImportBuilder getCorpusImportBuilder();

    public static CorpusRowParser newInstance(String[] fieldArray, String parseType, Corpus corpus, ParseResultBuilder parseResultBuilder, FicheParser.Parameters ficheParserParameters, PolicyProvider policyProvider, ThesaurusLangChecker thesaurusLangChecker) {
        switch (parseType) {
            case "creation": {
                return CorpusCreationRowParser.newInstance(fieldArray, new EditCorpusImportBuilder(corpus), parseResultBuilder, ficheParserParameters, policyProvider, thesaurusLangChecker);
            }
            case "change": {
                return CorpusChangeRowParser.newInstance(fieldArray, new EditCorpusImportBuilder(corpus), parseResultBuilder, ficheParserParameters, policyProvider, thesaurusLangChecker);
            }
            case "remove": {
                return CorpusRemoveRowParser.newInstance(fieldArray, new RemoveCorpusImportBuilder(corpus), parseResultBuilder);
            }
        }
        throw new SwitchException("Unknown parse type: " + parseType);
    }

    public static String checkType(String type) {
        switch (type) {
            case "creation": {
                return CREATION_TYPE;
            }
            case "change": {
                return CHANGE_TYPE;
            }
            case "remove": {
                return REMOVE_TYPE;
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }
}

