/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.parsers;

import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fichotheque.Fichotheque;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.corpus.metadata.SubfieldKey;
import net.fichotheque.tools.importation.ParseResultBuilder;
import net.fichotheque.tools.importation.corpus.CorpusImportBuilder;
import net.fichotheque.tools.importation.parsers.handlers.AttributeHandler;
import net.fichotheque.tools.importation.parsers.handlers.CroisementHandlers;
import net.fichotheque.tools.importation.parsers.handlers.FicheHandler;
import net.mapeadores.util.attr.AttributeKey;

class CorpusColumns {
    private final int idIndex;
    private final FicheHandler[] ficheHandlerArray;
    private final AttributeHandler[] attributeHandlerArray;
    private final CroisementHandlers croisementHandlers;
    private final int creationDateIndex;

    private CorpusColumns(int idIndex, FicheHandler[] ficheHandlerArray, AttributeHandler[] attributeHandlerArray, CroisementHandlers croisementHandlers, int creationDateIndex) {
        this.idIndex = idIndex;
        this.ficheHandlerArray = ficheHandlerArray;
        this.attributeHandlerArray = attributeHandlerArray;
        this.croisementHandlers = croisementHandlers;
        this.creationDateIndex = creationDateIndex;
    }

    public int getIdIndex() {
        return this.idIndex;
    }

    public boolean hasFicheHandler() {
        return this.ficheHandlerArray != null;
    }

    public FicheHandler[] getFicheHandlerArray() {
        return this.ficheHandlerArray;
    }

    public boolean hasAttributeHandler() {
        return this.attributeHandlerArray != null;
    }

    public AttributeHandler[] getAttributeHandlerArray() {
        return this.attributeHandlerArray;
    }

    public boolean hasCroisementHandler() {
        return !this.croisementHandlers.isEmpty();
    }

    public CroisementHandlers getCroisementHandlers() {
        return this.croisementHandlers;
    }

    public int getCreationDateIndex() {
        return this.creationDateIndex;
    }

    static CorpusColumns parse(String[] fieldArray, CorpusImportBuilder corpusImportBuilder, ParseResultBuilder parseResultBuilder) {
        Corpus corpus = corpusImportBuilder.getCorpus();
        Fichotheque fichotheque = corpus.getFichotheque();
        CorpusMetadata corpusMetadata = corpus.getCorpusMetadata();
        int idIndex = -1;
        int creationDateIndex = -1;
        int length = fieldArray.length;
        LinkedHashMap<Object, FicheHandler> ficheHandlerMap = new LinkedHashMap<Object, FicheHandler>();
        LinkedHashMap<AttributeKey, AttributeHandler> attributeHandlerMap = new LinkedHashMap<AttributeKey, AttributeHandler>();
        CroisementHandlers croisementHandlers = new CroisementHandlers(true, true);
        for (int i = 0; i < length; ++i) {
            String field = fieldArray[i].trim();
            try {
                FieldKey fieldKey = FieldKey.parse(field);
                if (CorpusColumns.isIdField(fieldKey)) {
                    if (idIndex == -1) {
                        idIndex = i;
                        continue;
                    }
                    parseResultBuilder.addInitWarning("DOUBLON_FIELD_INIT_WARNING", field);
                    continue;
                }
                CorpusColumns.addFieldKey(corpusMetadata, fieldKey, i, ficheHandlerMap, parseResultBuilder);
                continue;
            }
            catch (ParseException pe) {
                try {
                    SubfieldKey subfieldKey = SubfieldKey.parse(field);
                    CorpusColumns.addSubfieldKey(corpusMetadata, subfieldKey, i, ficheHandlerMap, parseResultBuilder);
                    continue;
                }
                catch (ParseException pe2) {
                    try {
                        AttributeKey attributeKey = AttributeKey.parse(field);
                        AttributeHandler attributeHandler = (AttributeHandler)attributeHandlerMap.get(attributeKey);
                        if (attributeHandler == null) {
                            attributeHandler = new AttributeHandler(attributeKey);
                            attributeHandlerMap.put(attributeKey, attributeHandler);
                        }
                        attributeHandler.addIndex(i);
                        continue;
                    }
                    catch (ParseException pe3) {
                        if (field.equals("date_creation")) {
                            if (creationDateIndex != -1) {
                                parseResultBuilder.addInitWarning("DOUBLON_FIELD_INIT_WARNING", field);
                                continue;
                            }
                            creationDateIndex = i;
                            continue;
                        }
                        if (field.equals("date_modification") || croisementHandlers.testCroisementHandlerCandidate(fichotheque, field, i, parseResultBuilder)) continue;
                        parseResultBuilder.addInitWarning("MALFORMED_FIELD_INIT_WARNING", field);
                    }
                }
            }
        }
        FicheHandler[] ficheHandlerArray = null;
        int ficheHandlerSize = ficheHandlerMap.size();
        if (ficheHandlerSize > 0) {
            ficheHandlerArray = ficheHandlerMap.values().toArray(new FicheHandler[ficheHandlerSize]);
        }
        AttributeHandler[] attributeHandlerArray = null;
        int attributeHandlerSize = attributeHandlerMap.size();
        if (attributeHandlerSize > 0) {
            attributeHandlerArray = attributeHandlerMap.values().toArray(new AttributeHandler[attributeHandlerSize]);
        }
        return new CorpusColumns(idIndex, ficheHandlerArray, attributeHandlerArray, croisementHandlers, creationDateIndex);
    }

    private static void addFieldKey(CorpusMetadata corpusMetadata, FieldKey fieldKey, int index, Map<Object, FicheHandler> ficheHandlerMap, ParseResultBuilder parseResultBuilder) {
        CorpusField corpusField = corpusMetadata.getCorpusField(fieldKey);
        if (corpusField == null) {
            parseResultBuilder.addInitWarning("UNKNOWN_FIELD_INIT_WARNING", fieldKey.getKeyString());
        } else {
            boolean done;
            FicheHandler ficheHandler = ficheHandlerMap.get(fieldKey);
            if (ficheHandler == null) {
                ficheHandler = FicheHandler.fromCorpusField(corpusField);
                ficheHandlerMap.put(fieldKey, ficheHandler);
            }
            if (!(done = ficheHandler.addIndex(index))) {
                parseResultBuilder.addInitWarning("DOUBLON_FIELD_INIT_WARNING", fieldKey.getKeyString());
            }
        }
    }

    private static void addSubfieldKey(CorpusMetadata corpusMetadata, SubfieldKey subfieldKey, int index, Map<Object, FicheHandler> ficheHandlerMap, ParseResultBuilder parseResultBuilder) {
        CorpusField corpusField = corpusMetadata.getCorpusField(subfieldKey.getFieldKey());
        if (corpusField == null) {
            parseResultBuilder.addInitWarning("UNKNOWN_FIELD_INIT_WARNING", subfieldKey.getFieldKey().getKeyString());
        } else {
            boolean done;
            FicheHandler ficheHandler = ficheHandlerMap.get(subfieldKey);
            if (ficheHandler == null) {
                ficheHandler = FicheHandler.fromSubfield(corpusField, subfieldKey);
                ficheHandlerMap.put(subfieldKey, ficheHandler);
            }
            if (!(done = ficheHandler.addIndex(index))) {
                parseResultBuilder.addInitWarning("DOUBLON_FIELD_INIT_WARNING", subfieldKey.getFieldKey().getKeyString());
            }
        }
    }

    private static boolean isIdField(FieldKey fieldKey) {
        switch (fieldKey.getKeyString()) {
            case "id": {
                return true;
            }
        }
        return false;
    }
}

