/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.history;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import net.fichotheque.EditOrigin;
import net.fichotheque.history.HistoryUnit;

public class HistoryUnitBuilder {
    private final List<HistoryUnit.Revision> revisionList = new ArrayList<HistoryUnit.Revision>();
    private boolean deleted = false;

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public void addRevision(String name, EditOrigin editOrigin) {
        EditOrigin[] array = new EditOrigin[]{editOrigin};
        this.addRevision(name, array);
    }

    public void addRevision(String name, Collection<EditOrigin> editOrigins) {
        EditOrigin[] array = editOrigins.toArray(new EditOrigin[editOrigins.size()]);
        this.addRevision(name, array);
    }

    private void addRevision(String name, EditOrigin[] array) {
        this.revisionList.add(new InternalRevision(name, new EditOriginList(array)));
    }

    public HistoryUnit toHistoryUnit() {
        RevisionList finalRevisionList = new RevisionList(this.revisionList.toArray(new HistoryUnit.Revision[this.revisionList.size()]));
        return new InternalHistoryUnit(this.deleted, finalRevisionList);
    }

    private static class InternalRevision
    implements HistoryUnit.Revision {
        private final String name;
        private final List<EditOrigin> editOriginList;

        private InternalRevision(String name, List<EditOrigin> editOriginList) {
            this.name = name;
            this.editOriginList = editOriginList;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public List<EditOrigin> getEditOriginList() {
            return this.editOriginList;
        }
    }

    private static class EditOriginList
    extends AbstractList<EditOrigin>
    implements RandomAccess {
        private final EditOrigin[] array;

        private EditOriginList(EditOrigin[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public EditOrigin get(int index) {
            return this.array[index];
        }
    }

    private static class RevisionList
    extends AbstractList<HistoryUnit.Revision>
    implements RandomAccess {
        private final HistoryUnit.Revision[] array;

        private RevisionList(HistoryUnit.Revision[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public HistoryUnit.Revision get(int index) {
            return this.array[index];
        }
    }

    private static class InternalHistoryUnit
    implements HistoryUnit {
        private final boolean deleted;
        private final List<HistoryUnit.Revision> revisionList;

        private InternalHistoryUnit(boolean deleted, List<HistoryUnit.Revision> revisionList) {
            this.deleted = deleted;
            this.revisionList = revisionList;
        }

        @Override
        public boolean isDeleted() {
            return this.deleted;
        }

        @Override
        public List<HistoryUnit.Revision> getRevisionList() {
            return this.revisionList;
        }
    }
}

