/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.from.html;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.fichotheque.tools.from.html.TagUtils;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

public final class SoupReorganizeEngine {
    private SoupReorganizeEngine() {
    }

    public static void run(Element root) {
        Block block = new Block(root);
        block.reorganize();
    }

    private static boolean isToBeScanned(Element element) {
        short tagType = TagUtils.getTagType(element);
        if (tagType != 2) {
            return false;
        }
        switch (element.tagName()) {
            case "a": {
                if (!SoupReorganizeEngine.imgIncludeInLinkTest(element)) break;
                return false;
            }
        }
        return true;
    }

    private static boolean isMoveCandidate(Node node) {
        if (!(node instanceof Element)) {
            return false;
        }
        Element element = (Element)node;
        short tagType = TagUtils.getTagType(element);
        if (tagType != 2) {
            return true;
        }
        if (element.childNodeSize() == 0) {
            return true;
        }
        switch (element.tagName()) {
            case "a": {
                if (!SoupReorganizeEngine.imgIncludeInLinkTest(element)) break;
                return true;
            }
        }
        return element.dataset().containsKey("bdf-type");
    }

    private static boolean imgIncludeInLinkTest(Element linkElement) {
        Element loneChild = TagUtils.getLoneChild(linkElement);
        return loneChild != null && loneChild.tagName().equals("img");
    }

    private static boolean isBlockCandidate(Node node) {
        if (!(node instanceof Element)) {
            return false;
        }
        return TagUtils.getTagType((Element)node) == 1;
    }

    private static boolean isBlank(Node node) {
        return node instanceof TextNode && ((TextNode)node).isBlank();
    }

    private static class Block {
        private Element root;
        private int nodeSize;
        private int currentIndex = 0;

        private Block(Element root) {
            this.root = root;
            this.nodeSize = root.childNodeSize();
        }

        private void reorganize() {
            while (this.currentIndex < this.nodeSize) {
                Inline inline;
                ScanResult scanResult;
                Element element;
                Node node = this.root.childNode(this.currentIndex);
                if (node instanceof Element && SoupReorganizeEngine.isToBeScanned(element = (Element)node) && (scanResult = (inline = new Inline(element)).scan()) != null) {
                    Element splittedIline;
                    List candidateToMoveList = scanResult.candidateToMoveList;
                    int size = candidateToMoveList.size();
                    if (size > 0) {
                        this.root.insertChildren(this.currentIndex + 1, (Collection)candidateToMoveList);
                        this.currentIndex += size;
                        this.nodeSize += size;
                    }
                    if ((splittedIline = scanResult.splittedInline) != null) {
                        this.root.insertChildren(this.currentIndex + 1, new Node[]{splittedIline});
                        ++this.nodeSize;
                    }
                }
                ++this.currentIndex;
            }
            for (Element child : this.root.children()) {
                if (!SoupReorganizeEngine.isBlockCandidate((Node)child)) continue;
                Block childBlock = new Block(child);
                childBlock.reorganize();
            }
        }
    }

    private static class ScanResult {
        private List<Node> candidateToMoveList = new ArrayList<Node>();
        private Element splittedInline = null;

        private ScanResult(Element firstMove) {
            this.candidateToMoveList.add((Node)firstMove);
        }

        private void addToMove(Node candidate) {
            this.candidateToMoveList.add(candidate);
        }
    }

    private static class Inline {
        private final Element root;
        private final int nodeSize;
        private int currentIndex = 0;

        private Inline(Element inlineElement) {
            this.root = inlineElement;
            this.nodeSize = this.root.childNodeSize();
        }

        private ScanResult scan() {
            while (this.currentIndex < this.nodeSize) {
                Node node = this.root.childNode(this.currentIndex);
                if (node instanceof Element) {
                    Element child = (Element)node;
                    if (SoupReorganizeEngine.isMoveCandidate((Node)child)) {
                        ScanResult scanResult = new ScanResult(child);
                        this.moveFollowers(scanResult);
                        return scanResult;
                    }
                    Inline childInline = new Inline(child);
                    ScanResult childScanResult = childInline.scan();
                    if (childScanResult != null) {
                        this.completeChildScanResult(childScanResult);
                        return childScanResult;
                    }
                }
                ++this.currentIndex;
            }
            return null;
        }

        private void completeChildScanResult(ScanResult childScanResult) {
            Element copy = this.root.shallowClone();
            if (childScanResult.splittedInline != null) {
                copy.appendChild((Node)childScanResult.splittedInline);
            }
            if (this.currentIndex < this.nodeSize - 1) {
                ArrayList<Node> remainingNodeList = new ArrayList<Node>();
                for (int i = this.currentIndex + 1; i < this.nodeSize; ++i) {
                    remainingNodeList.add(this.root.childNode(i));
                }
                for (Node node : remainingNodeList) {
                    copy.appendChild(node);
                }
            }
            if (copy.childNodeSize() > 0) {
                childScanResult.splittedInline = copy;
            }
        }

        private void moveFollowers(ScanResult scanResult) {
            int startIndex = this.currentIndex + 1;
            if (startIndex == this.nodeSize) {
                return;
            }
            ArrayList<Node> remainingNodeList = new ArrayList<Node>();
            for (int i = startIndex; i < this.nodeSize; ++i) {
                remainingNodeList.add(this.root.childNode(i));
            }
            Element copy = this.root.shallowClone();
            boolean CandidateTest = true;
            Node precedingBlankNode = null;
            for (Node remainingNode : remainingNodeList) {
                if (CandidateTest) {
                    if (SoupReorganizeEngine.isMoveCandidate(remainingNode)) {
                        if (precedingBlankNode != null) {
                            scanResult.addToMove(precedingBlankNode);
                        }
                        scanResult.addToMove((Node)((Element)remainingNode));
                        precedingBlankNode = null;
                    } else if (SoupReorganizeEngine.isBlank(remainingNode)) {
                        if (precedingBlankNode != null) {
                            scanResult.addToMove(precedingBlankNode);
                        }
                        precedingBlankNode = remainingNode;
                    } else {
                        CandidateTest = false;
                    }
                }
                if (CandidateTest) continue;
                if (precedingBlankNode != null) {
                    copy.appendChild(precedingBlankNode);
                    precedingBlankNode = null;
                }
                copy.appendChild(remainingNode);
            }
            if (copy.childNodeSize() > 0) {
                scanResult.splittedInline = copy;
            }
        }
    }
}

