/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.tokenizers.subfield;

import net.fichotheque.corpus.SubfieldValue;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.Geopoint;
import net.fichotheque.corpus.metadata.SubfieldKey;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.Tokenizer;
import net.fichotheque.format.Tokens;
import net.fichotheque.format.formatters.SubfieldFormatter;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.utils.FormatterUtils;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.primitives.DegreDecimal;

class GeopointProprieteTokenizer
implements Tokenizer {
    private final SubfieldKey subfieldKey;
    private final SubfieldFormatter subfieldFormatter;

    GeopointProprieteTokenizer(SubfieldKey subfieldKey, SubfieldFormatter subfieldFormatter) {
        this.subfieldKey = subfieldKey;
        this.subfieldFormatter = subfieldFormatter;
    }

    @Override
    public Tokens tokenize(FormatSource formatSource) {
        FicheItem ficheItem = (FicheItem)((FichePointeur)formatSource.getSubsetItemPointeur()).getValue(this.subfieldKey);
        if (ficheItem == null || !(ficheItem instanceof Geopoint)) {
            return FormatterUtils.EMPTY_TOKENS;
        }
        Geopoint geopoint = (Geopoint)ficheItem;
        DegreDecimal degreDecimal = this.getDegreDecimal(geopoint, this.subfieldKey.getSubtype());
        SubfieldValue subfieldValue = FormatterUtils.toSubfieldValue(degreDecimal.toString());
        String value = this.subfieldFormatter.formatSubfield(subfieldValue, formatSource);
        return FormatterUtils.toTokens(value);
    }

    public DegreDecimal getDegreDecimal(Geopoint geopoint, short subfieldType) {
        switch (subfieldType) {
            case 21: {
                return geopoint.getLatitude();
            }
            case 22: {
                return geopoint.getLongitude();
            }
        }
        throw new SwitchException("subfieldType = " + subfieldType);
    }
}

