/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.tokenizers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.croisement.Liaison;
import net.fichotheque.exportation.table.CellConverterProvider;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.format.FormatContext;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.SubsetPathKey;
import net.fichotheque.format.Tokenizer;
import net.fichotheque.format.Tokens;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.pointeurs.MotclePointeur;
import net.fichotheque.pointeurs.SubsetItemPointeur;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.tools.format.MultiTokensBuilder;
import net.fichotheque.utils.CroisementUtils;
import net.fichotheque.utils.pointeurs.PointeurFactory;

public class SubsetPathSourceTokenizer
implements Tokenizer {
    private final Fichotheque fichotheque;
    private final SubsetPathKey subsetPathKey;
    private final Tokenizer finalTokenizer;
    private final boolean globalSelect;

    public SubsetPathSourceTokenizer(Fichotheque fichotheque, SubsetPathKey subsetPathKey, Tokenizer finalTokenizer, boolean globalSelect) {
        this.fichotheque = fichotheque;
        this.subsetPathKey = subsetPathKey;
        this.finalTokenizer = finalTokenizer;
        this.globalSelect = globalSelect;
    }

    @Override
    public Tokens tokenize(FormatSource formatSource) {
        TokenizeEngine tokenizeEngine = new TokenizeEngine(formatSource, this.finalTokenizer);
        tokenizeEngine.resolveLevel(formatSource.getSubsetItemPointeur(), 0);
        return tokenizeEngine.toSourceTokens();
    }

    private class TokenizeEngine {
        private final FinalFormatSource finalFormatSource;
        private final Tokenizer finalTokenizer;
        private final MultiTokensBuilder builder = new MultiTokensBuilder();
        private final Predicate<SubsetItem> predicate;
        private final Predicate<Subset> subsetAccessPredicate;

        private TokenizeEngine(FormatSource formatSource, Tokenizer finalTokenizer) {
            this.subsetAccessPredicate = formatSource.getSubsetAccessPredicate();
            this.finalTokenizer = finalTokenizer;
            this.finalFormatSource = new FinalFormatSource(formatSource);
            this.predicate = SubsetPathSourceTokenizer.this.globalSelect ? formatSource.getGlobalPredicate() : null;
        }

        private void resolveLevel(SubsetItemPointeur parentPointeur, int level) {
            SubsetItem subsetItem = parentPointeur.getCurrentSubsetItem();
            if (subsetItem == null) {
                return;
            }
            short type = SubsetPathSourceTokenizer.this.subsetPathKey.getKeyType(level);
            switch (type) {
                case 1: {
                    this.resolveParentageLevel(parentPointeur, level);
                    break;
                }
                case 2: {
                    this.resolveCroisementLevel(parentPointeur, level);
                    break;
                }
                case 3: {
                    if (!(subsetItem instanceof Motcle)) {
                        throw new IllegalStateException("subsetItem must be an instance of Motcle");
                    }
                    this.resolveThesaurusTreeLevel((Motcle)subsetItem, level);
                }
            }
        }

        private void resolveThesaurusTreeLevel(Motcle motcle, int level) {
            List<Motcle> motcleList;
            boolean isLastLevel;
            MotclePointeur levelPointeur = PointeurFactory.newMotclePointeur(motcle.getThesaurus());
            boolean bl = isLastLevel = level == SubsetPathSourceTokenizer.this.subsetPathKey.getLength() - 1;
            if (isLastLevel) {
                this.finalFormatSource.setSubsetItemPointeur(levelPointeur);
            }
            if ((motcleList = this.getMotcleList(motcle, (String)SubsetPathSourceTokenizer.this.subsetPathKey.getKeyObject(level))).isEmpty()) {
                return;
            }
            for (Motcle other : motcleList) {
                levelPointeur.setCurrentSubsetItem(other);
                if (isLastLevel) {
                    this.builder.add(this.finalTokenizer.tokenize(this.finalFormatSource));
                    continue;
                }
                this.resolveLevel(levelPointeur, level + 1);
            }
        }

        private List<Motcle> getMotcleList(Motcle motcle, String type) {
            ArrayList<Motcle> result = new ArrayList<Motcle>();
            switch (type) {
                case "ancestors": {
                    this.addAncestors(motcle, result);
                    break;
                }
                case "parent": {
                    Motcle parent = motcle.getParent();
                    if (parent == null) break;
                    result.add(parent);
                    break;
                }
                case "children": {
                    for (Motcle child : motcle.getChildList()) {
                        result.add(child);
                    }
                    break;
                }
                case "descendants": {
                    this.addDescendants(motcle, result);
                    break;
                }
                case "siblings": {
                    this.addSiblings(motcle, result);
                }
            }
            return result;
        }

        private void addSiblings(Motcle motcle, List<Motcle> motcleList) {
            Motcle parent = motcle.getParent();
            List<Motcle> siblings = parent != null ? parent.getChildList() : motcle.getThesaurus().getFirstLevelList();
            for (Motcle sibling : siblings) {
                if (sibling.equals(motcle)) continue;
                motcleList.add(sibling);
            }
        }

        private void addAncestors(Motcle motcle, List<Motcle> motcleList) {
            Motcle parent = motcle.getParent();
            if (parent != null) {
                motcleList.add(parent);
                this.addAncestors(parent, motcleList);
            }
        }

        private void addDescendants(Motcle motcle, List<Motcle> motcleList) {
            for (Motcle child : motcle.getChildList()) {
                motcleList.add(child);
                this.addDescendants(child, motcleList);
            }
        }

        private void resolveParentageLevel(SubsetItemPointeur parentPointeur, int level) {
            SubsetKey subsetKey = (SubsetKey)SubsetPathSourceTokenizer.this.subsetPathKey.getKeyObject(level);
            SubsetItemPointeur parentagePointeur = parentPointeur.getParentagePointeur(subsetKey);
            if (!this.subsetAccessPredicate.test(parentagePointeur.getSubset())) {
                return;
            }
            SubsetItem subsetItem = parentagePointeur.getCurrentSubsetItem();
            if (this.predicate != null && subsetItem != null && !this.predicate.test(subsetItem)) {
                return;
            }
            if (level == SubsetPathSourceTokenizer.this.subsetPathKey.getLength() - 1) {
                this.finalFormatSource.setSubsetItemPointeur(parentagePointeur);
                this.builder.add(this.finalTokenizer.tokenize(this.finalFormatSource));
            } else {
                this.resolveLevel(parentagePointeur, level + 1);
            }
        }

        private void resolveCroisementLevel(SubsetItemPointeur parentPointeur, int level) {
            boolean isLastLevel;
            IncludeKey includeKey = (IncludeKey)SubsetPathSourceTokenizer.this.subsetPathKey.getKeyObject(level);
            Subset levelSubset = SubsetPathSourceTokenizer.this.fichotheque.getSubset(includeKey.getSubsetKey());
            if (levelSubset == null) {
                return;
            }
            if (!this.subsetAccessPredicate.test(levelSubset)) {
                return;
            }
            String mode = includeKey.getMode();
            int poids = includeKey.getPoidsFilter();
            SubsetItemPointeur levelSubsetItemPointeur = parentPointeur.getAssociatedPointeur(levelSubset);
            boolean bl = isLastLevel = level == SubsetPathSourceTokenizer.this.subsetPathKey.getLength() - 1;
            if (isLastLevel) {
                this.finalFormatSource.setSubsetItemPointeur(levelSubsetItemPointeur);
            }
            Croisements croisements = parentPointeur.getCroisements(levelSubset);
            Collection<Liaison> liaisons = CroisementUtils.filter(croisements, mode, poids, this.predicate);
            for (Liaison liaison : liaisons) {
                levelSubsetItemPointeur.setCurrentSubsetItem(liaison.getSubsetItem());
                if (isLastLevel) {
                    this.builder.add(this.finalTokenizer.tokenize(this.finalFormatSource));
                    continue;
                }
                this.resolveLevel(levelSubsetItemPointeur, level + 1);
            }
        }

        private Tokens toSourceTokens() {
            return this.builder.toTokens();
        }
    }

    private static class FinalFormatSource
    implements FormatSource {
        private final FormatSource orginalFormatSource;
        private SubsetItemPointeur subsetItemPointeur;

        private FinalFormatSource(FormatSource orginalFormatSource) {
            this.orginalFormatSource = orginalFormatSource;
        }

        @Override
        public SubsetItemPointeur getSubsetItemPointeur() {
            return this.subsetItemPointeur;
        }

        @Override
        public ExtractionContext getExtractionContext() {
            return this.orginalFormatSource.getExtractionContext();
        }

        @Override
        public Predicate<SubsetItem> getGlobalPredicate() {
            return this.orginalFormatSource.getGlobalPredicate();
        }

        @Override
        public FormatContext getFormatContext() {
            return this.orginalFormatSource.getFormatContext();
        }

        @Override
        public CellConverterProvider getCellConverterProvider() {
            return this.orginalFormatSource.getCellConverterProvider();
        }

        @Override
        public FormatSource.History getHistory() {
            return this.orginalFormatSource.getHistory();
        }

        @Override
        public FormatSource.ExtractionInfo getExtractionInfo() {
            return this.orginalFormatSource.getExtractionInfo();
        }

        private void setSubsetItemPointeur(SubsetItemPointeur subsetItemPointeur) {
            this.subsetItemPointeur = subsetItemPointeur;
        }
    }
}

