/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.formatters;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.fichotheque.Subset;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.format.FormatContext;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.Tokenizer;
import net.fichotheque.format.Tokens;
import net.fichotheque.format.formatters.FicheItemFormatter;
import net.fichotheque.format.formatters.SourceFormatter;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.pointeurs.SubsetItemPointeur;
import net.fichotheque.tools.format.GlobalToken;
import net.fichotheque.tools.format.formatters.FicheItemFormatterParser;
import net.fichotheque.tools.format.posttransform.Posttransformer;
import net.fichotheque.tools.format.tokenizers.FicheItemTokenizer;
import net.fichotheque.tools.format.tokenizers.TokenizerProvider;
import net.fichotheque.utils.FichothequeFormatUtils;
import net.mapeadores.util.format.FormatDef;
import net.mapeadores.util.format.FormatUtils;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.logging.MessageHandler;

public class FormatDefSourceFormatter
implements SourceFormatter {
    private final Subset subset;
    private final FieldKey defaultProprieteKey;
    private final int position;
    private final int limit;
    private final int maxLength;
    private final int fixedLength;
    private final char fixedChar;
    private final boolean fixedEmpty;
    private final boolean withUniqueTest;
    private final String defaultValue;
    private final FormatDef formatDef;
    private final TokenizerProvider.ByLang byLangProvider;
    private final String defaultSeparator;
    private final Posttransformer posttransformer;
    private final String prefix;
    private final String suffix;
    private FicheItemFormatter defaultPropItemFormatter;

    private FormatDefSourceFormatter(Subset subset, FormatDef formatDef, TokenizerProvider.ByLang byLangProvider, String defaultSeparator) {
        this.subset = subset;
        this.defaultProprieteKey = FichothequeFormatUtils.toFieldKey(formatDef.getParameterValue("defprop"));
        this.position = FormatUtils.getInt(formatDef, "pos");
        this.limit = FormatUtils.getInt(formatDef, "limit");
        this.maxLength = FormatUtils.getInt(formatDef, "maxlength");
        this.fixedLength = FormatUtils.getInt(formatDef, "fixedlength");
        this.fixedChar = FormatUtils.getChar(formatDef, "fixedchar");
        this.fixedEmpty = FormatUtils.getBoolean(formatDef, "fixedempty");
        this.defaultValue = FormatUtils.getString(formatDef, "defval");
        this.withUniqueTest = FormatUtils.getBoolean(formatDef, "unique");
        String posttransform = FormatUtils.getString(formatDef, "posttransform");
        this.posttransformer = Posttransformer.getPosttransformer(posttransform);
        this.prefix = FormatUtils.getPrefix(formatDef);
        this.suffix = FormatUtils.getSuffix(formatDef);
        this.formatDef = formatDef;
        this.byLangProvider = byLangProvider;
        this.defaultSeparator = defaultSeparator;
    }

    private void endInit(FormatContext formatContext) {
        CorpusField corpusField;
        if (this.subset instanceof Corpus && this.defaultProprieteKey != null && (corpusField = ((Corpus)this.subset).getCorpusMetadata().getCorpusField(this.defaultProprieteKey)) != null) {
            FicheItemTokenizer fifr;
            Tokenizer tokenizer = this.byLangProvider.getTokenizerList(null).get(0);
            this.defaultPropItemFormatter = tokenizer instanceof FicheItemTokenizer ? ((fifr = (FicheItemTokenizer)tokenizer).isSameType(corpusField.getFicheItemType()) ? fifr.getFicheItemFormatter() : FicheItemFormatterParser.parse(corpusField, null, formatContext, (MessageHandler)LogUtils.NULL_MULTIMESSAGEHANDLER)) : FicheItemFormatterParser.parse(corpusField, null, formatContext, (MessageHandler)LogUtils.NULL_MULTIMESSAGEHANDLER);
        }
    }

    public static FormatDefSourceFormatter build(Subset subset, FormatDef formatDef, TokenizerProvider.ByLang byLangProvider, String defaultSeparator, FormatContext formatContext) {
        FormatDefSourceFormatter formatDefConverter = new FormatDefSourceFormatter(subset, formatDef, byLangProvider, defaultSeparator);
        formatDefConverter.endInit(formatContext);
        return formatDefConverter;
    }

    @Override
    public String formatSource(FormatSource formatSource) {
        this.testSubsetItemPointeur(formatSource.getSubsetItemPointeur());
        String result = this.format(formatSource);
        if (result == null) {
            result = this.getDefaultString(formatSource);
        }
        if (result != null) {
            if (this.prefix != null) {
                result = this.prefix + result;
            }
            if (this.suffix != null) {
                result = result + this.suffix;
            }
        }
        if (this.posttransformer != null) {
            result = this.posttransformer.posttransform(result);
        }
        if (this.maxLength > 0) {
            if (result != null && result.length() > this.maxLength) {
                result = result.substring(0, this.maxLength);
            }
        } else if (this.fixedLength > 0) {
            StringBuilder buf = new StringBuilder();
            int start = 0;
            if (result != null) {
                int currentLength = result.length();
                if (currentLength == 0 && !this.fixedEmpty) {
                    return "";
                }
                if (currentLength <= this.fixedLength) {
                    buf.append(result);
                    start = currentLength;
                } else {
                    buf.append(result, 0, this.fixedLength);
                    start = this.fixedLength;
                }
            } else if (!this.fixedEmpty) {
                return null;
            }
            for (int i = start; i < this.fixedLength; ++i) {
                buf.append(this.fixedChar);
            }
            result = buf.toString();
        }
        return result;
    }

    private void testSubsetItemPointeur(SubsetItemPointeur subsetItemPointeur) {
        if (this.subset instanceof Corpus && !(subsetItemPointeur instanceof FichePointeur)) {
            throw new IllegalArgumentException("subsetItemPointeur must be an instance of FichePointeur");
        }
    }

    private String format(FormatSource formatSource) {
        List<Tokenizer> tokenizerList = this.byLangProvider.getTokenizerList(formatSource.getDefaultLang());
        int tokenizerLength = tokenizerList.size();
        if (tokenizerLength == 0) {
            return null;
        }
        if (this.position == 999999999) {
            for (int i = tokenizerLength - 1; i >= 0; --i) {
                Tokenizer tokenizer = tokenizerList.get(i);
                Tokens tokens = tokenizer.tokenize(formatSource);
                int size = tokens.size();
                if (size <= 0) continue;
                return (String)tokens.get(size - 1);
            }
            return null;
        }
        int rangeStart = this.position;
        int rangeLength = this.limit;
        if (this.position != -1) {
            if (this.limit == -1) {
                rangeLength = 1;
            }
        } else {
            rangeStart = 0;
        }
        ArrayList<GlobalToken> globalTokenList = new ArrayList<GlobalToken>();
        for (int i = 0; i < tokenizerLength; ++i) {
            Tokenizer tokenizer = tokenizerList.get(i);
            Tokens tokens = tokenizer.tokenize(formatSource);
            int size = tokens.size();
            for (int j = 0; j < size; ++j) {
                globalTokenList.add(new GlobalToken(i, tokens, j));
            }
        }
        StringBuilder buf = new StringBuilder();
        int globalTokenLength = globalTokenList.size();
        int formattedCount = 0;
        GlobalToken previousGlobalToken = null;
        HashSet<String> tokenSet = null;
        if (this.withUniqueTest) {
            tokenSet = new HashSet<String>();
        }
        for (int i = rangeStart; i < globalTokenLength; ++i) {
            GlobalToken globalToken = (GlobalToken)globalTokenList.get(i);
            String formattedString = globalToken.format();
            if (this.withUniqueTest) {
                if (tokenSet.contains(formattedString)) continue;
                tokenSet.add(formattedString);
            }
            if (previousGlobalToken != null) {
                buf.append(FormatDefSourceFormatter.getSeparator(previousGlobalToken, globalToken, this.formatDef, this.defaultSeparator));
            }
            buf.append(formattedString);
            previousGlobalToken = globalToken;
            if (rangeLength > 0 && ++formattedCount == rangeLength) break;
        }
        if (buf.length() == 0) {
            return null;
        }
        return buf.toString();
    }

    private String getDefaultString(FormatSource formatSource) {
        Object defObject;
        String defaultString = null;
        if (this.defaultPropItemFormatter != null && (defObject = ((FichePointeur)formatSource.getSubsetItemPointeur()).getValue(this.defaultProprieteKey)) != null && (defaultString = this.defaultPropItemFormatter.formatFicheItem((FicheItem)defObject, formatSource)).length() == 0) {
            defaultString = null;
        }
        if (defaultString == null) {
            defaultString = this.defaultValue;
        }
        return defaultString;
    }

    private static String getSeparator(GlobalToken firstToken, GlobalToken secondToken, FormatDef formatDef, String defaultSeparator) {
        int secondIndex;
        int firstIndex = firstToken.getTokensIndex();
        if (firstIndex != (secondIndex = secondToken.getTokensIndex())) {
            return FormatUtils.getSourceSeparator(formatDef, firstIndex, secondIndex, defaultSeparator);
        }
        return FormatUtils.getInnerSeparator(formatDef, firstIndex, defaultSeparator);
    }
}

