/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction.syntaxes;

import net.fichotheque.tools.extraction.syntaxes.AbstractStepResolver;

public final class CssResolver
extends AbstractStepResolver {
    private static final short TAG_STEP = 1;
    private static final short ID_STEP = 2;
    private static final short CLASS_STEP = 3;
    private static final short CONDITION_STEP = 4;
    private static final short ONQUOTE_STEP = 5;
    private static final short WAITING_TOKEN_STEP = 11;

    private CssResolver(String text) {
        super(text);
        this.step = 11;
    }

    private String resolve() {
        int length = this.text.length();
        block4: for (int i = 0; i < length; ++i) {
            char carac = this.text.charAt(i);
            switch (carac) {
                case ' ': {
                    this.resolveSpace();
                    continue block4;
                }
                case ',': {
                    this.resolveSeparator();
                    continue block4;
                }
                default: {
                    this.resolveChar(carac);
                }
            }
        }
        return this.end();
    }

    private void resolveSpace() {
        boolean appendToCurrent = false;
        switch (this.step) {
            case 5: {
                appendToCurrent = true;
                break;
            }
            default: {
                this.flush();
                this.step = 11;
            }
        }
        if (appendToCurrent) {
            this.appendToCurrent(' ');
        } else {
            this.appendSpaceToFinal();
        }
    }

    private void resolveSeparator() {
        boolean appendToCurrent = false;
        switch (this.step) {
            case 5: {
                appendToCurrent = true;
                break;
            }
            default: {
                this.flush();
                this.step = 11;
            }
        }
        if (appendToCurrent) {
            this.appendToCurrent(',');
        } else {
            this.appendOperator(",");
        }
    }

    private void resolveChar(char carac) {
        boolean appendToCurrent = true;
        block0 : switch (this.step) {
            case 11: {
                switch (carac) {
                    case '#': {
                        this.flush();
                        this.step = 2;
                        break block0;
                    }
                    case '.': {
                        this.flush();
                        this.step = 3;
                        break block0;
                    }
                }
                this.flush();
                this.step = 1;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                switch (carac) {
                    case '.': {
                        this.flush();
                        this.step = 3;
                        break;
                    }
                    case '[': {
                        this.flush();
                        this.appendOperator("[");
                        appendToCurrent = false;
                        this.step = 4;
                    }
                }
                break;
            }
            case 4: {
                switch (carac) {
                    case ']': {
                        this.flush();
                        this.appendOperator("]");
                        appendToCurrent = false;
                        this.step = 1;
                    }
                }
            }
        }
        if (appendToCurrent) {
            this.appendToCurrent(carac);
        }
    }

    @Override
    public String getStepClassName(String textPart, boolean end) {
        switch (this.step) {
            case 1: {
                return "cm-tag";
            }
            case 2: {
                return "cm-builtin";
            }
            case 3: {
                return "cm-qualifier";
            }
            case 4: {
                return "cm-property";
            }
        }
        return null;
    }

    public static String resolve(String value) {
        if (value.isEmpty()) {
            return "";
        }
        CssResolver cssResolver = new CssResolver(value);
        return cssResolver.resolve();
    }
}

