/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction.corpus;

import java.util.SortedMap;
import java.util.TreeMap;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.croisement.Croisement;
import net.fichotheque.extraction.def.FicheFilter;
import net.fichotheque.extraction.def.GroupClause;
import net.fichotheque.extraction.run.FicheGroup;
import net.fichotheque.tools.extraction.corpus.GroupBuilder;
import net.fichotheque.tools.extraction.corpus.GroupEngine;
import net.fichotheque.tools.extraction.corpus.GroupEngineProvider;

class PoidsEngine
extends GroupEngine {
    private final SortedMap<Integer, GroupBuilder> treeMap = new TreeMap<Integer, GroupBuilder>();
    private final GroupClause groupClause;
    private final GroupEngineProvider subGroupEngineProvider;

    PoidsEngine(GroupClause groupClause, GroupEngineProvider subGroupEngineProvider) {
        this.groupClause = groupClause;
        this.subGroupEngineProvider = subGroupEngineProvider;
    }

    @Override
    public void add(FicheMeta ficheMeta, FicheFilter ficheFilter, Croisement croisement) {
        Integer poidsInteger;
        GroupBuilder groupBuilder;
        int poids = 0;
        if (croisement != null) {
            poids = croisement.getLienList().get(0).getPoids();
        }
        if ((groupBuilder = (GroupBuilder)this.treeMap.get(poidsInteger = Integer.valueOf(poids))) == null) {
            groupBuilder = GroupBuilder.newInstance(poidsInteger.toString(), this.groupClause.getTagNameInfo(), this.subGroupEngineProvider);
            this.treeMap.put(poidsInteger, groupBuilder);
        }
        groupBuilder.add(ficheMeta, ficheFilter, croisement);
    }

    @Override
    public FicheGroup[] toFicheGroupArray() {
        return PoidsEngine.toGroupArray(this.treeMap.values(), this.groupClause, null);
    }
}

