/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction.builders;

import java.util.AbstractList;
import java.util.List;
import java.util.RandomAccess;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.extraction.def.AddendaExtractDef;
import net.fichotheque.extraction.def.AlbumExtractDef;
import net.fichotheque.extraction.def.CorpusExtractDef;
import net.fichotheque.extraction.def.DocumentFilter;
import net.fichotheque.extraction.def.FicheFilter;
import net.fichotheque.extraction.def.IllustrationFilter;
import net.fichotheque.extraction.def.MotcleFilter;
import net.fichotheque.extraction.def.SubsetExtractDef;
import net.fichotheque.extraction.def.ThesaurusExtractDef;
import net.fichotheque.extraction.filterunit.FilterUnit;
import net.fichotheque.include.ExtendedIncludeKey;
import net.fichotheque.selection.CroisementCondition;
import net.fichotheque.selection.DocumentQuery;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.selection.IllustrationQuery;
import net.fichotheque.selection.MotcleQuery;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.extraction.builders.AddendaExtractDefBuilder;
import net.fichotheque.tools.extraction.builders.AlbumExtractDefBuilder;
import net.fichotheque.tools.extraction.builders.CorpusExtractDefBuilder;
import net.fichotheque.tools.extraction.builders.MotcleFilterBuilder;
import net.fichotheque.tools.extraction.builders.ThesaurusExtractDefBuilder;
import net.fichotheque.tools.selection.DocumentQueryBuilder;
import net.fichotheque.tools.selection.FicheQueryBuilder;
import net.fichotheque.tools.selection.IllustrationQueryBuilder;
import net.fichotheque.tools.selection.MotcleQueryBuilder;
import net.fichotheque.utils.FilterUnits;
import net.fichotheque.utils.SelectionUtils;
import net.fichotheque.xml.extraction.ExtractionXMLUtils;
import net.mapeadores.util.exceptions.SwitchException;

public final class ExtractionBuilderUtils {
    private ExtractionBuilderUtils() {
    }

    public static FilterUnit getDefaultFilterUnit(ExtendedIncludeKey includeKey, Fichotheque fichotheque) {
        SubsetExtractDef extractDef = ExtractionBuilderUtils.getDefaultExtractDef(includeKey, fichotheque);
        switch (extractDef.getCategory()) {
            case 1: {
                return FilterUnits.defaultCorpusExtract((CorpusExtractDef)extractDef, includeKey);
            }
            case 2: {
                return FilterUnits.defaultThesaurusExtract((ThesaurusExtractDef)extractDef, includeKey);
            }
            case 5: {
                return FilterUnits.defaultAlbumExtract((AlbumExtractDef)extractDef, includeKey);
            }
            case 4: {
                return FilterUnits.defaultAddendaExtract((AddendaExtractDef)extractDef, includeKey);
            }
        }
        throw new SwitchException("Unknown category: " + includeKey.getCategory());
    }

    public static SubsetExtractDef getDefaultExtractDef(ExtendedIncludeKey includeKey, Fichotheque fichotheque) {
        switch (includeKey.getCategory()) {
            case 1: {
                return ExtractionBuilderUtils.getCorpusExtractDef(includeKey, ExtractionXMLUtils.TITRE_FICHEFILTER);
            }
            case 2: {
                return ExtractionBuilderUtils.getThesaurusExtractDef(includeKey, ExtractionBuilderUtils.getDefaultMotcleFilter(includeKey, fichotheque));
            }
            case 5: {
                return ExtractionBuilderUtils.getAlbumExtractDef(includeKey, ExtractionXMLUtils.DEFAULT_ILLUSTRATIONFILTER);
            }
            case 4: {
                return ExtractionBuilderUtils.getAddendaExtractDef(includeKey, ExtractionXMLUtils.DEFAULT_DOCUMENTFILTER);
            }
        }
        throw new SwitchException("Unknown category: " + includeKey.getCategory());
    }

    private static MotcleFilter getDefaultMotcleFilter(ExtendedIncludeKey includeKey, Fichotheque fichotheque) {
        boolean withFicheStylePhrase = false;
        Subset subset = fichotheque.getSubset(includeKey.getSubsetKey());
        if (subset != null) {
            withFicheStylePhrase = ((Thesaurus)subset).getThesaurusMetadata().isWithFicheStyle();
        }
        return MotcleFilterBuilder.init((short)1).setWithIcon(true).setWithLabels(true).setWithFicheStylePhrase(withFicheStylePhrase).toMotcleFilter();
    }

    public static CorpusExtractDef getCorpusExtractDef(ExtendedIncludeKey includeKey, FicheFilter ficheFilter) {
        if (!includeKey.getSubsetKey().isCorpusSubset()) {
            throw new IllegalArgumentException("Not a corpus subsetkey");
        }
        FicheQuery ficheQuery = FicheQueryBuilder.init().addCorpus(includeKey.getSubsetKey()).toFicheQuery();
        CroisementCondition croisementCondition = SelectionUtils.toCroisementCondition(includeKey);
        return CorpusExtractDefBuilder.init(ficheFilter).setName(includeKey.getKeyString()).setBoolean("master", includeKey.isMaster()).setEntryList(SelectionUtils.toFicheConditionEntry(ficheQuery, croisementCondition, false)).toCorpusExtractDef();
    }

    public static ThesaurusExtractDef getThesaurusExtractDef(ExtendedIncludeKey includeKey, MotcleFilter motcleFilter) {
        if (!includeKey.getSubsetKey().isThesaurusSubset()) {
            throw new IllegalArgumentException("Not a thesaurus subsetkey");
        }
        MotcleQuery motcleQuery = MotcleQueryBuilder.init().addThesaurus(includeKey.getSubsetKey()).toMotcleQuery();
        CroisementCondition croisementCondition = SelectionUtils.toCroisementCondition(includeKey);
        return ThesaurusExtractDefBuilder.init(motcleFilter).setName(includeKey.getKeyString()).setBoolean("master", includeKey.isMaster()).setEntryList(SelectionUtils.toMotcleConditionEntry(motcleQuery, croisementCondition, false)).toThesaurusExtractDef();
    }

    public static AlbumExtractDef getAlbumExtractDef(ExtendedIncludeKey includeKey, IllustrationFilter illustrationFilter) {
        if (!includeKey.getSubsetKey().isAlbumSubset()) {
            throw new IllegalArgumentException("Not a album subsetkey");
        }
        IllustrationQuery illustrationQuery = IllustrationQueryBuilder.init().addAlbum(includeKey.getSubsetKey()).toIllustrationQuery();
        CroisementCondition croisementCondition = SelectionUtils.toCroisementCondition(includeKey);
        return AlbumExtractDefBuilder.init(illustrationFilter).setName(includeKey.getKeyString()).setEntryList(SelectionUtils.toIllustrationConditionEntry(illustrationQuery, croisementCondition)).toAlbumExtractDef();
    }

    public static AddendaExtractDef getAddendaExtractDef(ExtendedIncludeKey includeKey, DocumentFilter documentFilter) {
        if (!includeKey.getSubsetKey().isAddendaSubset()) {
            throw new IllegalArgumentException("Not a addenda subsetkey");
        }
        DocumentQuery documentQuery = DocumentQueryBuilder.init().addAddenda(includeKey.getSubsetKey()).toDocumentQuery();
        CroisementCondition croisementCondition = SelectionUtils.toCroisementCondition(includeKey);
        return AddendaExtractDefBuilder.init(documentFilter).setName(includeKey.getKeyString()).setEntryList(SelectionUtils.toDocumentConditionEntry(documentQuery, croisementCondition)).toAddendaExtractDef();
    }

    public static List<CorpusExtractDef> wrap(CorpusExtractDef[] array) {
        return new CorpusExtractDefList(array);
    }

    private static class CorpusExtractDefList
    extends AbstractList<CorpusExtractDef>
    implements RandomAccess {
        private final CorpusExtractDef[] array;

        private CorpusExtractDefList(CorpusExtractDef[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public CorpusExtractDef get(int index) {
            return this.array[index];
        }
    }
}

