/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.table.inclusionresolvers;

import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.Subset;
import net.fichotheque.exportation.table.Col;
import net.fichotheque.exportation.table.ColDef;
import net.fichotheque.exportation.table.FormatColDef;
import net.fichotheque.exportation.table.TableDef;
import net.fichotheque.exportation.table.TableExportContext;
import net.fichotheque.exportation.table.TableInclusionDef;
import net.fichotheque.exportation.table.TableInclusionResolver;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.SourceFormatter;
import net.fichotheque.tools.exportation.table.TableDefParser;
import net.fichotheque.tools.format.FichothequeFormatDefEngine;
import net.fichotheque.utils.TableDefUtils;
import net.fichotheque.utils.TableExportUtils;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionParser;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangContext;
import net.mapeadores.util.localisation.ListLangContext;
import net.mapeadores.util.localisation.UserLangContext;
import net.mapeadores.util.logging.LineMessageHandler;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.text.Labels;

public class MultilangInclusionResolver
implements TableInclusionResolver {
    public static final String NAMESPACE = "multilang";

    @Override
    public boolean test(TableInclusionDef tableInclusionDef, Subset subset, TableExportContext tableExportContext, int lineNumber, LineMessageHandler lineMessageHandler) {
        String nameSpace = tableInclusionDef.getNameSpace();
        if (!nameSpace.equals(NAMESPACE)) {
            return false;
        }
        Col[] colArray = this.build(tableInclusionDef, subset, tableExportContext, lineNumber, lineMessageHandler);
        return colArray.length > 0;
    }

    @Override
    public Col[] resolve(TableInclusionDef tableInclusionDef, Subset subset, TableExportContext tableExportContext) {
        String nameSpace = tableInclusionDef.getNameSpace();
        if (!nameSpace.equals(NAMESPACE)) {
            return TableExportUtils.EMPTY_COLARRAY;
        }
        return this.build(tableInclusionDef, subset, tableExportContext, 1, LogUtils.NULL_LINEMESSAGEHANDLER);
    }

    private Col[] build(TableInclusionDef tableInclusionDef, Subset subset, TableExportContext tableExportContext, int lineNumber, LineMessageHandler lineMessageHandler) {
        List<String> configLineList = tableInclusionDef.getConfigLineList();
        int lineLength = configLineList.size();
        if (lineLength < 2) {
            return TableExportUtils.EMPTY_COLARRAY;
        }
        String colnameLine = configLineList.get(0);
        if (colnameLine.startsWith("%") || colnameLine.startsWith("!")) {
            return TableExportUtils.EMPTY_COLARRAY;
        }
        String patternLine = null;
        String instructionLine = null;
        if (lineLength > 2) {
            patternLine = configLineList.get(2);
            if (lineLength > 3) {
                instructionLine = configLineList.get(3);
            }
        }
        Instruction instruction = InstructionParser.parse(configLineList.get(1), LogUtils.encapsulate(lineMessageHandler, "severe.format.syntax", lineNumber + 2));
        HashMap<Lang, SourceFormatter> langMap = new HashMap<Lang, SourceFormatter>();
        FormatColDef firstColDef = null;
        for (Argument argument : instruction) {
            String value = argument.getValue();
            if (value.length() <= 0) continue;
            try {
                FormatColDef formatColDef;
                SourceFormatter sourceFormatter;
                TableDef tableDef;
                Lang lang = Lang.parse(argument.getKey());
                StringBuilder buf = new StringBuilder();
                buf.append(colnameLine);
                buf.append('\n');
                buf.append(value);
                buf.append('\n');
                if (patternLine != null) {
                    buf.append(patternLine);
                    buf.append('\n');
                    if (instructionLine != null) {
                        buf.append(instructionLine);
                        buf.append('\n');
                    }
                }
                if ((tableDef = TableDefParser.parse(buf.toString(), subset, tableExportContext, lineMessageHandler, lineNumber)).getDefItemList().isEmpty() || (sourceFormatter = FichothequeFormatDefEngine.compute(subset, (formatColDef = (FormatColDef)tableDef.getDefItemList().get(0)).getFichothequeFormatDef(), TableDefUtils.toFormatDefMessageHandler(lineMessageHandler, lineNumber), FichothequeFormatDefEngine.parameters(tableExportContext.getFormatContext()).defaultGlobalSelect(true).ignoreMissingCorpusField(false))) == null) continue;
                if (firstColDef == null) {
                    firstColDef = formatColDef;
                }
                langMap.put(lang, sourceFormatter);
            }
            catch (ParseException parseException) {}
        }
        if (firstColDef == null) {
            return TableExportUtils.EMPTY_COLARRAY;
        }
        Col[] colArray = new Col[]{TableExportUtils.toCol(new MultilangColDef(firstColDef), new MultilangSourceFormatter(langMap))};
        return colArray;
    }

    private static class MultilangColDef
    implements ColDef {
        private final FormatColDef firstColDef;

        private MultilangColDef(FormatColDef firstColDef) {
            this.firstColDef = firstColDef;
        }

        @Override
        public String getColName() {
            return this.firstColDef.getColName();
        }

        @Override
        public Labels getCustomLabels() {
            return this.firstColDef.getCustomLabels();
        }

        @Override
        public Object getParameterValue(String paramKey) {
            return this.firstColDef.getParameterValue(paramKey);
        }
    }

    private static class MultilangSourceFormatter
    implements SourceFormatter {
        private final Map<Lang, SourceFormatter> langMap;

        private MultilangSourceFormatter(Map<Lang, SourceFormatter> langMap) {
            this.langMap = langMap;
        }

        @Override
        public String formatSource(FormatSource formatSource) {
            LangContext langContext = formatSource.getLangContext();
            Lang lang = null;
            if (langContext instanceof ListLangContext) {
                lang = ((ListLangContext.Unit)((ListLangContext)langContext).get(0)).getLang();
            } else if (langContext instanceof UserLangContext) {
                lang = ((UserLangContext)langContext).getWorkingLang();
            }
            if (lang == null) {
                return null;
            }
            SourceFormatter sourceFormatter = this.langMap.get(lang);
            if (sourceFormatter == null) {
                return null;
            }
            return sourceFormatter.formatSource(formatSource);
        }
    }
}

