/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.table.dom;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.fichotheque.tools.exportation.table.TableExportDefBuilder;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import org.w3c.dom.Element;

public class TableExportDefDOMReader {
    private final TableExportDefBuilder tableExportDefBuilder;
    private final MessageHandler messageHandler;

    public TableExportDefDOMReader(TableExportDefBuilder tableExportDefBuilder, MessageHandler messageHandler) {
        this.tableExportDefBuilder = tableExportDefBuilder;
        this.messageHandler = messageHandler;
    }

    public TableExportDefDOMReader read(Element element) {
        DOMUtils.readChildren(element, new RootConsumer());
        return this;
    }

    public static TableExportDefDOMReader init(TableExportDefBuilder tableExportDefBuilder, MessageHandler messageHandler) {
        return new TableExportDefDOMReader(tableExportDefBuilder, messageHandler);
    }

    private class RootConsumer
    implements Consumer<Element> {
        private RootConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "label": {
                    try {
                        LabelUtils.readLabel(element, TableExportDefDOMReader.this.tableExportDefBuilder);
                    }
                    catch (ParseException ile) {
                        DomMessages.wrongLangAttribute(TableExportDefDOMReader.this.messageHandler, tagName, element.getAttribute("xml:lang"));
                    }
                    break;
                }
                case "langs": {
                    String langMode = element.getAttribute("mode");
                    if (langMode.length() > 0) {
                        TableExportDefDOMReader.this.tableExportDefBuilder.setLangMode(langMode);
                    }
                    ArrayList<Lang> resultList = new ArrayList<Lang>();
                    LangsUtils.readLangElements(resultList, element, TableExportDefDOMReader.this.messageHandler, tagName);
                    for (Lang lang : resultList) {
                        TableExportDefDOMReader.this.tableExportDefBuilder.addLang(lang);
                    }
                    break;
                }
                case "attr": {
                    AttributeUtils.readAttrElement(TableExportDefDOMReader.this.tableExportDefBuilder.getAttributesBuilder(), element);
                    break;
                }
                default: {
                    DomMessages.unknownTagWarning(TableExportDefDOMReader.this.messageHandler, tagName);
                }
            }
        }
    }
}

