/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.table.columnsum;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.fichotheque.exportation.table.SumResult;
import net.fichotheque.tools.exportation.table.columnsum.ColumnSumBuilder;
import net.mapeadores.util.money.Amount;
import net.mapeadores.util.money.ExtendedCurrency;

public class MoneyColumnSumBuilder
extends ColumnSumBuilder {
    private final SortedMap<ExtendedCurrency, ValueSum> currencyMap = new TreeMap<ExtendedCurrency, ValueSum>();

    public void sum(Amount amount) {
        ExtendedCurrency currency = amount.getCurrency();
        ValueSum valueSum = (ValueSum)this.currencyMap.get(currency);
        if (valueSum == null) {
            valueSum = new ValueSum();
            this.currencyMap.put(currency, valueSum);
        }
        valueSum.add(amount.getMoneyLong());
    }

    @Override
    public SumResult.ColumnSum toColumnSum() {
        int size = this.currencyMap.size();
        if (size == 0) {
            return null;
        }
        Amount[] resultArray = new Amount[size];
        int p = 0;
        for (Map.Entry<ExtendedCurrency, ValueSum> entry : this.currencyMap.entrySet()) {
            resultArray[p] = new Amount(entry.getValue().result, entry.getKey());
            ++p;
        }
        return new InternalMoneyColumnSum(resultArray);
    }

    private static class ValueSum {
        private long result = 0L;

        private ValueSum() {
        }

        private void add(long l) {
            this.result += l;
        }
    }

    private static class InternalMoneyColumnSum
    implements SumResult.MoneyColumnSum {
        private final Amount[] resultArray;

        private InternalMoneyColumnSum(Amount[] resultArray) {
            this.resultArray = resultArray;
        }

        @Override
        public int getResultCount() {
            return this.resultArray.length;
        }

        @Override
        public Amount getResult(int i) {
            return this.resultArray[i];
        }
    }
}

