/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.table;

import java.util.List;
import net.fichotheque.SubsetKey;
import net.fichotheque.exportation.table.TableDef;
import net.fichotheque.exportation.table.TableExportContentDescription;
import net.mapeadores.util.logging.LineMessageHandler;
import net.mapeadores.util.logging.MessageByLine;
import net.mapeadores.util.logging.SimpleLineMessageHandler;

public class TableExportContentDescriptionBuilder {
    private final SimpleLineMessageHandler lineMessageHandler = new SimpleLineMessageHandler();
    private final String path;
    private final String tableExportName;
    private String state = "unknown_name";
    private SubsetKey subsetKey;
    private TableDef tableDef;
    private boolean editable = true;

    public TableExportContentDescriptionBuilder(String path, String tableExportName) {
        this.path = path;
        this.tableExportName = tableExportName;
    }

    public LineMessageHandler getLineMessageHandler() {
        return this.lineMessageHandler;
    }

    public boolean hasMessage() {
        return this.lineMessageHandler.hasMessage();
    }

    public TableExportContentDescriptionBuilder setState(String state) {
        this.state = state;
        return this;
    }

    public TableExportContentDescriptionBuilder setSubsetKey(SubsetKey subsetKey) {
        this.subsetKey = subsetKey;
        return this;
    }

    public TableExportContentDescriptionBuilder setTableDef(TableDef tableDef) {
        this.tableDef = tableDef;
        return this;
    }

    public TableExportContentDescriptionBuilder setEditable(boolean editable) {
        this.editable = editable;
        return this;
    }

    public TableExportContentDescription toTableExportContentDescription() {
        return new InternalTableExportContentDescription(this.path, this.tableExportName, this.editable, this.state, this.subsetKey, this.tableDef, this.lineMessageHandler.toMessageByLineList());
    }

    public static TableExportContentDescriptionBuilder init(String path, String tableExportName) {
        return new TableExportContentDescriptionBuilder(path, tableExportName);
    }

    private static class InternalTableExportContentDescription
    implements TableExportContentDescription {
        private final String path;
        private final String tableExportName;
        private final boolean editable;
        private final String state;
        private final TableDef tableDef;
        private final SubsetKey subsetKey;
        private final List<MessageByLine> messageByLineList;

        private InternalTableExportContentDescription(String path, String tableExportName, boolean editable, String state, SubsetKey subsetKey, TableDef tableDef, List<MessageByLine> messageByLineList) {
            this.path = path;
            this.tableExportName = tableExportName;
            this.editable = editable;
            this.state = state;
            this.tableDef = tableDef;
            this.subsetKey = subsetKey;
            this.messageByLineList = messageByLineList;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public String getTableExportName() {
            return this.tableExportName;
        }

        @Override
        public String getState() {
            return this.state;
        }

        @Override
        public SubsetKey getSubsetKey() {
            return this.subsetKey;
        }

        @Override
        public TableDef getTableDef() {
            return this.tableDef;
        }

        @Override
        public List<MessageByLine> getMessageByLineList() {
            return this.messageByLineList;
        }

        @Override
        public boolean isEditable() {
            return this.editable;
        }
    }
}

