/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.balayage;

import java.util.ArrayList;
import java.util.List;
import net.fichotheque.exportation.balayage.BalayagePostscriptum;
import net.mapeadores.util.text.StringUtils;

public class BalayagePostscriptumBuilder {
    private final List<String> externalScriptNameList = new ArrayList<String>();
    private final List<String> scrutariExportNameList = new ArrayList<String>();
    private final List<String> sqlExportNameList = new ArrayList<String>();

    public BalayagePostscriptumBuilder addExternalScript(String name) {
        this.externalScriptNameList.add(name);
        return this;
    }

    public BalayagePostscriptumBuilder addScrutariExport(String name) {
        this.scrutariExportNameList.add(name);
        return this;
    }

    public BalayagePostscriptumBuilder addSqlExport(String name) {
        this.sqlExportNameList.add(name);
        return this;
    }

    public BalayagePostscriptum toBalayagePostscriptum() {
        return new InternalBalayagePostscriptum(StringUtils.toList(this.scrutariExportNameList), StringUtils.toList(this.sqlExportNameList), StringUtils.toList(this.externalScriptNameList));
    }

    public static BalayagePostscriptumBuilder init() {
        return new BalayagePostscriptumBuilder();
    }

    private static class InternalBalayagePostscriptum
    implements BalayagePostscriptum {
        private final List<String> scrutariExportNameList;
        private final List<String> sqlExportNameList;
        private final List<String> externalScriptNameList;

        private InternalBalayagePostscriptum(List<String> scrutariExportNameList, List<String> sqlExportNameList, List<String> externalScriptNameList) {
            this.scrutariExportNameList = scrutariExportNameList;
            this.sqlExportNameList = sqlExportNameList;
            this.externalScriptNameList = externalScriptNameList;
        }

        @Override
        public List<String> getScrutariExportNameList() {
            return this.scrutariExportNameList;
        }

        @Override
        public List<String> getSqlExportNameList() {
            return this.sqlExportNameList;
        }

        @Override
        public List<String> getExternalScriptNameList() {
            return this.externalScriptNameList;
        }
    }
}

