/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.eligibility;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.fichotheque.SubsetItem;

public class MultiPredicateBuilder {
    private List<Predicate<SubsetItem>> list = new ArrayList<Predicate<SubsetItem>>();

    public MultiPredicateBuilder add(Predicate<SubsetItem> predicate) {
        this.list.add(predicate);
        return this;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public Predicate<SubsetItem> toPredicate() {
        Predicate[] array = this.list.toArray(new Predicate[this.list.size()]);
        return new InternalPredicate(array);
    }

    public static MultiPredicateBuilder init() {
        return new MultiPredicateBuilder();
    }

    private static class InternalPredicate
    implements Predicate<SubsetItem> {
        private final Predicate<SubsetItem>[] array;

        private InternalPredicate(Predicate<SubsetItem>[] array) {
            this.array = array;
        }

        @Override
        public boolean test(SubsetItem subsetItem) {
            for (Predicate<SubsetItem> predicate : this.array) {
                if (predicate.test(subsetItem)) continue;
                return false;
            }
            return true;
        }
    }
}

