/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.duplication;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;

public class SubsetMatch {
    private final Subset originSubset;
    private final Subset destinationSubset;
    private final List<Entry> entryList = new ArrayList<Entry>();
    private final Map<Integer, Entry> originEntryMap = new HashMap<Integer, Entry>();
    private final Map<Integer, Entry> destinationEntryMap = new HashMap<Integer, Entry>();

    public SubsetMatch(Subset originSubset, Subset destinationSubset) {
        this.originSubset = originSubset;
        this.destinationSubset = destinationSubset;
    }

    public Subset getOriginSubset() {
        return this.originSubset;
    }

    public Subset getDestinationSubset() {
        return this.destinationSubset;
    }

    public int size() {
        return this.entryList.size();
    }

    public List<Entry> getEntryList() {
        return this.entryList;
    }

    public void add(SubsetItem origin, SubsetItem destination) {
        if (!origin.getSubset().equals(this.originSubset)) {
            throw new IllegalArgumentException("origin not from origin subset");
        }
        if (!destination.getSubset().equals(this.destinationSubset)) {
            throw new IllegalArgumentException("destination not from destination subset");
        }
        if (this.originEntryMap.containsKey(origin.getId())) {
            throw new IllegalArgumentException("origin already included");
        }
        if (this.destinationEntryMap.containsKey(destination.getId())) {
            throw new IllegalArgumentException("destination already included");
        }
        Entry entry = new Entry(origin, destination);
        this.originEntryMap.put(origin.getId(), entry);
        this.destinationEntryMap.put(destination.getId(), entry);
        this.entryList.add(entry);
    }

    public Entry getEntryByOrigin(int originId) {
        return this.originEntryMap.get(originId);
    }

    public Entry getEntryByDestination(int destinationId) {
        return this.destinationEntryMap.get(destinationId);
    }

    public static class Entry {
        private final SubsetItem origin;
        private final SubsetItem destination;

        private Entry(SubsetItem origin, SubsetItem destination) {
            this.origin = origin;
            this.destination = destination;
        }

        public SubsetItem getOrigin() {
            return this.origin;
        }

        public SubsetItem getDestination() {
            return this.destination;
        }
    }
}

