/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.dom;

import java.text.ParseException;
import java.util.function.Consumer;
import net.fichotheque.ExistingIdException;
import net.fichotheque.FichothequeConstants;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.ParentRecursivityException;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.mapeadores.util.exceptions.ImplementationException;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import org.w3c.dom.Element;

public class ThesaurusTreeDOMReader {
    private final ThesaurusEditor thesaurusEditor;
    private final MessageHandler messageHandler;

    public ThesaurusTreeDOMReader(ThesaurusEditor thesaurusEditor, MessageHandler messageHandler) {
        this.thesaurusEditor = thesaurusEditor;
        this.messageHandler = messageHandler;
    }

    public void fillThesaurus(Element element) {
        MotcleConsumer motcleConsumer = new MotcleConsumer(null, "/" + element.getTagName());
        DOMUtils.readChildren(element, motcleConsumer);
    }

    private void addMotcle(Element element, Motcle parent, String xpath) {
        Motcle motcle;
        int motcleid;
        String idString = element.getAttribute("id");
        if (idString.length() == 0) {
            idString = element.getAttribute("idths");
        }
        if (idString.length() == 0) {
            DomMessages.emptyAttribute(this.messageHandler, xpath, "id");
            return;
        }
        xpath = xpath + "[@id='" + idString + "']";
        try {
            motcleid = Integer.parseInt(idString);
        }
        catch (NumberFormatException nfe) {
            DomMessages.wrongIntegerAttributeValue(this.messageHandler, xpath, "id", idString);
            return;
        }
        String idalpha = null;
        if (this.thesaurusEditor.getThesaurus().isIdalphaType() && (idalpha = element.getAttribute("idalpha")).length() == 0) {
            DomMessages.emptyAttribute(this.messageHandler, xpath, "idalpha");
            return;
        }
        try {
            motcle = this.thesaurusEditor.createMotcle(motcleid, idalpha);
        }
        catch (ExistingIdException eie) {
            this.messageHandler.addMessage("severe.fichotheque", "_ error.existing.idalpha", idalpha);
            return;
        }
        catch (ParseException pe) {
            DomMessages.wrongAttributeValue(this.messageHandler, xpath, "idalpha", idalpha);
            return;
        }
        this.thesaurusEditor.setStatus(motcle, this.getStatus(element));
        if (parent != null) {
            try {
                this.thesaurusEditor.setParent(motcle, parent);
            }
            catch (ParentRecursivityException pre) {
                throw new ImplementationException(pre);
            }
        }
        DOMUtils.readChildren(element, new MotcleConsumer(motcle, xpath));
    }

    private String getStatus(Element element) {
        String status = "active";
        String statusAttr = element.getAttribute("status");
        if (!statusAttr.isEmpty()) {
            try {
                status = FichothequeConstants.checkMotcleStatus(statusAttr);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return status;
    }

    private class MotcleConsumer
    implements Consumer<Element> {
        private final Motcle parent;
        private final String parentXpath;

        private MotcleConsumer(Motcle parent, String parentXpath) {
            this.parent = parent;
            this.parentXpath = parentXpath;
        }

        @Override
        public void accept(Element element) {
            String tagname = element.getTagName();
            String xpath = this.parentXpath + "/" + tagname;
            if (tagname.equals("motcle")) {
                ThesaurusTreeDOMReader.this.addMotcle(element, this.parent, xpath);
            } else {
                DomMessages.unknownTagWarning(ThesaurusTreeDOMReader.this.messageHandler, xpath);
            }
        }
    }
}

