/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.dom;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fichotheque.SubsetItem;
import net.fichotheque.croisement.Croisement;
import net.fichotheque.croisement.CroisementChange;
import net.fichotheque.croisement.CroisementEditor;
import net.fichotheque.croisement.Lien;
import net.fichotheque.utils.CroisementUtils;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.AttributesBuilder;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import org.w3c.dom.Element;

public class CroisementDOMReader {
    private final CroisementEditor croisementEditor;
    private final MessageHandler messageHandler;
    private final RootConsumer rootConsumer = new RootConsumer();

    public CroisementDOMReader(CroisementEditor croisementEditor, MessageHandler messageHandler) {
        this.croisementEditor = croisementEditor;
        this.messageHandler = messageHandler;
    }

    public void readCroisement(Element element, SubsetItem subsetItem1, SubsetItem subsetItem2) {
        this.rootConsumer.clear();
        DOMUtils.readChildren(element, this.rootConsumer);
        this.rootConsumer.flush(subsetItem1, subsetItem2);
    }

    private class RootConsumer
    implements Consumer<Element> {
        private final Map<String, Lien> lienMap = new LinkedHashMap<String, Lien>();
        private AttributesBuilder attributesBuilder;

        private RootConsumer() {
        }

        private void clear() {
            this.lienMap.clear();
            this.attributesBuilder = null;
        }

        private void flush(SubsetItem subsetItem1, SubsetItem subsetItem2) {
            List<Lien> lienList = CroisementUtils.wrap(this.lienMap.values().toArray(new Lien[this.lienMap.size()]));
            InternalCroisementChange croisementChange = new InternalCroisementChange(lienList);
            Croisement croisement = CroisementDOMReader.this.croisementEditor.updateCroisement(subsetItem1, subsetItem2, croisementChange);
            if (croisement != null && this.attributesBuilder != null) {
                CroisementDOMReader.this.croisementEditor.getFichothequeEditor().putAttributes(croisement, this.attributesBuilder.toAttributes());
            }
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("lien")) {
                String mode = element.getAttribute("mode");
                int poids = this.getPoids(element);
                int position1 = this.getPosition(element, "position1");
                int position2 = this.getPosition(element, "position2");
                Lien lien = CroisementUtils.toLien(mode, poids, position1, position2);
                this.lienMap.put(mode, lien);
            } else if (tagName.equals("attr")) {
                if (this.attributesBuilder == null) {
                    this.attributesBuilder = new AttributesBuilder();
                }
                AttributeUtils.readAttrElement(this.attributesBuilder, element, CroisementDOMReader.this.messageHandler, tagName);
            } else {
                DomMessages.unknownTagWarning(CroisementDOMReader.this.messageHandler, tagName);
            }
        }

        private int getPoids(Element element) {
            int poids = 1;
            String poidsString = element.getAttribute("poids");
            if (poidsString.length() > 0) {
                try {
                    poids = Integer.parseInt(poidsString);
                    if (poids < 1) {
                        poids = 1;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return poids;
        }

        private int getPosition(Element element, String attributeName) {
            int position = 0;
            String posString = element.getAttribute(attributeName);
            if (posString.length() > 0) {
                try {
                    position = Integer.parseInt(posString);
                    if (position < 0) {
                        position = 0;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return position;
        }
    }

    private static class InternalCroisementChange
    implements CroisementChange {
        private final List<Lien> changedLienList;

        private InternalCroisementChange(List<Lien> changedLienList) {
            this.changedLienList = changedLienList;
        }

        @Override
        public List<String> getRemovedModeList() {
            return CroisementUtils.EMPTY_REMOVEDMODELIST;
        }

        @Override
        public List<Lien> getChangedLienList() {
            return this.changedLienList;
        }
    }
}

