/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.croisement;

import java.util.ArrayList;
import java.util.List;
import net.fichotheque.SubsetItem;
import net.fichotheque.croisement.CroisementChange;
import net.fichotheque.croisement.CroisementChanges;
import net.fichotheque.utils.CroisementUtils;
import net.fichotheque.utils.FichothequeUtils;

public class CroisementChangesBuilder {
    private final List<SubsetItem> removedList = new ArrayList<SubsetItem>();
    private final List<CroisementChanges.Entry> entryList = new ArrayList<CroisementChanges.Entry>();

    public CroisementChangesBuilder addRemoved(SubsetItem subsetItem) {
        this.removedList.add(subsetItem);
        return this;
    }

    public CroisementChangesBuilder addEntry(SubsetItem subsetItem, CroisementChange croisementChange) {
        this.entryList.add(CroisementUtils.toEntry(subsetItem, croisementChange));
        return this;
    }

    public CroisementChanges toCroisementChanges() {
        List<SubsetItem> finalRemovedList = FichothequeUtils.wrap(this.removedList.toArray(new SubsetItem[this.removedList.size()]));
        List<CroisementChanges.Entry> finalEntryList = CroisementUtils.wrap(this.entryList.toArray(new CroisementChanges.Entry[this.entryList.size()]));
        return new InternalCroisementChanges(finalRemovedList, finalEntryList);
    }

    public static CroisementChangesBuilder init() {
        return new CroisementChangesBuilder();
    }

    private static class InternalCroisementChanges
    implements CroisementChanges {
        private final List<SubsetItem> removedList;
        private final List<CroisementChanges.Entry> entryList;

        private InternalCroisementChanges(List<SubsetItem> removedList, List<CroisementChanges.Entry> entryList) {
            this.removedList = removedList;
            this.entryList = entryList;
        }

        @Override
        public List<SubsetItem> getRemovedList() {
            return this.removedList;
        }

        @Override
        public List<CroisementChanges.Entry> getEntryList() {
            return this.entryList;
        }
    }
}

