/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.corpus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.corpus.FicheChange;
import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.Information;
import net.fichotheque.corpus.fiche.Para;
import net.fichotheque.corpus.fiche.Propriete;
import net.fichotheque.corpus.fiche.Section;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.CleanedString;

public class FicheChangeBuilder {
    private final Map<FieldKey, Boolean> fieldKeyMap = new HashMap<FieldKey, Boolean>();
    private final Fiche fiche = new Fiche();

    public FicheChangeBuilder setTitre(CleanedString cs) {
        if (cs == null) {
            this.fieldKeyMap.put(FieldKey.TITRE, Boolean.FALSE);
            this.fiche.setTitre("");
        } else {
            this.fieldKeyMap.put(FieldKey.TITRE, Boolean.TRUE);
            this.fiche.setTitre(cs.toString());
        }
        return this;
    }

    public FicheChangeBuilder setLang(Lang lang) {
        if (lang == null) {
            this.fieldKeyMap.put(FieldKey.LANG, Boolean.FALSE);
            this.fiche.setLang(null);
        } else {
            this.fieldKeyMap.put(FieldKey.LANG, Boolean.TRUE);
            this.fiche.setLang(lang);
        }
        return this;
    }

    public FicheChangeBuilder setSoustitre(Para soustitrePara) {
        if (soustitrePara == null || soustitrePara.isEmpty()) {
            this.fieldKeyMap.put(FieldKey.SOUSTITRE, Boolean.FALSE);
            this.fiche.setSoustitre(null);
        } else {
            this.fieldKeyMap.put(FieldKey.SOUSTITRE, Boolean.TRUE);
            this.fiche.setSoustitre(soustitrePara);
        }
        return this;
    }

    public FicheChangeBuilder putRedacteurs(FicheItems ficheItems) {
        if (ficheItems == null || ficheItems.isEmpty()) {
            if (!this.fieldKeyMap.containsKey(FieldKey.REDACTEURS)) {
                this.fieldKeyMap.put(FieldKey.REDACTEURS, Boolean.FALSE);
            }
        } else {
            this.fieldKeyMap.put(FieldKey.REDACTEURS, Boolean.TRUE);
            this.fiche.appendRedacteurs(ficheItems);
        }
        return this;
    }

    public FicheChangeBuilder setPropriete(FieldKey fieldKey, FicheItem ficheItem) {
        this.fiche.setPropriete(fieldKey, ficheItem);
        if (ficheItem == null) {
            this.fieldKeyMap.put(fieldKey, Boolean.FALSE);
        } else {
            this.fieldKeyMap.put(fieldKey, Boolean.TRUE);
        }
        return this;
    }

    public FicheChangeBuilder putInformation(FieldKey fieldKey, FicheItems ficheItems) {
        if (ficheItems == null || ficheItems.isEmpty()) {
            if (!this.fieldKeyMap.containsKey(fieldKey)) {
                this.fieldKeyMap.put(fieldKey, Boolean.FALSE);
            }
        } else {
            this.fieldKeyMap.put(fieldKey, Boolean.TRUE);
            this.fiche.appendInformation(fieldKey, ficheItems);
        }
        return this;
    }

    public FicheChangeBuilder putSection(FieldKey fieldKey, FicheBlocks ficheBlocks) {
        if (ficheBlocks == null || ficheBlocks.isEmpty()) {
            if (!this.fieldKeyMap.containsKey(fieldKey)) {
                this.fieldKeyMap.put(fieldKey, Boolean.FALSE);
            }
        } else {
            this.fieldKeyMap.put(fieldKey, Boolean.TRUE);
            this.fiche.appendSection(fieldKey, ficheBlocks);
        }
        return this;
    }

    public FicheChangeBuilder removeField(FieldKey fieldKey) {
        block0 : switch (fieldKey.getCategory()) {
            case 1: {
                this.setPropriete(fieldKey, null);
                break;
            }
            case 2: {
                this.putInformation(fieldKey, null);
                break;
            }
            case 3: {
                this.putSection(fieldKey, null);
                break;
            }
            case 0: {
                switch (fieldKey.getKeyString()) {
                    case "titre": {
                        this.setTitre(null);
                        break block0;
                    }
                    case "soustitre": {
                        this.setSoustitre(null);
                        break block0;
                    }
                    case "lang": {
                        this.setLang(null);
                        break block0;
                    }
                    case "redacteurs": {
                        this.putRedacteurs(null);
                    }
                }
            }
        }
        return this;
    }

    public FicheChangeBuilder appendFiche(Fiche fiche) {
        FicheItems redacteurs;
        Para soustitre;
        Lang lang;
        CleanedString titre = CleanedString.newInstance(fiche.getTitre());
        if (titre != null) {
            this.setTitre(titre);
        }
        if ((lang = fiche.getLang()) != null) {
            this.setLang(lang);
        }
        if ((soustitre = fiche.getSoustitre()) != null) {
            this.setSoustitre(soustitre);
        }
        if ((redacteurs = fiche.getRedacteurs()) != null) {
            this.putRedacteurs(redacteurs);
        }
        for (Propriete propriete : fiche.getProprieteList()) {
            this.setPropriete(propriete.getFieldKey(), propriete.getFicheItem());
        }
        for (Information information : fiche.getInformationList()) {
            this.putInformation(information.getFieldKey(), information);
        }
        for (Section section : fiche.getSectionList()) {
            this.putSection(section.getFieldKey(), section);
        }
        return this;
    }

    public FicheChangeBuilder merge(FicheChangeBuilder otherFicheChangeBuilder) {
        Fiche otherFiche = otherFicheChangeBuilder.fiche;
        for (Information information : otherFiche.getInformationList()) {
            this.putInformation(information.getFieldKey(), information);
        }
        for (Section section : otherFiche.getSectionList()) {
            this.putSection(section.getFieldKey(), section);
        }
        FicheItems otherRedacteurs = otherFiche.getRedacteurs();
        if (otherRedacteurs != null) {
            this.putRedacteurs(otherRedacteurs);
        }
        for (Map.Entry<FieldKey, Boolean> entry : otherFicheChangeBuilder.fieldKeyMap.entrySet()) {
            FieldKey fieldKey;
            boolean b = entry.getValue();
            if (b || this.fieldKeyMap.containsKey(fieldKey = entry.getKey())) continue;
            this.fieldKeyMap.put(fieldKey, Boolean.FALSE);
        }
        return this;
    }

    public FicheChange toFicheChange() {
        boolean notEmpty = false;
        ArrayList<FieldKey> removedList = new ArrayList<FieldKey>();
        for (Map.Entry<FieldKey, Boolean> entry : this.fieldKeyMap.entrySet()) {
            Boolean b = entry.getValue();
            if (!b.booleanValue()) {
                removedList.add(entry.getKey());
                continue;
            }
            notEmpty = true;
        }
        Fiche ficheAPI = notEmpty ? this.fiche : null;
        List<FieldKey> finalRemovedList = CorpusMetadataUtils.wrap(removedList.toArray(new FieldKey[removedList.size()]));
        return new InternalFicheChange(ficheAPI, finalRemovedList);
    }

    public static FicheChangeBuilder init() {
        return new FicheChangeBuilder();
    }

    private static class InternalFicheChange
    implements FicheChange {
        private final FicheAPI ficheAPI;
        private final List<FieldKey> removedList;

        private InternalFicheChange(FicheAPI ficheAPI, List<FieldKey> removedList) {
            this.ficheAPI = ficheAPI;
            this.removedList = removedList;
        }

        @Override
        public FicheAPI getFicheAPI() {
            return this.ficheAPI;
        }

        @Override
        public List<FieldKey> getRemovedList() {
            return this.removedList;
        }
    }
}

