/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.conversion.imagetoillustration;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.IIOException;
import net.fichotheque.ExistingIdException;
import net.fichotheque.Fichotheque;
import net.fichotheque.album.AlbumEditor;
import net.fichotheque.album.Illustration;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.Image;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.croisement.CroisementEditor;
import net.fichotheque.syntax.FormSyntax;
import net.fichotheque.tools.croisement.CroisementChangeEngine;
import net.fichotheque.utils.AlbumUtils;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.images.ImagesUtils;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.MultiMessageHandler;
import net.mapeadores.util.text.StringUtils;

public class ImageToIllustrationConverter {
    private final MultiMessageHandler messageHandler;
    private final Map<String, Illustration> illustrationMap = new HashMap<String, Illustration>();
    private final AlbumEditor albumEditor;
    private final CroisementEditor croisementEditor;
    private final Fichotheque fichotheque;
    private final boolean testOnly;

    public ImageToIllustrationConverter(AlbumEditor albumEditor, CroisementEditor croisementEditor, MultiMessageHandler messageHandler, boolean testOnly) {
        this.albumEditor = albumEditor;
        this.croisementEditor = croisementEditor;
        this.messageHandler = messageHandler;
        this.fichotheque = albumEditor.getAlbum().getFichotheque();
        this.testOnly = testOnly;
    }

    public void convert(FicheMeta ficheMeta, FieldKey fieldKey, String baseUrl, String mode, int poids) {
        String currentURI = ficheMeta.getGlobalId();
        this.messageHandler.setCurrentSource(currentURI);
        CroisementChangeEngine croisementChangeEngine = CroisementChangeEngine.appendEngine(ficheMeta);
        FicheAPI ficheAPI = ficheMeta.getFicheAPI(false);
        switch (fieldKey.getCategory()) {
            case 1: {
                Illustration illustration;
                FicheItem ficheItem = (FicheItem)ficheAPI.getValue(fieldKey);
                if (ficheItem == null || (illustration = this.convertFicheItem(ficheItem, baseUrl, currentURI)) == null) break;
                croisementChangeEngine.addLien(illustration, mode, poids);
                break;
            }
            case 2: {
                FicheItems ficheItems = (FicheItems)ficheAPI.getValue(fieldKey);
                if (ficheItems == null) break;
                for (FicheItem ficheItem : ficheItems) {
                    Illustration illustration = this.convertFicheItem(ficheItem, baseUrl, currentURI);
                    if (illustration == null) continue;
                    croisementChangeEngine.addLien(illustration, mode, poids);
                }
                break;
            }
        }
        if (!this.testOnly) {
            this.croisementEditor.updateCroisements(ficheMeta, croisementChangeEngine.toCroisementChanges());
        }
    }

    private Illustration convertFicheItem(FicheItem ficheItem, String baseUrl, String currentURI) {
        String src;
        if (ficheItem instanceof Item) {
            src = ((Item)ficheItem).getValue();
        } else if (!(ficheItem instanceof Image)) {
            src = ((Image)ficheItem).getSrc();
        } else {
            this.addWarning("_ error.unsupported.ficheitemtype", FormSyntax.toString(ficheItem, this.fichotheque, null));
            return null;
        }
        return this.getIllustration(src, baseUrl, currentURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Illustration getIllustration(String src, String baseUrl, String currentURI) {
        Illustration illustration;
        block16: {
            String urlString = !StringUtils.isAbsoluteUrlString(src) ? baseUrl + src : src;
            if (this.illustrationMap.containsKey(urlString)) {
                return this.illustrationMap.get(urlString);
            }
            this.messageHandler.setCurrentSource(currentURI + "/" + urlString);
            File file = this.download(urlString);
            if (file == null) {
                return null;
            }
            if (this.testOnly) {
                file.delete();
                return null;
            }
            String fileName = file.getName();
            int idx = fileName.lastIndexOf(".");
            short formatType = AlbumUtils.formatTypeToShort(fileName.substring(idx + 1));
            try {
                Illustration illustration2;
                FileInputStream is = new FileInputStream(file);
                try {
                    Illustration illustration3 = this.albumEditor.createIllustration(-1, formatType);
                    this.albumEditor.updateIllustration(illustration3, is, formatType);
                    this.illustrationMap.put(urlString, illustration3);
                    illustration2 = illustration3;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (ExistingIdException eie) {
                        throw new ShouldNotOccurException("id= -1");
                    }
                    catch (IOException ioe) {
                        this.addWarning("_ error.exception.io", ioe.getMessage());
                        illustration = null;
                        break block16;
                    }
                    catch (ErrorMessageException eme) {
                        this.messageHandler.addMessage("warning.conversion", eme.getErrorMessage());
                        illustration = null;
                        break block16;
                    }
                }
                ((InputStream)is).close();
                return illustration2;
            }
            finally {
                file.delete();
            }
        }
        return illustration;
    }

    private File download(String urlString) {
        File file;
        block17: {
            String format;
            int idx;
            URL imageURL;
            try {
                imageURL = new URL(urlString);
            }
            catch (MalformedURLException mue) {
                this.addWarning("_ error.wrong.url", urlString);
                return null;
            }
            String protocol = imageURL.getProtocol();
            if (protocol == null || protocol.isEmpty()) {
                this.addWarning("_ error.wrong.url", urlString);
                return null;
            }
            if (!protocol.equals("http")) {
                this.addWarning("_ error.unknown.url_protocol", protocol);
                return null;
            }
            HttpURLConnection urlConnection = (HttpURLConnection)imageURL.openConnection();
            urlConnection.setInstanceFollowRedirects(true);
            urlConnection.connect();
            int code = urlConnection.getResponseCode();
            if (code != 200) {
                this.addWarning("_ error.unsupported.httpstatus", code);
                return null;
            }
            String mimetype = urlConnection.getContentType();
            if (mimetype != null && !mimetype.equals("application/octet-stream")) {
                idx = mimetype.indexOf("/");
                format = ImageToIllustrationConverter.checkExtension("img." + mimetype.substring(idx + 1));
                if (format == null) {
                    this.addWarning("_ error.unknown.url_mimetype", mimetype);
                    return null;
                }
            } else {
                idx = urlString.lastIndexOf("/");
                format = ImageToIllustrationConverter.checkExtension(urlString.substring(idx + 1));
                if (format == null) {
                    this.addWarning("_ error.unknown.extension", urlString.substring(idx + 1));
                    return null;
                }
            }
            InputStream is = urlConnection.getInputStream();
            try {
                byte[] array = IOUtils.toByteArray(is);
                file = this.saveTmpFile(array, format, urlString);
                if (is == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    this.addWarning("_ error.exception.io", ioe.getMessage());
                    return null;
                }
            }
            is.close();
        }
        return file;
    }

    private File saveTmpFile(byte[] array, String extension, String urlString) throws IOException {
        try {
            BufferedImage srcImg = ImagesUtils.read(new ByteArrayInputStream(array));
            if (srcImg == null) {
                this.addWarning("_ error.exception.iio", urlString);
                return null;
            }
        }
        catch (IIOException ioe) {
            if (ioe instanceof IIOException) {
                this.addWarning("_ error.exception.iio", ioe.getMessage());
            } else {
                this.addWarning("_ error.exception.io", ioe.getMessage());
            }
            return null;
        }
        catch (ErrorMessageException eme) {
            this.messageHandler.addMessage("warning.conversion", eme.getErrorMessage());
        }
        File tmpFile = File.createTempFile("illustration", "." + extension);
        try (FileOutputStream os = new FileOutputStream(tmpFile);){
            IOUtils.copy((InputStream)new ByteArrayInputStream(array), (OutputStream)os);
        }
        return tmpFile;
    }

    private void addWarning(String messageKey, Object messageValue) {
        this.messageHandler.addMessage("warning.conversion", LocalisationUtils.toMessage(messageKey, messageValue));
    }

    private static String checkExtension(String fileName) {
        int idx = fileName.lastIndexOf(".");
        if (idx == -1) {
            return null;
        }
        String extension = fileName.substring(idx + 1);
        if (extension.equalsIgnoreCase("png")) {
            return "png";
        }
        if (extension.equalsIgnoreCase("jpg")) {
            return "jpg";
        }
        if (extension.equalsIgnoreCase("jpeg")) {
            return "jpg";
        }
        return null;
    }
}

