/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.conversion.fieldtofield;

import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.Propriete;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.tools.conversion.fieldtofield.FieldToFieldConverter;
import net.fichotheque.utils.FicheUtils;
import net.mapeadores.util.logging.MultiMessageHandler;

class ProprieteToFicheItemField
extends FieldToFieldConverter {
    private final FieldKey sourceKey;
    private final FieldKey destinationKey;

    ProprieteToFicheItemField(FieldKey sourceKey, FieldKey destinationKey, MultiMessageHandler messageHandler) {
        super(messageHandler);
        this.sourceKey = sourceKey;
        this.destinationKey = destinationKey;
    }

    @Override
    void convertContent(Fiche fiche, boolean removeOldField) {
        Propriete source = fiche.getPropriete(this.sourceKey);
        if (source != null) {
            FicheItem ficheItem = source.getFicheItem();
            if (this.destinationKey.isPropriete()) {
                fiche.setPropriete(this.destinationKey, ficheItem);
            } else {
                fiche.appendInformation(this.destinationKey, FicheUtils.toFicheItems(ficheItem));
            }
            if (removeOldField) {
                fiche.setPropriete(this.sourceKey, null);
            }
        }
    }
}

