/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.conversion.fieldtofield;

import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.Information;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.tools.conversion.fieldtofield.FieldToFieldConverter;
import net.mapeadores.util.logging.MultiMessageHandler;

class InformationToFicheItemField
extends FieldToFieldConverter {
    private final FieldKey sourceKey;
    private final FieldKey destinationKey;

    InformationToFicheItemField(FieldKey sourceKey, FieldKey destinationKey, MultiMessageHandler messageHandler) {
        super(messageHandler);
        this.sourceKey = sourceKey;
        this.destinationKey = destinationKey;
    }

    @Override
    void convertContent(Fiche fiche, boolean removeOldField) {
        Information source = fiche.getInformation(this.sourceKey);
        if (source == null || source.isEmpty()) {
            return;
        }
        if (this.destinationKey.isPropriete()) {
            FicheItem ficheItem = (FicheItem)source.get(0);
            fiche.setPropriete(this.destinationKey, ficheItem);
            if (source.size() > 1) {
                this.addWarning("_ warning.conversion.manyficheitems", this.sourceKey.getKeyString());
            }
        } else {
            fiche.appendInformation(this.destinationKey, source);
        }
        if (removeOldField) {
            fiche.setInformation(this.sourceKey, null);
        }
    }
}

