/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.alias;

import java.util.HashMap;
import java.util.Map;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.alias.AliasChecker;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.alias.AliasUtils;
import net.mapeadores.util.logging.MessageHandler;

public class AliasHolderBuilder {
    private final Fichotheque fichotheque;
    private final MessageHandler messageHandler;
    private final AliasChecker aliasChecker;
    private final AliasHolder coreAliasHolder;
    private final Map<String, Corpus> corpusMap = new HashMap<String, Corpus>();
    private final Map<String, Thesaurus> thesaurusMap = new HashMap<String, Thesaurus>();
    private final Map<String, CorpusField> corpusFieldMap = new HashMap<String, CorpusField>();

    public AliasHolderBuilder(Fichotheque fichotheque, MessageHandler messageHandler, AliasChecker aliasChecker, AliasHolder coreAliasHolder) {
        this.fichotheque = fichotheque;
        this.messageHandler = messageHandler;
        this.aliasChecker = aliasChecker;
        this.coreAliasHolder = coreAliasHolder;
    }

    public AliasHolder toAliasHolder() {
        return new InternalAliasHolder(new HashMap<String, Corpus>(this.corpusMap), new HashMap<String, Thesaurus>(this.thesaurusMap), new HashMap<String, CorpusField>(this.corpusFieldMap));
    }

    public Corpus getCoreCorpus(String alias) {
        if (this.coreAliasHolder == null) {
            return null;
        }
        return this.coreAliasHolder.getCorpus(alias);
    }

    public Corpus initCorpus(String alias, SubsetKey corpusKey) {
        if (alias == null) {
            throw new IllegalArgumentException("alias is null");
        }
        if (corpusKey == null) {
            throw new IllegalArgumentException("corupsSubsetKey is null");
        }
        if (!corpusKey.isCorpusSubset()) {
            throw new IllegalArgumentException("!corpusKey.isCorpusSubset()");
        }
        short check = this.aliasChecker.checkCorpusAlias(alias);
        if (check == 0) {
            AliasUtils.unknownAlias(this.messageHandler, "corpus", alias);
            return null;
        }
        Corpus corpus = (Corpus)this.fichotheque.getSubset(corpusKey);
        if (check == 2 && corpus == null) {
            AliasUtils.missingSubset(this.messageHandler, alias, corpusKey);
            return null;
        }
        this.corpusMap.put(alias, corpus);
        return corpus;
    }

    public Thesaurus initThesaurus(String alias, SubsetKey thesaurusKey) {
        if (alias == null) {
            throw new IllegalArgumentException("alias is null");
        }
        if (thesaurusKey == null) {
            throw new IllegalArgumentException("thesaurusKey is null");
        }
        if (!thesaurusKey.isThesaurusSubset()) {
            throw new IllegalArgumentException("!thesaurusKey.isThesaurusSubset()");
        }
        short check = this.aliasChecker.checkThesaurusAlias(alias);
        if (check == 0) {
            AliasUtils.unknownAlias(this.messageHandler, "thesaurus", alias);
            return null;
        }
        Thesaurus thesaurus = (Thesaurus)this.fichotheque.getSubset(thesaurusKey);
        if (check == 2 && thesaurus == null) {
            AliasUtils.missingSubset(this.messageHandler, alias, thesaurusKey);
            return null;
        }
        this.thesaurusMap.put(alias, thesaurus);
        return thesaurus;
    }

    public void initField(Corpus corpus, String corpusAlias, String alias, FieldKey fieldKey) {
        if (alias == null) {
            throw new IllegalArgumentException("alias is null");
        }
        short check = this.aliasChecker.checkFieldAlias(corpusAlias, alias);
        if (check == 0) {
            AliasUtils.unknownAlias(this.messageHandler, "field", alias);
            return;
        }
        CorpusField corpusField = corpus.getCorpusMetadata().getCorpusField(fieldKey);
        if (check == 2 && corpusField == null) {
            AliasUtils.missingField(this.messageHandler, alias, fieldKey);
            return;
        }
        this.corpusFieldMap.put(alias, corpusField);
    }

    private class InternalAliasHolder
    implements AliasHolder {
        private final Map<String, Corpus> corpusMap;
        private final Map<String, Thesaurus> thesaurusMap;
        private final Map<String, CorpusField> corpusFieldMap;

        private InternalAliasHolder(Map<String, Corpus> corpusMap, Map<String, Thesaurus> thesaurusMap, Map<String, CorpusField> corpusFieldMap) {
            this.corpusMap = corpusMap;
            this.thesaurusMap = thesaurusMap;
            this.corpusFieldMap = corpusFieldMap;
        }

        @Override
        public Corpus getCorpus(String alias) {
            return this.corpusMap.get(alias);
        }

        @Override
        public Thesaurus getThesaurus(String alias) {
            return this.thesaurusMap.get(alias);
        }

        @Override
        public CorpusField getCorpusField(String alias) {
            return this.corpusFieldMap.get(alias);
        }
    }
}

