/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.importation;

import java.util.List;

public interface ParseResult {
    public String getType();

    public List<InitError> getInitErrorList();

    public List<InitWarning> getInitWarningList();

    public List<ParseError> getParseErrorList();

    public List<BdfError> getBdfErrorList();

    public List<ResultItem> getResultItemList();

    public String getPath();

    default public boolean isAllCorrect() {
        if (!this.getInitErrorList().isEmpty()) {
            return false;
        }
        if (!this.getInitWarningList().isEmpty()) {
            return false;
        }
        if (!this.getParseErrorList().isEmpty()) {
            return false;
        }
        return this.getBdfErrorList().isEmpty();
    }

    public static interface ResultItem {
        public Object getKeyObject();

        public Object getValueObject();

        public int getLineNumber();
    }

    public static interface BdfError {
        public String getKey();

        public String getText();

        public int getLineNumber();
    }

    public static interface ParseError {
        public String getRawText();

        public int getLineNumber();
    }

    public static interface InitWarning {
        public String getKey();

        public String getText();
    }

    public static interface InitError {
        public String getKey();

        public String getText();
    }
}

